/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.design;

import com.fasterxml.jackson.annotation.JsonSetter;
import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import net.sf.jasperreports.engine.JRChild;
import net.sf.jasperreports.engine.JRDefaultStyleProvider;
import net.sf.jasperreports.engine.JRElement;
import net.sf.jasperreports.engine.JRElementGroup;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRFrame;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.base.JRBaseElementGroup;
import net.sf.jasperreports.engine.base.JRBaseLineBox;
import net.sf.jasperreports.engine.design.JRDesignElement;
import net.sf.jasperreports.engine.design.JRDesignElementGroup;
import net.sf.jasperreports.engine.type.BorderSplitType;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.util.ElementsVisitorUtils;

public class JRDesignFrame
extends JRDesignElement
implements JRFrame {
    private static final long serialVersionUID = 10200L;
    public static final String PROPERTY_CHILDREN = "children";
    public static final String PROPERTY_BORDER_SPLIT_TYPE = "borderSplitType";
    private List<JRChild> children = new ArrayList<JRChild>();
    private JRLineBox lineBox = new JRBaseLineBox(this);
    private BorderSplitType borderSplitType;

    public JRDesignFrame(JRDefaultStyleProvider defaultStyleProvider) {
        super(defaultStyleProvider);
    }

    public JRDesignFrame() {
        this(null);
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitFrame(this);
        if (ElementsVisitorUtils.visitDeepElements(visitor)) {
            ElementsVisitorUtils.visitElements(visitor, this.children);
        }
    }

    @Override
    public JRElement[] getElements() {
        return JRBaseElementGroup.getElements(this.children);
    }

    public void addElement(JRElement element) {
        this.addElement(this.children.size(), element);
    }

    public void addElement(int index, JRElement element) {
        if (element instanceof JRDesignElement) {
            ((JRDesignElement)element).setElementGroup(this);
        }
        this.children.add(index, element);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CHILDREN, element, index);
    }

    public boolean removeElement(JRElement element) {
        int idx;
        if (element instanceof JRDesignElement) {
            ((JRDesignElement)element).setElementGroup(null);
        }
        if ((idx = this.children.indexOf(element)) >= 0) {
            this.children.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CHILDREN, element, idx);
            return true;
        }
        return false;
    }

    public void addElementGroup(JRElementGroup group) {
        this.addElementGroup(this.children.size(), group);
    }

    public void addElementGroup(int index, JRElementGroup group) {
        if (group instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)group).setElementGroup(this);
        }
        this.children.add(index, group);
        this.getEventSupport().fireCollectionElementAddedEvent(PROPERTY_CHILDREN, group, index);
    }

    public boolean removeElementGroup(JRElementGroup group) {
        int idx;
        if (group instanceof JRDesignElementGroup) {
            ((JRDesignElementGroup)group).setElementGroup(null);
        }
        if ((idx = this.children.indexOf(group)) >= 0) {
            this.children.remove(idx);
            this.getEventSupport().fireCollectionElementRemovedEvent(PROPERTY_CHILDREN, group, idx);
            return true;
        }
        return false;
    }

    @Override
    public List<JRChild> getChildren() {
        return this.children;
    }

    @Override
    public JRElement getElementByKey(String elementKey) {
        return JRBaseElementGroup.getElementByKey(this.getElements(), elementKey);
    }

    @Override
    public ModeEnum getMode() {
        return this.getStyleResolver().getMode(this, ModeEnum.TRANSPARENT);
    }

    @Override
    public JRLineBox getLineBox() {
        return this.lineBox;
    }

    @JsonSetter(value="box")
    public void copyBox(JRLineBox lineBox) {
        this.lineBox = lineBox.clone(this);
    }

    @Override
    public Color getDefaultLineColor() {
        return this.getForecolor();
    }

    @Override
    public BorderSplitType getBorderSplitType() {
        return this.borderSplitType;
    }

    public void setBorderSplitType(BorderSplitType borderSplitType) {
        BorderSplitType old = this.borderSplitType;
        this.borderSplitType = borderSplitType;
        this.getEventSupport().firePropertyChange(PROPERTY_BORDER_SPLIT_TYPE, old, this.borderSplitType);
    }

    @Override
    public Object clone() {
        JRDesignFrame clone = (JRDesignFrame)super.clone();
        if (this.children != null) {
            clone.children = new ArrayList<JRChild>(this.children.size());
            for (int i = 0; i < this.children.size(); ++i) {
                clone.children.add((JRChild)this.children.get(i).clone(clone));
            }
        }
        clone.lineBox = this.lineBox.clone(clone);
        return clone;
    }
}

