/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.fill;

import net.sf.jasperreports.engine.JRBreak;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExpressionCollector;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRVisitor;
import net.sf.jasperreports.engine.fill.JRBaseFiller;
import net.sf.jasperreports.engine.fill.JRFillCloneFactory;
import net.sf.jasperreports.engine.fill.JRFillCloneable;
import net.sf.jasperreports.engine.fill.JRFillElement;
import net.sf.jasperreports.engine.fill.JRFillObjectFactory;
import net.sf.jasperreports.engine.fill.JRTemplateElement;
import net.sf.jasperreports.engine.type.BreakTypeEnum;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRFillBreak
extends JRFillElement
implements JRBreak {
    private static final Log log = LogFactory.getLog(JRFillBreak.class);

    protected JRFillBreak(JRBaseFiller filler, JRBreak breakElement, JRFillObjectFactory factory) {
        super(filler, breakElement, factory);
    }

    protected JRFillBreak(JRFillBreak breakElement, JRFillCloneFactory factory) {
        super(breakElement, factory);
    }

    @Override
    public int getWidth() {
        int width;
        switch (this.getType()) {
            case PAGE: {
                width = this.filler.pageWidth - this.filler.leftMargin - this.filler.rightMargin;
                break;
            }
            default: {
                width = this.filler.columnWidth;
            }
        }
        return width;
    }

    @Override
    public BreakTypeEnum getType() {
        return BreakTypeEnum.getValueOrDefault(((JRBreak)this.parent).getType());
    }

    @Override
    public void setType(BreakTypeEnum type) {
        throw new UnsupportedOperationException();
    }

    @Override
    protected void evaluate(byte evaluation) throws JRException {
        this.reset();
        this.evaluatePrintWhenExpression(evaluation);
        this.evaluateProperties(evaluation);
        this.evaluateStyle(evaluation);
        this.setValueRepeating(true);
    }

    @Override
    protected JRPrintElement fill() {
        return null;
    }

    @Override
    protected JRTemplateElement createElementTemplate() {
        return null;
    }

    @Override
    public void collectExpressions(JRExpressionCollector collector) {
        collector.collect(this);
    }

    @Override
    public void visit(JRVisitor visitor) {
        visitor.visitBreak(this);
    }

    @Override
    protected void resolveElement(JRPrintElement element, byte evaluation) {
    }

    @Override
    public JRFillCloneable createClone(JRFillCloneFactory factory) {
        return new JRFillBreak(this, factory);
    }

    @Override
    public void rewind() {
    }

    @Override
    protected boolean prepare(int availableHeight, boolean isOverflow) throws JRException {
        super.prepare(availableHeight, isOverflow);
        if (!this.isToPrint()) {
            return false;
        }
        boolean isToPrint = true;
        if (isOverflow && this.isAlreadyPrinted()) {
            isToPrint = false;
        }
        if (isToPrint && availableHeight < this.getRelativeY() + this.getHeight()) {
            isToPrint = false;
        }
        if (isToPrint) {
            boolean paginationIgnored = this.filler.isIgnorePagination();
            if (this.getType() == BreakTypeEnum.COLUMN) {
                if (paginationIgnored) {
                    if (log.isTraceEnabled()) {
                        log.trace((Object)"unpaginated report, column break not triggered");
                    }
                } else if (!this.filler.isFirstColumnBand || this.band.atLeastOneElementIsToPrint) {
                    this.setPrepareHeight(availableHeight - this.getRelativeY());
                }
            } else if (!this.band.isPageBreakInhibited()) {
                boolean apply = true;
                if (paginationIgnored) {
                    String propValue = this.filler.getPropertiesUtil().getProperty(this, "net.sf.jasperreports.page.break.no.pagination");
                    boolean bl = apply = propValue != null && propValue.equals("apply");
                    if (log.isTraceEnabled()) {
                        log.trace((Object)("unpaginated report, page break appied " + apply));
                    }
                }
                if (apply) {
                    this.setPrepareHeight(availableHeight - this.getRelativeY());
                    this.filler.columnIndex = this.filler.columnCount - 1;
                }
            }
        }
        this.setToPrint(isToPrint);
        this.setReprinted(false);
        return false;
    }
}

