/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.json.query;

import java.io.InputStream;
import java.util.Map;
import net.sf.jasperreports.engine.JRDataset;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRValueParameter;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.data.RewindableDataSourceProvider;
import net.sf.jasperreports.engine.data.TextDataSourceAttributes;
import net.sf.jasperreports.engine.query.QueryExecutionContext;
import net.sf.jasperreports.engine.query.SimpleQueryExecutionContext;
import net.sf.jasperreports.engine.util.JRStringUtil;
import net.sf.jasperreports.json.data.JsonQLDataSource;
import net.sf.jasperreports.json.data.JsonQLDataSourceProvider;
import net.sf.jasperreports.json.query.AbstractJsonQueryExecuter;

public class JsonQLQueryExecuter
extends AbstractJsonQueryExecuter<JsonQLDataSource> {
    public static final String CANONICAL_LANGUAGE = "JSONQL";

    public JsonQLQueryExecuter(JasperReportsContext jasperReportsContext, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        this((QueryExecutionContext)SimpleQueryExecutionContext.of((JasperReportsContext)jasperReportsContext), dataset, parametersMap);
    }

    public JsonQLQueryExecuter(QueryExecutionContext context, JRDataset dataset, Map<String, ? extends JRValueParameter> parametersMap) {
        super(context, dataset, parametersMap);
    }

    protected String getCanonicalQueryLanguage() {
        return CANONICAL_LANGUAGE;
    }

    protected String getParameterReplacement(String parameterName) {
        Object parameterValue = this.getParameterValue(parameterName);
        if (parameterValue == null) {
            return null;
        }
        Class<?> valueClass = parameterValue.getClass();
        if (Number.class.isAssignableFrom(valueClass) || Boolean.class.equals(valueClass)) {
            return String.valueOf(parameterValue);
        }
        StringBuilder sb = new StringBuilder("\"");
        sb.append(JRStringUtil.escapeJavaStringLiteral((String)String.valueOf(parameterValue)));
        sb.append("\"");
        return sb.toString();
    }

    @Override
    protected JsonQLDataSource getJsonDataInstance(InputStream jsonInputStream) throws JRException {
        return new JsonQLDataSource(jsonInputStream, this.getQueryString());
    }

    @Override
    protected JsonQLDataSource getJsonDataInstance(String jsonSource) throws JRException {
        return new JsonQLDataSource(this.getRepositoryContext(), jsonSource, this.getQueryString());
    }

    @Override
    protected RewindableDataSourceProvider<JsonQLDataSource> getJsonDataProviderInstance(String source, TextDataSourceAttributes textAttributes) {
        return new JsonQLDataSourceProvider(this.getJasperReportsContext(), source, this.getQueryString(), textAttributes);
    }
}

