/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.pdf;

import com.lowagie.text.FontFactory;
import com.lowagie.text.pdf.PdfWriter;
import java.awt.Color;
import java.awt.color.ColorSpace;
import java.awt.color.ICC_ColorSpace;
import java.awt.color.ICC_Profile;
import java.awt.font.TextAttribute;
import java.awt.geom.AffineTransform;
import java.awt.geom.Dimension2D;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.sf.jasperreports.engine.DefaultJasperReportsContext;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBoxContainer;
import net.sf.jasperreports.engine.JRCommonGraphicElement;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRGenericPrintElement;
import net.sf.jasperreports.engine.JRImageAlignment;
import net.sf.jasperreports.engine.JRLineBox;
import net.sf.jasperreports.engine.JRPen;
import net.sf.jasperreports.engine.JRPenContainer;
import net.sf.jasperreports.engine.JRPrintAnchor;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintFrame;
import net.sf.jasperreports.engine.JRPrintHyperlink;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRPropertiesHolder;
import net.sf.jasperreports.engine.JRPropertiesUtil;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JasperPrint;
import net.sf.jasperreports.engine.JasperReportsContext;
import net.sf.jasperreports.engine.PrintPageFormat;
import net.sf.jasperreports.engine.base.JRBaseFont;
import net.sf.jasperreports.engine.base.JRBasePen;
import net.sf.jasperreports.engine.base.JRBasePrintText;
import net.sf.jasperreports.engine.export.GenericElementHandlerEnviroment;
import net.sf.jasperreports.engine.export.HyperlinkUtil;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRHyperlinkProducer;
import net.sf.jasperreports.engine.export.JRHyperlinkProducerFactory;
import net.sf.jasperreports.engine.fonts.FontFace;
import net.sf.jasperreports.engine.fonts.FontFamily;
import net.sf.jasperreports.engine.fonts.FontInfo;
import net.sf.jasperreports.engine.fonts.FontUtil;
import net.sf.jasperreports.engine.type.HyperlinkTypeEnum;
import net.sf.jasperreports.engine.type.ImageTypeEnum;
import net.sf.jasperreports.engine.type.LineDirectionEnum;
import net.sf.jasperreports.engine.type.LineStyleEnum;
import net.sf.jasperreports.engine.type.ModeEnum;
import net.sf.jasperreports.engine.type.OrientationEnum;
import net.sf.jasperreports.engine.type.RotationEnum;
import net.sf.jasperreports.engine.util.ExifOrientationEnum;
import net.sf.jasperreports.engine.util.ImageUtil;
import net.sf.jasperreports.engine.util.JRLoader;
import net.sf.jasperreports.engine.util.JRSingletonCache;
import net.sf.jasperreports.engine.util.JRStyledText;
import net.sf.jasperreports.engine.util.JRStyledTextUtil;
import net.sf.jasperreports.engine.util.JRTextAttribute;
import net.sf.jasperreports.engine.util.JRTypeSniffer;
import net.sf.jasperreports.engine.util.Pair;
import net.sf.jasperreports.export.ExporterInputItem;
import net.sf.jasperreports.export.OutputStreamExporterOutput;
import net.sf.jasperreports.pdf.AbstractPdfTextRenderer;
import net.sf.jasperreports.pdf.GenericElementPdfHandler;
import net.sf.jasperreports.pdf.JRPdfExporterContext;
import net.sf.jasperreports.pdf.JRPdfExporterTagHelper;
import net.sf.jasperreports.pdf.PdfExporterConfiguration;
import net.sf.jasperreports.pdf.PdfReportConfiguration;
import net.sf.jasperreports.pdf.classic.ClassicPdfProducer;
import net.sf.jasperreports.pdf.common.FontRecipient;
import net.sf.jasperreports.pdf.common.LineCapStyle;
import net.sf.jasperreports.pdf.common.PdfChunk;
import net.sf.jasperreports.pdf.common.PdfContent;
import net.sf.jasperreports.pdf.common.PdfDocument;
import net.sf.jasperreports.pdf.common.PdfDocumentWriter;
import net.sf.jasperreports.pdf.common.PdfFontStyle;
import net.sf.jasperreports.pdf.common.PdfImage;
import net.sf.jasperreports.pdf.common.PdfOutlineEntry;
import net.sf.jasperreports.pdf.common.PdfPhrase;
import net.sf.jasperreports.pdf.common.PdfProducer;
import net.sf.jasperreports.pdf.common.PdfProducerContext;
import net.sf.jasperreports.pdf.common.PdfProducerFactory;
import net.sf.jasperreports.pdf.common.PdfRadioCheck;
import net.sf.jasperreports.pdf.common.PdfTextAlignment;
import net.sf.jasperreports.pdf.common.PdfTextChunk;
import net.sf.jasperreports.pdf.common.PdfTextField;
import net.sf.jasperreports.pdf.common.PdfTextRendererContext;
import net.sf.jasperreports.pdf.common.TextDirection;
import net.sf.jasperreports.pdf.type.PdfFieldBorderStyleEnum;
import net.sf.jasperreports.pdf.type.PdfFieldCheckTypeEnum;
import net.sf.jasperreports.pdf.type.PdfFieldTypeEnum;
import net.sf.jasperreports.pdf.type.PdfPermissionsEnum;
import net.sf.jasperreports.pdf.type.PdfPrintScalingEnum;
import net.sf.jasperreports.pdf.type.PdfVersionEnum;
import net.sf.jasperreports.pdf.type.PdfaConformanceEnum;
import net.sf.jasperreports.pdf.util.JRPdfaIccProfileNotFoundException;
import net.sf.jasperreports.renderers.DataRenderable;
import net.sf.jasperreports.renderers.DimensionRenderable;
import net.sf.jasperreports.renderers.Graphics2DRenderable;
import net.sf.jasperreports.renderers.Renderable;
import net.sf.jasperreports.renderers.RenderersCache;
import net.sf.jasperreports.renderers.ResourceRenderer;
import net.sf.jasperreports.renderers.WrappingImageDataToGraphics2DRenderer;
import net.sf.jasperreports.renderers.WrappingRenderToImageDataRenderer;
import net.sf.jasperreports.renderers.WrappingSvgDataToGraphics2DRenderer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JRPdfExporter
extends JRAbstractExporter<PdfReportConfiguration, PdfExporterConfiguration, OutputStreamExporterOutput, JRPdfExporterContext> {
    private static final Log log = LogFactory.getLog(JRPdfExporter.class);
    public static final String PDF_EXPORTER_PROPERTIES_PREFIX = "net.sf.jasperreports.export.pdf.";
    public static final String EXCEPTION_MESSAGE_KEY_DOCUMENT_ERROR = "export.pdf.document.error";
    public static final String EXCEPTION_MESSAGE_KEY_FONT_LOADING_ERROR = "export.pdf.font.loading.error";
    public static final String EXCEPTION_MESSAGE_KEY_REPORT_GENERATION_ERROR = "export.pdf.report.generation.error";
    public static final String PDF_FONT_FILES_PREFIX = "net.sf.jasperreports.export.pdf.font.";
    public static final String PDF_FONT_DIRS_PREFIX = "net.sf.jasperreports.export.pdf.fontdir.";
    public static final String PDF_FIELD_TYPE = "net.sf.jasperreports.export.pdf.field.type";
    public static final String PDF_FIELD_TEXT_MULTILINE = "net.sf.jasperreports.export.pdf.field.text.multiline";
    public static final String PDF_FIELD_VALUE = "net.sf.jasperreports.export.pdf.field.value";
    public static final String PDF_FIELD_CHECK_TYPE = "net.sf.jasperreports.export.pdf.field.check.type";
    public static final String PDF_FIELD_NAME = "net.sf.jasperreports.export.pdf.field.name";
    public static final String PDF_FIELD_CHECKED = "net.sf.jasperreports.export.pdf.field.checked";
    public static final String PDF_FIELD_READ_ONLY = "net.sf.jasperreports.export.pdf.field.read.only";
    public static final String PDF_FIELD_BORDER_STYLE = "net.sf.jasperreports.export.pdf.field.border.style";
    public static final String PDF_FIELD_CHOICE_SEPARATORS = "net.sf.jasperreports.export.pdf.field.choice.separators";
    public static final String PDF_FIELD_CHOICES = "net.sf.jasperreports.export.pdf.field.choices";
    public static final String PDF_FIELD_COMBO_EDIT = "net.sf.jasperreports.export.pdf.field.combo.edit";
    public static final String LEGACY_TARGET_BLANK_LINKS = "net.sf.jasperreports.export.pdf.legacy.target.blank.links";
    public static final String LEGACY_TEXT_MEASURING_FIX = "net.sf.jasperreports.export.pdf.legacy.text.measuring.fix";
    public static final String PDF_EXPORTER_KEY = "net.sf.jasperreports.pdf";
    public static final String PDF_PRODUCER_FACTORY_PROPERTY = "net.sf.jasperreports.export.pdf.producer.factory";
    private static final String EMPTY_BOOKMARK_TITLE = "";
    protected static final String JR_PAGE_ANCHOR_PREFIX = "JR_PAGE_ANCHOR_";
    protected static boolean fontsRegistered;
    private static final JRSingletonCache<PdfProducerFactory> pdfProducerCache;
    protected PdfProducer pdfProducer;
    protected PdfContent pdfContent;
    protected JRPdfExporterTagHelper tagHelper = new JRPdfExporterTagHelper(this);
    protected ColorSpace cmykColorSpace;
    protected int reportIndex;
    protected PrintPageFormat pageFormat;
    protected int crtDocumentPageNumber;
    protected int permissions;
    protected RenderersCache renderersCache;
    protected Map<String, Pair<PdfImage, ExifOrientationEnum>> loadedImagesMap;
    protected PdfImage pxImage;
    private BookmarkStack bookmarkStack;
    private int crtOddPageOffsetX;
    private int crtOddPageOffsetY;
    private int crtEvenPageOffsetX;
    private int crtEvenPageOffsetY;
    private boolean bookmarksEnabled;
    private boolean awtIgnoreMissingFont;
    private boolean defaultIndentFirstLine;
    private boolean defaultJustifyLastLine;
    private boolean legacyTargetBlankLinks;
    private boolean legacyTextMeasuringFix;
    private PdfVersionEnum minimalVersion;

    public JRPdfExporter() {
        this((JasperReportsContext)DefaultJasperReportsContext.getInstance());
    }

    public JRPdfExporter(JasperReportsContext jasperReportsContext) {
        super(jasperReportsContext);
        this.exporterContext = new ExporterContext();
    }

    protected Class<PdfExporterConfiguration> getConfigurationInterface() {
        return PdfExporterConfiguration.class;
    }

    protected Class<PdfReportConfiguration> getItemConfigurationInterface() {
        return PdfReportConfiguration.class;
    }

    protected PdfImage getPxImage() {
        if (this.pxImage == null) {
            try {
                this.pxImage = this.pdfProducer.createImage(JRLoader.loadBytesFromResource((String)"net/sf/jasperreports/engine/images/white-transparent-pixel.png"), false);
            }
            catch (Exception e) {
                throw new JRRuntimeException((Throwable)e);
            }
        }
        return this.pxImage;
    }

    public void exportReport() throws JRException {
        JRPdfExporter.registerFonts();
        this.ensureJasperReportsContext();
        this.ensureInput();
        this.initExport();
        this.ensureOutput();
        OutputStream outputStream = ((OutputStreamExporterOutput)this.getExporterOutput()).getOutputStream();
        try {
            this.exportReportToStream(outputStream);
        }
        finally {
            ((OutputStreamExporterOutput)this.getExporterOutput()).close();
            this.resetExportContext();
        }
    }

    protected void initExport() {
        super.initExport();
        PdfExporterConfiguration configuration = (PdfExporterConfiguration)this.getCurrentConfiguration();
        Boolean isTagged = configuration.isTagged();
        if (isTagged != null) {
            this.tagHelper.setTagged(isTagged);
        }
        this.tagHelper.setLanguage(configuration.getTagLanguage());
        this.permissions = JRPdfExporter.getIntegerPermissions(configuration.getAllowedPermissions()) & ~JRPdfExporter.getIntegerPermissions(configuration.getDeniedPermissions());
        this.crtDocumentPageNumber = 0;
        this.awtIgnoreMissingFont = this.getPropertiesUtil().getBooleanProperty("net.sf.jasperreports.awt.ignore.missing.font");
        this.pdfProducer = this.createPdfProducer();
    }

    protected void initReport() {
        super.initReport();
        PdfReportConfiguration configuration = (PdfReportConfiguration)this.getCurrentItemConfiguration();
        this.pdfProducer.setForceLineBreakPolicy(configuration.isForceLineBreakPolicy());
        this.defaultIndentFirstLine = this.propertiesUtil.getBooleanProperty((JRPropertiesHolder)this.jasperPrint, "net.sf.jasperreports.awt.indent.first.line", true);
        this.defaultJustifyLastLine = this.propertiesUtil.getBooleanProperty((JRPropertiesHolder)this.jasperPrint, "net.sf.jasperreports.awt.justify.last.line", false);
        this.legacyTargetBlankLinks = this.propertiesUtil.getBooleanProperty((JRPropertiesHolder)this.jasperPrint, LEGACY_TARGET_BLANK_LINKS, false);
        this.legacyTextMeasuringFix = this.propertiesUtil.getBooleanProperty((JRPropertiesHolder)this.jasperPrint, LEGACY_TEXT_MEASURING_FIX, false);
        this.crtOddPageOffsetX = configuration.getOddPageOffsetX();
        this.crtOddPageOffsetY = configuration.getOddPageOffsetY();
        this.crtEvenPageOffsetX = configuration.getEvenPageOffsetX();
        this.crtEvenPageOffsetY = configuration.getEvenPageOffsetY();
        this.bookmarksEnabled = configuration.isBookmarksEnabled();
        this.pdfProducer.initReport();
        this.renderersCache = new RenderersCache(this.getJasperReportsContext());
        this.loadedImagesMap = new HashMap<String, Pair<PdfImage, ExifOrientationEnum>>();
    }

    protected PdfProducerFactory getPdfProducerFactory() {
        String producerFactory = this.propertiesUtil.getProperty(PDF_PRODUCER_FACTORY_PROPERTY);
        try {
            return (PdfProducerFactory)pdfProducerCache.getCachedInstance(producerFactory);
        }
        catch (JRException e) {
            throw new JRRuntimeException((Throwable)e);
        }
    }

    protected PdfProducerContext createPdfProducerContext() {
        return new PdfProducerContext(){

            @Override
            public JRPdfExporter getExporter() {
                return JRPdfExporter.this;
            }

            @Override
            public JasperReportsContext getJasperReportsContext() {
                return JRPdfExporter.this.jasperReportsContext;
            }

            @Override
            public JRPropertiesUtil getProperties() {
                return JRPdfExporter.this.propertiesUtil;
            }

            @Override
            public FontUtil getFontUtil() {
                return JRPdfExporter.this.fontUtil;
            }

            @Override
            public JRStyledTextUtil getStyledTextUtil() {
                return JRPdfExporter.this.styledTextUtil;
            }

            @Override
            public boolean isTagged() {
                return JRPdfExporter.this.tagHelper.isTagged;
            }

            @Override
            public void setMinimalVersion(PdfVersionEnum version) {
                JRPdfExporter.this.minimalVersion = version;
            }

            @Override
            public JasperPrint getCurrentJasperPrint() {
                return JRPdfExporter.this.getCurrentJasperPrint();
            }

            @Override
            public void setFont(Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale, boolean setFontLines, FontRecipient recipient) {
                JRPdfExporter.this.setFont(attributes, locale, setFontLines, recipient);
            }

            @Override
            public JRException handleDocumentException(Exception e) {
                return new JRException(JRPdfExporter.EXCEPTION_MESSAGE_KEY_DOCUMENT_ERROR, new Object[]{JRPdfExporter.this.jasperPrint.getName()}, (Throwable)e);
            }

            @Override
            public ColorSpace getCMYKColorSpace() {
                return JRPdfExporter.this.cmykColorSpace;
            }
        };
    }

    protected PdfTextRendererContext createPdfTextRendererContext(final JRPrintText text, final JRStyledText styledText, final Locale textLocale) {
        return new PdfTextRendererContext(){

            @Override
            public Locale getTextLocale() {
                return textLocale;
            }

            @Override
            public JRPrintText getPrintText() {
                return text;
            }

            @Override
            public JRStyledText getStyledText() {
                return styledText;
            }

            @Override
            public boolean getLegacyTextMeasuringFix() {
                return JRPdfExporter.this.legacyTextMeasuringFix;
            }

            @Override
            public boolean getJustifyLastLine() {
                return JRPdfExporter.this.defaultJustifyLastLine;
            }

            @Override
            public boolean getIndentFirstLine() {
                return JRPdfExporter.this.defaultIndentFirstLine;
            }

            @Override
            public boolean getAwtIgnoreMissingFont() {
                return JRPdfExporter.this.awtIgnoreMissingFont;
            }
        };
    }

    protected PdfProducer createPdfProducer() {
        PdfProducerFactory producerFactory = this.getPdfProducerFactory();
        PdfProducerContext producerContext = this.createPdfProducerContext();
        return producerFactory.createProducer(producerContext);
    }

    protected void exportReportToStream(OutputStream os) throws JRException {
        PdfExporterConfiguration configuration = (PdfExporterConfiguration)this.getCurrentConfiguration();
        this.pageFormat = this.jasperPrint.getPageFormat(0);
        PdfDocument document = this.pdfProducer.createDocument(this.pageFormat);
        boolean closeDocuments = true;
        try {
            String pdfJavaScript;
            String creator;
            String keywords;
            String subject;
            String author;
            String title;
            PdfDocumentWriter pdfWriter = this.pdfProducer.createWriter(os);
            this.tagHelper.setPdfProducer(this.pdfProducer);
            PdfVersionEnum pdfVersion = configuration.getPdfVersion();
            if (pdfVersion != null) {
                pdfWriter.setPdfVersion(pdfVersion);
            }
            if (this.minimalVersion != null) {
                pdfWriter.setMinimalPdfVersion(this.minimalVersion);
            }
            if (configuration.isCompressed().booleanValue()) {
                pdfWriter.setFullCompression();
            }
            if (configuration.isEncrypted().booleanValue()) {
                int perms = configuration.isOverrideHints() == null || configuration.isOverrideHints().booleanValue() ? (configuration.getPermissions() != null ? configuration.getPermissions() : this.permissions) : (this.permissions != 0 ? this.permissions : (configuration.getPermissions() != null ? configuration.getPermissions() : 0));
                pdfWriter.setEncryption(configuration.getUserPassword(), configuration.getOwnerPassword(), perms, configuration.is128BitKey());
            }
            PdfPrintScalingEnum printScaling = configuration.getPrintScaling();
            pdfWriter.setPrintScaling(printScaling);
            boolean justifiedLetterSpacing = this.propertiesUtil.getBooleanProperty((JRPropertiesHolder)this.jasperPrint, "net.sf.jasperreports.export.pdf.justified.letter.spacing", false);
            if (!justifiedLetterSpacing) {
                pdfWriter.setNoSpaceCharRatio();
            }
            if ((title = configuration.getMetadataTitle()) != null) {
                document.addTitle(title);
                if (configuration.isDisplayMetadataTitle().booleanValue()) {
                    pdfWriter.setDisplayMetadataTitle();
                }
            }
            if ((author = configuration.getMetadataAuthor()) != null) {
                document.addAuthor(author);
            }
            if ((subject = configuration.getMetadataSubject()) != null) {
                document.addSubject(subject);
            }
            if ((keywords = configuration.getMetadataKeywords()) != null) {
                document.addKeywords(keywords);
            }
            if ((creator = configuration.getMetadataCreator()) == null) {
                String depCreator;
                creator = depCreator = "JasperReports Library version " + Package.getPackage("net.sf.jasperreports.engine").getImplementationVersion();
            }
            document.addCreator(creator);
            String producer = configuration.getMetadataProducer();
            if (producer != null) {
                document.addProducer(producer);
            }
            pdfWriter.setTabOrderStructure();
            String language = configuration.getTagLanguage();
            if (language != null) {
                pdfWriter.setLanguage(language);
            }
            PdfaConformanceEnum pdfaConformance = configuration.getPdfaConformance();
            boolean gotPdfa = false;
            if (pdfaConformance != null && pdfaConformance != PdfaConformanceEnum.NONE) {
                pdfWriter.setPdfaConformance(pdfaConformance);
                gotPdfa = true;
            }
            if (gotPdfa) {
                pdfWriter.createXmpMetadata(title, subject, keywords);
            } else {
                pdfWriter.setRgbTransparencyBlending(true);
            }
            document.open();
            if (configuration.isUseCMYKColors().booleanValue() || configuration.isEmbedIccProfile().booleanValue() || gotPdfa) {
                String iccProfilePath = configuration.getIccProfilePath();
                if (iccProfilePath != null && iccProfilePath.trim().length() > 0) {
                    byte[] iccBytes = this.getRepository().getBytesFromLocation(iccProfilePath);
                    if (configuration.isUseCMYKColors().booleanValue()) {
                        ICC_Profile profile = ICC_Profile.getInstance(iccBytes);
                        this.cmykColorSpace = new ICC_ColorSpace(profile);
                    }
                    if (gotPdfa || configuration.isEmbedIccProfile().booleanValue()) {
                        pdfWriter.setIccProfilePath(iccProfilePath, new ByteArrayInputStream(iccBytes));
                    }
                } else {
                    throw new JRPdfaIccProfileNotFoundException();
                }
            }
            if ((pdfJavaScript = configuration.getPdfJavaScript()) != null) {
                pdfWriter.addJavaScript(pdfJavaScript);
            }
            this.pdfContent = this.pdfProducer.createPdfContent();
            this.tagHelper.init();
            List items = this.exporterInput.getItems();
            this.initBookmarks(items);
            boolean isCreatingBatchModeBookmarks = configuration.isCreatingBatchModeBookmarks();
            this.reportIndex = 0;
            while (this.reportIndex < items.size()) {
                ExporterInputItem item = (ExporterInputItem)items.get(this.reportIndex);
                this.setCurrentExporterInputItem(item);
                this.pageFormat = this.jasperPrint.getPageFormat(0);
                this.setPageSize(null);
                boolean pageExported = false;
                List pages = this.jasperPrint.getPages();
                if (pages != null && pages.size() > 0) {
                    if (items.size() > 1) {
                        this.pdfProducer.newPage();
                        if (isCreatingBatchModeBookmarks) {
                            this.addBookmark(0, this.jasperPrint.getName(), 0, 0);
                        }
                    }
                    PdfReportConfiguration lcItemConfiguration = (PdfReportConfiguration)this.getCurrentItemConfiguration();
                    boolean sizePageToContent = lcItemConfiguration.isSizePageToContent();
                    PrintPageFormat oldPageFormat = null;
                    JRAbstractExporter.PageRange pageRange = this.getPageRange();
                    int startPageIndex = pageRange == null || pageRange.getStartPageIndex() == null ? 0 : pageRange.getStartPageIndex();
                    int endPageIndex = pageRange == null || pageRange.getEndPageIndex() == null ? pages.size() - 1 : pageRange.getEndPageIndex();
                    for (int pageIndex = startPageIndex; pageIndex <= endPageIndex; ++pageIndex) {
                        this.checkInterrupted();
                        JRPrintPage page = (JRPrintPage)pages.get(pageIndex);
                        this.pageFormat = this.jasperPrint.getPageFormat(pageIndex);
                        if (sizePageToContent || oldPageFormat != this.pageFormat) {
                            this.setPageSize((JRPrintPage)(sizePageToContent ? page : null));
                        }
                        this.pdfProducer.newPage();
                        this.pdfProducer.getPdfContent().setLineCap(LineCapStyle.PROJECTING_SQUARE);
                        this.writePageAnchor(pageIndex);
                        ++this.crtDocumentPageNumber;
                        this.exportPage(page);
                        pageExported = true;
                        oldPageFormat = this.pageFormat;
                    }
                }
                if (!pageExported) {
                    this.pdfProducer.newPage();
                    this.pdfContent.setLiteral("\n");
                }
                ++this.reportIndex;
            }
            closeDocuments = false;
            this.pdfProducer.close();
        }
        catch (IOException e) {
            throw new JRException(EXCEPTION_MESSAGE_KEY_REPORT_GENERATION_ERROR, new Object[]{this.jasperPrint.getName()}, (Throwable)e);
        }
        finally {
            if (closeDocuments) {
                try {
                    this.pdfProducer.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    protected void writePageAnchor(int pageIndex) {
        HashMap<AttributedCharacterIterator.Attribute, Object> attributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        this.fontUtil.getAttributesWithoutAwtFont(attributes, (JRFont)new JRBasePrintText(this.jasperPrint.getDefaultStyleProvider()));
        PdfTextChunk chunk = this.pdfProducer.createChunk(" ", attributes, this.getLocale());
        chunk.setLocalDestination(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + (pageIndex + 1));
        this.tagHelper.startPageAnchor();
        PdfPhrase phrase = this.pdfProducer.createPhrase(chunk);
        phrase.go(0.0f, this.pageFormat.getPageHeight().intValue(), 1.0f, 1.0f, 0.0f, 0.0f, PdfTextAlignment.LEFT, TextDirection.DEFAULT);
        this.tagHelper.endPageAnchor();
    }

    protected void setPageSize(JRPrintPage page) throws JRException, IOException {
        int pageWidth = 0;
        int pageHeight = 0;
        if (page != null) {
            List elements = page.getElements();
            for (JRPrintElement element : elements) {
                int elementRight = element.getX() + element.getWidth();
                int elementBottom = element.getY() + element.getHeight();
                pageWidth = pageWidth < elementRight ? elementRight : pageWidth;
                pageHeight = pageHeight < elementBottom ? elementBottom : pageHeight;
            }
            pageWidth += this.pageFormat.getRightMargin().intValue();
            pageHeight += this.pageFormat.getBottomMargin().intValue();
        }
        pageWidth = pageWidth < this.pageFormat.getPageWidth() ? this.pageFormat.getPageWidth() : pageWidth;
        pageHeight = pageHeight < this.pageFormat.getPageHeight() ? this.pageFormat.getPageHeight() : pageHeight;
        this.pdfProducer.setPageSize(this.pageFormat, pageWidth, pageHeight);
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        this.tagHelper.startPage();
        List elements = page.getElements();
        this.exportElements(elements);
        this.pdfProducer.endPage();
        this.tagHelper.endPage();
        JRExportProgressMonitor progressMonitor = ((PdfReportConfiguration)this.getCurrentItemConfiguration()).getProgressMonitor();
        if (progressMonitor != null) {
            progressMonitor.afterPageExport();
        }
    }

    protected void exportElements(Collection<JRPrintElement> elements) throws IOException, JRException {
        if (elements != null && elements.size() > 0) {
            Iterator<JRPrintElement> it = elements.iterator();
            while (it.hasNext()) {
                this.checkInterrupted();
                JRPrintElement element = it.next();
                if (this.filter != null && !this.filter.isToExport(element)) continue;
                this.tagHelper.startElement(element);
                String strFieldType = element.getPropertiesMap().getProperty(PDF_FIELD_TYPE);
                PdfFieldTypeEnum fieldType = PdfFieldTypeEnum.getByName(strFieldType);
                if (fieldType == PdfFieldTypeEnum.CHECK) {
                    this.exportFieldCheck(element);
                } else if (fieldType == PdfFieldTypeEnum.RADIO) {
                    this.exportFieldRadio(element);
                } else if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                } else if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                } else if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                } else if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                } else if (element instanceof JRPrintText) {
                    if (fieldType == PdfFieldTypeEnum.TEXT || fieldType == PdfFieldTypeEnum.COMBO || fieldType == PdfFieldTypeEnum.LIST) {
                        this.exportFieldText((JRPrintText)element, fieldType);
                    } else {
                        this.exportText((JRPrintText)element);
                    }
                } else if (element instanceof JRPrintFrame) {
                    this.exportFrame((JRPrintFrame)element);
                } else if (element instanceof JRGenericPrintElement) {
                    this.exportGenericElement((JRGenericPrintElement)element);
                }
                this.tagHelper.endElement(element);
            }
        }
    }

    protected void exportLine(JRPrintLine line) {
        int lcOffsetX = this.getOffsetX();
        int lcOffsetY = this.getOffsetY();
        float lineWidth = line.getLinePen().getLineWidth().floatValue();
        if (lineWidth > 0.0f) {
            this.preparePen(line.getLinePen(), LineCapStyle.BUTT);
            if (line.getWidth() == 1) {
                if (line.getHeight() != 1) {
                    if (line.getLinePen().getLineStyle() == LineStyleEnum.DOUBLE) {
                        this.pdfContent.strokeLine((float)(line.getX() + lcOffsetX) + 0.5f - lineWidth / 3.0f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY, (float)(line.getX() + lcOffsetX) + 0.5f - lineWidth / 3.0f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight());
                        this.pdfContent.strokeLine((float)(line.getX() + lcOffsetX) + 0.5f + lineWidth / 3.0f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY, (float)(line.getX() + lcOffsetX) + 0.5f + lineWidth / 3.0f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight());
                    } else {
                        this.pdfContent.strokeLine((float)(line.getX() + lcOffsetX) + 0.5f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY, (float)(line.getX() + lcOffsetX) + 0.5f, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight());
                    }
                }
            } else if (line.getHeight() == 1) {
                if (line.getLinePen().getLineStyle() == LineStyleEnum.DOUBLE) {
                    this.pdfContent.strokeLine(line.getX() + lcOffsetX, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f + lineWidth / 3.0f, line.getX() + lcOffsetX + line.getWidth(), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f + lineWidth / 3.0f);
                    this.pdfContent.strokeLine(line.getX() + lcOffsetX, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f - lineWidth / 3.0f, line.getX() + lcOffsetX + line.getWidth(), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f - lineWidth / 3.0f);
                } else {
                    this.pdfContent.strokeLine(line.getX() + lcOffsetX, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f, line.getX() + lcOffsetX + line.getWidth(), (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - 0.5f);
                }
            } else if (line.getDirection() != LineDirectionEnum.BOTTOM_UP) {
                if (line.getLinePen().getLineStyle() == LineStyleEnum.DOUBLE) {
                    double xtrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getWidth(), 2.0) / Math.pow(line.getHeight(), 2.0)));
                    double ytrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getHeight(), 2.0) / Math.pow(line.getWidth(), 2.0)));
                    this.pdfContent.strokeLine((float)(line.getX() + lcOffsetX) + (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) + (float)ytrans, (float)(line.getX() + lcOffsetX + line.getWidth()) + (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()) + (float)ytrans);
                    this.pdfContent.strokeLine((float)(line.getX() + lcOffsetX) - (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - (float)ytrans, (float)(line.getX() + lcOffsetX + line.getWidth()) - (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()) - (float)ytrans);
                } else {
                    this.pdfContent.strokeLine(line.getX() + lcOffsetX, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY, line.getX() + lcOffsetX + line.getWidth(), this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight());
                }
            } else if (line.getLinePen().getLineStyle() == LineStyleEnum.DOUBLE) {
                double xtrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getWidth(), 2.0) / Math.pow(line.getHeight(), 2.0)));
                double ytrans = (double)lineWidth / (3.0 * Math.sqrt(1.0 + Math.pow(line.getHeight(), 2.0) / Math.pow(line.getWidth(), 2.0)));
                this.pdfContent.strokeLine((float)(line.getX() + lcOffsetX) + (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()) - (float)ytrans, (float)(line.getX() + lcOffsetX + line.getWidth()) + (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) - (float)ytrans);
                this.pdfContent.strokeLine((float)(line.getX() + lcOffsetX) - (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight()) + (float)ytrans, (float)(line.getX() + lcOffsetX + line.getWidth()) - (float)xtrans, (float)(this.pageFormat.getPageHeight() - line.getY() - lcOffsetY) + (float)ytrans);
            } else {
                this.pdfContent.strokeLine(line.getX() + lcOffsetX, this.pageFormat.getPageHeight() - line.getY() - lcOffsetY - line.getHeight(), line.getX() + lcOffsetX + line.getWidth(), this.pageFormat.getPageHeight() - line.getY() - lcOffsetY);
            }
            this.resetPen();
            this.pdfContent.setLineDash(0.0f);
            this.pdfContent.setLineCap(LineCapStyle.PROJECTING_SQUARE);
        }
    }

    protected void exportRectangle(JRPrintRectangle rectangle) {
        this.pdfContent.setFillColor(rectangle.getBackcolor());
        this.preparePen(rectangle.getLinePen(), LineCapStyle.PROJECTING_SQUARE);
        float lineWidth = rectangle.getLinePen().getLineWidth().floatValue();
        int lcOffsetX = this.getOffsetX();
        int lcOffsetY = this.getOffsetY();
        if (rectangle.getMode() == ModeEnum.OPAQUE) {
            this.pdfContent.fillRoundRectangle(rectangle.getX() + lcOffsetX, this.pageFormat.getPageHeight() - rectangle.getY() - lcOffsetY - rectangle.getHeight(), rectangle.getWidth(), rectangle.getHeight(), rectangle.getRadius());
        }
        if (lineWidth > 0.0f) {
            if (rectangle.getLinePen().getLineStyle() == LineStyleEnum.DOUBLE) {
                this.pdfContent.strokeRoundRectangle((float)(rectangle.getX() + lcOffsetX) - lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - rectangle.getY() - lcOffsetY - rectangle.getHeight()) - lineWidth / 3.0f, (float)rectangle.getWidth() + 2.0f * lineWidth / 3.0f, (float)rectangle.getHeight() + 2.0f * lineWidth / 3.0f, rectangle.getRadius());
                this.pdfContent.strokeRoundRectangle((float)(rectangle.getX() + lcOffsetX) + lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - rectangle.getY() - lcOffsetY - rectangle.getHeight()) + lineWidth / 3.0f, (float)rectangle.getWidth() - 2.0f * lineWidth / 3.0f, (float)rectangle.getHeight() - 2.0f * lineWidth / 3.0f, rectangle.getRadius());
            } else {
                this.pdfContent.strokeRoundRectangle(rectangle.getX() + lcOffsetX, this.pageFormat.getPageHeight() - rectangle.getY() - lcOffsetY - rectangle.getHeight(), rectangle.getWidth(), rectangle.getHeight(), rectangle.getRadius());
            }
        }
        this.resetPen();
        this.pdfContent.resetFillColor();
        this.pdfContent.setLineDash(0.0f);
    }

    protected void exportEllipse(JRPrintEllipse ellipse) {
        this.pdfContent.setFillColor(ellipse.getBackcolor());
        this.preparePen(ellipse.getLinePen(), LineCapStyle.PROJECTING_SQUARE);
        float lineWidth = ellipse.getLinePen().getLineWidth().floatValue();
        int lcOffsetX = this.getOffsetX();
        int lcOffsetY = this.getOffsetY();
        if (ellipse.getMode() == ModeEnum.OPAQUE) {
            this.pdfContent.fillEllipse(ellipse.getX() + lcOffsetX, this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY - ellipse.getHeight(), ellipse.getX() + lcOffsetX + ellipse.getWidth(), this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY);
        }
        if (lineWidth > 0.0f) {
            if (ellipse.getLinePen().getLineStyle() == LineStyleEnum.DOUBLE) {
                this.pdfContent.strokeEllipse((float)(ellipse.getX() + lcOffsetX) - lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY - ellipse.getHeight()) - lineWidth / 3.0f, (float)(ellipse.getX() + lcOffsetX + ellipse.getWidth()) + lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY) + lineWidth / 3.0f);
                this.pdfContent.strokeEllipse((float)(ellipse.getX() + lcOffsetX) + lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY - ellipse.getHeight()) + lineWidth / 3.0f, (float)(ellipse.getX() + lcOffsetX + ellipse.getWidth()) - lineWidth / 3.0f, (float)(this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY) - lineWidth / 3.0f);
            } else {
                this.pdfContent.strokeEllipse(ellipse.getX() + lcOffsetX, this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY - ellipse.getHeight(), ellipse.getX() + lcOffsetX + ellipse.getWidth(), this.pageFormat.getPageHeight() - ellipse.getY() - lcOffsetY);
            }
        }
        this.resetPen();
        this.pdfContent.resetFillColor();
        this.pdfContent.setLineDash(0.0f);
    }

    public void exportImage(JRPrintImage printImage) throws IOException, JRException {
        if (printImage.getMode() == ModeEnum.OPAQUE) {
            this.pdfContent.setFillColor(printImage.getBackcolor());
            this.pdfContent.fillRectangle(printImage.getX() + this.getOffsetX(), this.pageFormat.getPageHeight() - printImage.getY() - this.getOffsetY(), printImage.getWidth(), -printImage.getHeight());
            this.pdfContent.resetFillColor();
        }
        InternalImageProcessor imageProcessor = new InternalImageProcessor(printImage);
        Renderable renderer = printImage.getRenderer();
        if (renderer != null && imageProcessor.availableImageWidth > 0 && imageProcessor.availableImageHeight > 0) {
            InternalImageProcessorResult imageProcessorResult;
            block9: {
                imageProcessorResult = null;
                try {
                    imageProcessorResult = imageProcessor.process(renderer);
                }
                catch (Exception e) {
                    Renderable onErrorRenderer = this.getRendererUtil().handleImageError(e, printImage.getOnErrorType());
                    if (onErrorRenderer == null) break block9;
                    imageProcessorResult = imageProcessor.process(onErrorRenderer);
                }
            }
            if (imageProcessorResult != null) {
                this.setAnchor(imageProcessorResult.chunk, (JRPrintAnchor)printImage, (JRPrintElement)printImage);
                PdfImage pxImage = this.getPxImage();
                pxImage.scaleAbsolute(printImage.getWidth(), printImage.getHeight());
                PdfChunk pxChunk = this.pdfProducer.createChunk(pxImage);
                boolean wasHyperlinkSet = this.setHyperlinkInfo(pxChunk, (JRPrintHyperlink)printImage);
                boolean usePxImage = this.tagHelper.isTagged && printImage.getHyperlinkTooltip() != null || wasHyperlinkSet;
                this.tagHelper.startImage(printImage);
                PdfPhrase phrase = this.pdfProducer.createPhrase(imageProcessorResult.chunk);
                int upperY = this.pageFormat.getPageHeight() - printImage.getY() - imageProcessor.topPadding - this.getOffsetY() - imageProcessorResult.yoffset;
                int lowerX = printImage.getX() + imageProcessor.leftPadding + this.getOffsetX() + imageProcessorResult.xoffset;
                phrase.go(lowerX, upperY, (float)lowerX + imageProcessorResult.scaledWidth, (float)upperY - imageProcessorResult.scaledHeight, 0.0f, 0.0f, PdfTextAlignment.LEFT, TextDirection.DEFAULT);
                if (usePxImage) {
                    PdfPhrase pxPhrase = this.pdfProducer.createPhrase(pxChunk);
                    pxPhrase.go(printImage.getX() + this.getOffsetX(), this.pageFormat.getPageHeight() - printImage.getY() - this.getOffsetY(), printImage.getX() + this.getOffsetX() + printImage.getWidth(), this.pageFormat.getPageHeight() - printImage.getY() - this.getOffsetY() - printImage.getHeight(), 0.0f, 0.0f, PdfTextAlignment.LEFT, TextDirection.DEFAULT);
                }
                this.tagHelper.endImage();
            }
        }
        if (printImage.getLineBox().getTopPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getLeftPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getBottomPen().getLineWidth().floatValue() <= 0.0f && printImage.getLineBox().getRightPen().getLineWidth().floatValue() <= 0.0f) {
            if (printImage.getLinePen().getLineWidth().floatValue() > 0.0f) {
                this.exportPen(printImage.getLinePen(), (JRPrintElement)printImage);
            }
        } else {
            this.exportBox(printImage.getLineBox(), (JRPrintElement)printImage);
        }
    }

    protected boolean setHyperlinkInfo(PdfChunk chunk, JRPrintHyperlink link) {
        boolean wasHyperlinkSet = false;
        if (link != null) {
            Boolean ignoreHyperlink = HyperlinkUtil.getIgnoreHyperlink((String)"net.sf.jasperreports.export.pdf.ignore.hyperlink", (JRPrintHyperlink)link);
            if (ignoreHyperlink == null) {
                ignoreHyperlink = ((PdfReportConfiguration)this.getCurrentItemConfiguration()).isIgnoreHyperlink();
            }
            if (!ignoreHyperlink.booleanValue()) {
                switch (link.getHyperlinkType()) {
                    case REFERENCE: {
                        JRHyperlinkProducer hyperlinkProducer = this.getHyperlinkProducer(link);
                        String referenceURL = hyperlinkProducer == null ? link.getHyperlinkReference() : hyperlinkProducer.getHyperlink(link);
                        wasHyperlinkSet = this.setReferenceHyperlink(chunk, link, referenceURL);
                        break;
                    }
                    case LOCAL_ANCHOR: {
                        if (link.getHyperlinkAnchor() == null) break;
                        chunk.setLocalGoto(link.getHyperlinkAnchor());
                        wasHyperlinkSet = true;
                        break;
                    }
                    case LOCAL_PAGE: {
                        if (link.getHyperlinkPage() == null) break;
                        chunk.setLocalGoto(JR_PAGE_ANCHOR_PREFIX + this.reportIndex + "_" + link.getHyperlinkPage().toString());
                        wasHyperlinkSet = true;
                        break;
                    }
                    case REMOTE_ANCHOR: {
                        if (link.getHyperlinkReference() == null || link.getHyperlinkAnchor() == null) break;
                        chunk.setRemoteGoto(link.getHyperlinkReference(), link.getHyperlinkAnchor());
                        wasHyperlinkSet = true;
                        break;
                    }
                    case REMOTE_PAGE: {
                        if (link.getHyperlinkReference() == null || link.getHyperlinkPage() == null) break;
                        chunk.setRemoteGoto(link.getHyperlinkReference(), link.getHyperlinkPage());
                        wasHyperlinkSet = true;
                        break;
                    }
                    case CUSTOM: {
                        JRHyperlinkProducerFactory hyperlinkProducerFactory = ((PdfReportConfiguration)this.getCurrentItemConfiguration()).getHyperlinkProducerFactory();
                        if (hyperlinkProducerFactory == null) break;
                        String hyperlink = hyperlinkProducerFactory.produceHyperlink(link);
                        wasHyperlinkSet = this.setReferenceHyperlink(chunk, link, hyperlink);
                        break;
                    }
                }
            }
        }
        return wasHyperlinkSet;
    }

    protected boolean setReferenceHyperlink(PdfChunk chunk, JRPrintHyperlink link, String referenceURL) {
        boolean wasHyperlinkSet = false;
        if (referenceURL != null) {
            switch (link.getHyperlinkTarget()) {
                case BLANK: {
                    if (this.legacyTargetBlankLinks) {
                        chunk.setJavaScriptAction("if (app.viewerVersion < 7){this.getURL(\"" + referenceURL + "\");}else {app.launchURL(\"" + referenceURL + "\", true);};");
                        wasHyperlinkSet = true;
                        break;
                    }
                }
                default: {
                    chunk.setAnchor(referenceURL);
                    wasHyperlinkSet = true;
                }
            }
        }
        return wasHyperlinkSet;
    }

    protected Locale getTextLocale(JRPrintText text) {
        return super.getTextLocale(text);
    }

    protected void getPhrase(AttributedString as, String text, JRPrintText textElement, PdfPhrase phrase) {
        int runLimit = 0;
        AttributedCharacterIterator iterator = as.getIterator();
        Locale locale = this.getTextLocale(textElement);
        boolean firstChunk = true;
        while (runLimit < text.length() && (runLimit = iterator.getRunLimit()) <= text.length()) {
            JRPrintText hyperlink;
            Map<AttributedCharacterIterator.Attribute, Object> attributes = iterator.getAttributes();
            PdfTextChunk chunk = this.getChunk(attributes, text.substring(iterator.getIndex(), runLimit), locale);
            if (firstChunk) {
                this.setAnchor(chunk, (JRPrintAnchor)textElement, (JRPrintElement)textElement);
            }
            if ((hyperlink = textElement).getHyperlinkType() == HyperlinkTypeEnum.NONE) {
                hyperlink = (JRPrintHyperlink)attributes.get(JRTextAttribute.HYPERLINK);
            }
            this.setHyperlinkInfo(chunk, (JRPrintHyperlink)hyperlink);
            phrase.add(chunk);
            iterator.setIndex(runLimit);
            firstChunk = false;
        }
    }

    protected PdfTextChunk getChunk(Map<AttributedCharacterIterator.Attribute, Object> attributes, String text, Locale locale) {
        Object script;
        Color backcolor;
        PdfTextChunk chunk = this.pdfProducer.createChunk(text, attributes, locale);
        if (this.hasUnderline(attributes)) {
            chunk.setUnderline();
        }
        if (this.hasStrikethrough(attributes)) {
            chunk.setStrikethrough();
        }
        if ((backcolor = (Color)attributes.get(TextAttribute.BACKGROUND)) != null) {
            chunk.setBackground(backcolor);
        }
        if ((script = attributes.get(TextAttribute.SUPERSCRIPT)) != null) {
            if (TextAttribute.SUPERSCRIPT_SUPER.equals(script)) {
                chunk.setSuperscript();
            } else if (TextAttribute.SUPERSCRIPT_SUB.equals(script)) {
                chunk.setSubscript();
            }
        }
        return chunk;
    }

    protected boolean hasUnderline(Map<AttributedCharacterIterator.Attribute, Object> textAttributes) {
        Integer underline = (Integer)textAttributes.get(TextAttribute.UNDERLINE);
        return TextAttribute.UNDERLINE_ON.equals(underline);
    }

    protected boolean hasStrikethrough(Map<AttributedCharacterIterator.Attribute, Object> textAttributes) {
        Boolean strike = (Boolean)textAttributes.get(TextAttribute.STRIKETHROUGH);
        return TextAttribute.STRIKETHROUGH_ON.equals(strike);
    }

    protected void setFont(Map<AttributedCharacterIterator.Attribute, Object> attributes, Locale locale, boolean setFontLines, FontRecipient recipient) {
        JRBaseFont jrFont = new JRBaseFont(attributes);
        Exception initialException = null;
        Color forecolor = (Color)attributes.get(TextAttribute.FOREGROUND);
        float fontSizeScale = 1.0f;
        Integer scriptStyle = (Integer)attributes.get(TextAttribute.SUPERSCRIPT);
        if (scriptStyle != null && (TextAttribute.SUPERSCRIPT_SUB.equals(scriptStyle) || TextAttribute.SUPERSCRIPT_SUPER.equals(scriptStyle))) {
            fontSizeScale = 0.6666667f;
        }
        String pdfFontName = null;
        String pdfEncoding = null;
        boolean isPdfEmbedded = false;
        boolean isPdfSimulatedBold = false;
        boolean isPdfSimulatedItalic = false;
        FontInfo fontInfo = (FontInfo)attributes.get(JRTextAttribute.FONT_INFO);
        if (fontInfo == null) {
            fontInfo = this.fontUtil.getFontInfo(jrFont.getFontName(), locale);
        }
        if (fontInfo == null) {
            pdfFontName = jrFont.getPdfFontName();
            pdfEncoding = jrFont.getPdfEncoding();
            isPdfEmbedded = jrFont.isPdfEmbedded();
        } else {
            FontFamily family = fontInfo.getFontFamily();
            int pdfFontStyle = 0;
            FontFace fontFace = fontInfo.getFontFace();
            if (fontFace != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = fontInfo.getStyle();
            }
            if (pdfFontName == null && jrFont.isBold() && jrFont.isItalic() && (fontFace = family.getBoldItalicFace()) != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = 3;
            }
            if (pdfFontName == null && jrFont.isBold() && (fontFace = family.getBoldFace()) != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = 1;
            }
            if (pdfFontName == null && jrFont.isItalic() && (fontFace = family.getItalicFace()) != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = 2;
            }
            if (pdfFontName == null && (fontFace = family.getNormalFace()) != null) {
                pdfFontName = fontFace.getPdf();
                pdfFontName = pdfFontName == null ? fontFace.getTtf() : pdfFontName;
                pdfFontStyle = 0;
            }
            if (pdfFontName == null) {
                pdfFontName = jrFont.getPdfFontName();
            }
            pdfEncoding = family.getPdfEncoding() == null ? jrFont.getPdfEncoding() : family.getPdfEncoding();
            isPdfEmbedded = family.isPdfEmbedded() == null ? jrFont.isPdfEmbedded() : family.isPdfEmbedded().booleanValue();
            isPdfSimulatedBold = jrFont.isBold() && (pdfFontStyle & 1) == 0;
            isPdfSimulatedItalic = jrFont.isItalic() && (pdfFontStyle & 2) == 0;
        }
        PdfFontStyle pdfFontStyle = new PdfFontStyle(isPdfSimulatedBold, isPdfSimulatedItalic, setFontLines && jrFont.isUnderline(), setFontLines && jrFont.isStrikeThrough());
        try {
            recipient.setFont(pdfFontName, pdfEncoding, isPdfEmbedded, jrFont.getFontSize() * fontSizeScale, pdfFontStyle, forecolor);
        }
        catch (Exception e) {
            initialException = e;
        }
        if (!recipient.hasFont()) {
            byte[] bytes = null;
            try {
                bytes = this.getRepository().getBytesFromLocation(pdfFontName);
            }
            catch (JRException e) {
                throw new JRRuntimeException(EXCEPTION_MESSAGE_KEY_FONT_LOADING_ERROR, new Object[]{pdfFontName, pdfEncoding, isPdfEmbedded}, (Throwable)initialException);
            }
            recipient.setFont(pdfFontName, pdfEncoding, isPdfEmbedded, jrFont.getFontSize() * fontSizeScale, pdfFontStyle, forecolor, bytes);
        }
    }

    public void exportText(JRPrintText text) {
        JRStyledText styledText = this.styledTextUtil.getProcessedStyledText(text, this.noBackcolorSelector, null);
        if (styledText == null) {
            return;
        }
        AbstractPdfTextRenderer textRenderer = this.getTextRenderer(text, styledText);
        textRenderer.initialize(this, this.pdfProducer, this.tagHelper, text, styledText, this.getOffsetX(), this.getOffsetY());
        double angle = 0.0;
        switch (text.getRotation()) {
            case LEFT: {
                angle = 1.5707963267948966;
                break;
            }
            case RIGHT: {
                angle = -1.5707963267948966;
                break;
            }
            case UPSIDE_DOWN: {
                angle = Math.PI;
                break;
            }
        }
        AffineTransform atrans = new AffineTransform();
        atrans.rotate(angle, textRenderer.getX(), this.pageFormat.getPageHeight() - textRenderer.getY());
        this.pdfContent.transform(atrans);
        if (text.getMode() == ModeEnum.OPAQUE) {
            Color backcolor = text.getBackcolor();
            this.pdfContent.setFillColor(backcolor);
            this.pdfContent.fillRectangle(textRenderer.getX(), this.pageFormat.getPageHeight() - textRenderer.getY(), textRenderer.getWidth(), -textRenderer.getHeight());
            this.pdfContent.resetFillColor();
        }
        int forecolorAlpha = this.getSingleForecolorAlpha(styledText);
        this.pdfContent.setFillColorAlpha(forecolorAlpha);
        if (styledText.length() > 0) {
            textRenderer.render();
        }
        this.pdfContent.resetFillColor();
        atrans = new AffineTransform();
        atrans.rotate(-angle, textRenderer.getX(), this.pageFormat.getPageHeight() - textRenderer.getY());
        this.pdfContent.transform(atrans);
        this.exportBox(text.getLineBox(), (JRPrintElement)text);
    }

    protected int getSingleForecolorAlpha(JRStyledText styledText) {
        Color forecolor = (Color)styledText.getGlobalAttributes().get(TextAttribute.FOREGROUND);
        if (forecolor == null || forecolor.getAlpha() == 255) {
            return 255;
        }
        List runs = styledText.getRuns();
        if (runs.size() > 1) {
            for (JRStyledText.Run run : runs) {
                Color runForecolor = (Color)run.attributes.get(TextAttribute.FOREGROUND);
                if (runForecolor == null || runForecolor.getAlpha() == forecolor.getAlpha()) continue;
                return 255;
            }
        }
        return forecolor.getAlpha();
    }

    public void exportFieldText(JRPrintText text, PdfFieldTypeEnum fieldType) {
        String readOnly;
        float borderWidth;
        PdfTextField pdfTextField;
        String fieldName = text.getPropertiesMap().getProperty(PDF_FIELD_NAME);
        fieldName = fieldName == null || fieldName.trim().length() == 0 ? "FIELD_" + text.getUUID() : fieldName;
        String value = null;
        value = text.getPropertiesMap().containsProperty(PDF_FIELD_VALUE) ? text.getPropertiesMap().getProperty(PDF_FIELD_VALUE) : text.getFullText();
        int llx = text.getX() + ((JRPdfExporterContext)this.exporterContext).getOffsetX();
        int lly = this.jasperPrint.getPageHeight() - text.getY() - ((JRPdfExporterContext)this.exporterContext).getOffsetY();
        int urx = llx + text.getWidth();
        int ury = this.jasperPrint.getPageHeight() - text.getY() - ((JRPdfExporterContext)this.exporterContext).getOffsetY() - text.getHeight();
        switch (fieldType) {
            case TEXT: {
                pdfTextField = this.pdfProducer.createTextField(llx, lly, urx, ury, fieldName);
                if (value == null) break;
                pdfTextField.setText(value);
                break;
            }
            case COMBO: {
                String[] comboChoices = this.getPdfFieldChoices(text);
                pdfTextField = this.pdfProducer.createComboField(llx, lly, urx, ury, fieldName, value, comboChoices);
                if (!this.propertiesUtil.getBooleanProperty(PDF_FIELD_COMBO_EDIT, false, new JRPropertiesHolder[]{text, this.jasperPrint})) break;
                pdfTextField.setEdit();
                break;
            }
            case LIST: {
                String[] listChoices = this.getPdfFieldChoices(text);
                pdfTextField = this.pdfProducer.createListField(llx, lly, urx, ury, fieldName, value, listChoices);
                break;
            }
            default: {
                throw new JRRuntimeException("Unknown field type " + (Object)((Object)fieldType));
            }
        }
        if (ModeEnum.OPAQUE == text.getMode()) {
            pdfTextField.setBackgroundColor(text.getBackcolor());
        }
        pdfTextField.setTextColor(text.getForecolor());
        switch (text.getHorizontalTextAlign()) {
            case RIGHT: {
                pdfTextField.setAlignment(PdfTextAlignment.RIGHT);
                break;
            }
            case CENTER: {
                pdfTextField.setAlignment(PdfTextAlignment.CENTER);
                break;
            }
            case JUSTIFIED: {
                pdfTextField.setAlignment(PdfTextAlignment.JUSTIFIED);
                break;
            }
            default: {
                pdfTextField.setAlignment(PdfTextAlignment.LEFT);
            }
        }
        JRPen pen = this.getFieldPen((JRPrintElement)text);
        if (pen != null && (borderWidth = (float)Math.round(pen.getLineWidth().floatValue())) > 0.0f) {
            pdfTextField.setBorderColor(pen.getLineColor());
            pdfTextField.setBorderWidth(borderWidth);
            String strBorderStyle = this.propertiesUtil.getProperty(PDF_FIELD_BORDER_STYLE, new JRPropertiesHolder[]{text, this.jasperPrint});
            PdfFieldBorderStyleEnum borderStyle = PdfFieldBorderStyleEnum.getByName(strBorderStyle);
            if (borderStyle == null) {
                borderStyle = pen.getLineStyle() == LineStyleEnum.DASHED ? PdfFieldBorderStyleEnum.DASHED : PdfFieldBorderStyleEnum.SOLID;
            }
            pdfTextField.setBorderStyle(borderStyle);
        }
        if ((readOnly = text.getPropertiesMap().getProperty(PDF_FIELD_READ_ONLY)) != null && Boolean.valueOf(readOnly).booleanValue()) {
            pdfTextField.setReadOnly();
        }
        HashMap<AttributedCharacterIterator.Attribute, Object> attributes = new HashMap<AttributedCharacterIterator.Attribute, Object>();
        this.fontUtil.getAttributesWithoutAwtFont(attributes, (JRFont)text);
        pdfTextField.setFont(attributes, this.getLocale());
        pdfTextField.setFontSize(text.getFontSize());
        boolean isMultiLine = JRPropertiesUtil.asBoolean((String)text.getPropertiesMap().getProperty(PDF_FIELD_TEXT_MULTILINE), (boolean)false);
        if (isMultiLine) {
            pdfTextField.setMultiline();
        }
        if (this.pageFormat.getOrientation() == OrientationEnum.LANDSCAPE) {
            pdfTextField.setRotation(90);
        }
        pdfTextField.setVisible();
        pdfTextField.add();
    }

    protected String[] getPdfFieldChoices(JRPrintText text) {
        String[] choices = null;
        String strChoices = text.getPropertiesMap().getProperty(PDF_FIELD_CHOICES);
        if (strChoices != null && strChoices.trim().length() > 0) {
            String choiceSeparators = this.propertiesUtil.getProperty(PDF_FIELD_CHOICE_SEPARATORS, new JRPropertiesHolder[]{text, this.jasperPrint});
            StringTokenizer tkzer = new StringTokenizer(strChoices, choiceSeparators);
            ArrayList<String> choicesList = new ArrayList<String>();
            while (tkzer.hasMoreTokens()) {
                choicesList.add(tkzer.nextToken());
            }
            choices = choicesList.toArray(new String[choicesList.size()]);
        }
        return choices;
    }

    public void exportFieldCheck(JRPrintElement element) {
        String readOnly;
        String checked;
        float borderWidth;
        String fieldName = element.getPropertiesMap().getProperty(PDF_FIELD_NAME);
        fieldName = fieldName == null || fieldName.trim().length() == 0 ? "FIELD_" + element.getUUID() : fieldName;
        PdfRadioCheck checkField = this.pdfProducer.createCheckField(element.getX() + ((JRPdfExporterContext)this.exporterContext).getOffsetX(), this.jasperPrint.getPageHeight() - element.getY() - ((JRPdfExporterContext)this.exporterContext).getOffsetY(), element.getX() + ((JRPdfExporterContext)this.exporterContext).getOffsetX() + element.getWidth(), this.jasperPrint.getPageHeight() - element.getY() - ((JRPdfExporterContext)this.exporterContext).getOffsetY() - element.getHeight(), fieldName, "checked");
        PdfFieldCheckTypeEnum checkType = PdfFieldCheckTypeEnum.getByName(element.getPropertiesMap().getProperty(PDF_FIELD_CHECK_TYPE));
        if (checkType != null) {
            checkField.setCheckType(checkType);
        }
        if (ModeEnum.OPAQUE == element.getMode()) {
            checkField.setBackgroundColor(element.getBackcolor());
        }
        checkField.setTextColor(element.getForecolor());
        JRPen pen = this.getFieldPen(element);
        if (pen != null && (borderWidth = (float)Math.round(pen.getLineWidth().floatValue())) > 0.0f) {
            checkField.setBorderColor(pen.getLineColor());
            checkField.setBorderWidth(borderWidth);
            String strBorderStyle = this.propertiesUtil.getProperty(PDF_FIELD_BORDER_STYLE, new JRPropertiesHolder[]{element, this.jasperPrint});
            PdfFieldBorderStyleEnum borderStyle = PdfFieldBorderStyleEnum.getByName(strBorderStyle);
            if (borderStyle == null) {
                borderStyle = pen.getLineStyle() == LineStyleEnum.DASHED ? PdfFieldBorderStyleEnum.DASHED : PdfFieldBorderStyleEnum.SOLID;
            }
            checkField.setBorderStyle(borderStyle);
        }
        if ((checked = element.getPropertiesMap().getProperty(PDF_FIELD_CHECKED)) != null) {
            checkField.setChecked(Boolean.valueOf(checked));
        }
        if ((readOnly = element.getPropertiesMap().getProperty(PDF_FIELD_READ_ONLY)) != null && Boolean.valueOf(readOnly).booleanValue()) {
            checkField.setReadOnly();
        }
        checkField.add();
    }

    public void exportFieldRadio(JRPrintElement element) throws IOException {
        float borderWidth;
        String fieldName = element.getPropertiesMap().getProperty(PDF_FIELD_NAME);
        fieldName = fieldName == null || fieldName.trim().length() == 0 ? "FIELD_" + element.getUUID() : fieldName;
        PdfRadioCheck radioField = this.pdfProducer.getRadioField(element.getX() + ((JRPdfExporterContext)this.exporterContext).getOffsetX(), this.jasperPrint.getPageHeight() - element.getY() - ((JRPdfExporterContext)this.exporterContext).getOffsetY(), element.getX() + ((JRPdfExporterContext)this.exporterContext).getOffsetX() + element.getWidth(), this.jasperPrint.getPageHeight() - element.getY() - ((JRPdfExporterContext)this.exporterContext).getOffsetY() - element.getHeight(), fieldName, "FIELD_" + element.getUUID());
        PdfFieldCheckTypeEnum checkType = PdfFieldCheckTypeEnum.getByName(element.getPropertiesMap().getProperty(PDF_FIELD_CHECK_TYPE));
        if (checkType != null) {
            radioField.setCheckType(checkType);
        }
        if (ModeEnum.OPAQUE == element.getMode()) {
            radioField.setBackgroundColor(element.getBackcolor());
        }
        radioField.setTextColor(element.getForecolor());
        JRPen pen = this.getFieldPen(element);
        if (pen != null && (borderWidth = (float)Math.round(pen.getLineWidth().floatValue())) > 0.0f) {
            radioField.setBorderColor(pen.getLineColor());
            radioField.setBorderWidth(borderWidth);
            String strBorderStyle = this.propertiesUtil.getProperty(PDF_FIELD_BORDER_STYLE, new JRPropertiesHolder[]{element, this.jasperPrint});
            PdfFieldBorderStyleEnum borderStyle = PdfFieldBorderStyleEnum.getByName(strBorderStyle);
            if (borderStyle == null) {
                borderStyle = pen.getLineStyle() == LineStyleEnum.DASHED ? PdfFieldBorderStyleEnum.DASHED : PdfFieldBorderStyleEnum.SOLID;
            }
            radioField.setBorderStyle(borderStyle);
        }
        radioField.setOnValue("FIELD_" + element.getUUID());
        String checked = element.getPropertiesMap().getProperty(PDF_FIELD_CHECKED);
        radioField.setChecked(Boolean.valueOf(checked));
        String readOnly = element.getPropertiesMap().getProperty(PDF_FIELD_READ_ONLY);
        if (readOnly != null && Boolean.valueOf(readOnly).booleanValue()) {
            radioField.setReadOnly();
        }
        radioField.addToGroup();
    }

    protected JRPen getFieldPen(JRPrintElement element) {
        JRLineBox box;
        JRPen pen = null;
        JRLineBox jRLineBox = box = element instanceof JRBoxContainer ? ((JRBoxContainer)element).getLineBox() : null;
        if (box == null) {
            pen = element instanceof JRCommonGraphicElement ? ((JRCommonGraphicElement)element).getLinePen() : null;
        } else {
            Float lineWidth = box.getPen().getLineWidth();
            if (lineWidth.floatValue() == 0.0f) {
                if (((JRBasePen)box.getTopPen()).isIdentical((Object)box.getLeftPen()) && ((JRBasePen)box.getTopPen()).isIdentical((Object)box.getBottomPen()) && ((JRBasePen)box.getTopPen()).isIdentical((Object)box.getRightPen()) && box.getTopPen().getLineWidth().floatValue() > 0.0f) {
                    pen = new JRBasePen((JRPenContainer)box);
                    pen.setLineWidth(box.getTopPen().getLineWidth());
                    pen.setLineColor(box.getTopPen().getLineColor());
                    pen.setLineStyle(box.getTopPen().getLineStyle());
                }
            } else {
                pen = new JRBasePen((JRPenContainer)box);
                pen.setLineWidth(lineWidth);
                pen.setLineColor(box.getPen().getLineColor());
                pen.setLineStyle(box.getPen().getLineStyle());
            }
        }
        return pen;
    }

    protected AbstractPdfTextRenderer getTextRenderer(JRPrintText text, JRStyledText styledText) {
        return this.pdfProducer.getTextRenderer(this.createPdfTextRendererContext(text, styledText, this.getTextLocale(text)));
    }

    protected void exportBox(JRLineBox box, JRPrintElement element) {
        this.exportTopPen((JRPen)box.getTopPen(), (JRPen)box.getLeftPen(), (JRPen)box.getRightPen(), element);
        this.exportLeftPen((JRPen)box.getTopPen(), (JRPen)box.getLeftPen(), (JRPen)box.getBottomPen(), element);
        this.exportBottomPen((JRPen)box.getLeftPen(), (JRPen)box.getBottomPen(), (JRPen)box.getRightPen(), element);
        this.exportRightPen((JRPen)box.getTopPen(), (JRPen)box.getBottomPen(), (JRPen)box.getRightPen(), element);
        this.pdfContent.setLineDash(0.0f);
        this.pdfContent.setLineCap(LineCapStyle.PROJECTING_SQUARE);
    }

    protected void exportPen(JRPen pen, JRPrintElement element) {
        this.exportTopPen(pen, pen, pen, element);
        this.exportLeftPen(pen, pen, pen, element);
        this.exportBottomPen(pen, pen, pen, element);
        this.exportRightPen(pen, pen, pen, element);
        this.pdfContent.setLineDash(0.0f);
        this.pdfContent.setLineCap(LineCapStyle.PROJECTING_SQUARE);
    }

    protected void exportTopPen(JRPen topPen, JRPen leftPen, JRPen rightPen, JRPrintElement element) {
        if (topPen.getLineWidth().floatValue() > 0.0f) {
            float leftOffset = leftPen.getLineWidth().floatValue() / 2.0f;
            float rightOffset = rightPen.getLineWidth().floatValue() / 2.0f;
            int lcOffsetX = this.getOffsetX();
            int lcOffsetY = this.getOffsetY();
            this.preparePen(topPen, LineCapStyle.BUTT);
            if (topPen.getLineStyle() == LineStyleEnum.DOUBLE) {
                float topOffset = topPen.getLineWidth().floatValue();
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX) - leftOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset / 3.0f, (float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset / 3.0f);
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX) + leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) - topOffset / 3.0f, (float)(element.getX() + lcOffsetX + element.getWidth()) - rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) - topOffset / 3.0f);
            } else {
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX) - leftOffset, this.pageFormat.getPageHeight() - element.getY() - lcOffsetY, (float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset, this.pageFormat.getPageHeight() - element.getY() - lcOffsetY);
            }
            this.resetPen();
        }
    }

    protected void exportLeftPen(JRPen topPen, JRPen leftPen, JRPen bottomPen, JRPrintElement element) {
        if (leftPen.getLineWidth().floatValue() > 0.0f) {
            float topOffset = topPen.getLineWidth().floatValue() / 2.0f;
            float bottomOffset = bottomPen.getLineWidth().floatValue() / 2.0f;
            int lcOffsetX = this.getOffsetX();
            int lcOffsetY = this.getOffsetY();
            this.preparePen(leftPen, LineCapStyle.BUTT);
            if (leftPen.getLineStyle() == LineStyleEnum.DOUBLE) {
                float leftOffset = leftPen.getLineWidth().floatValue();
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX) - leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset, (float)(element.getX() + lcOffsetX) - leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset);
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX) + leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) - topOffset / 3.0f, (float)(element.getX() + lcOffsetX) + leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) + bottomOffset / 3.0f);
            } else {
                this.pdfContent.strokeLine(element.getX() + lcOffsetX, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset, element.getX() + lcOffsetX, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset);
            }
            this.resetPen();
        }
    }

    protected void exportBottomPen(JRPen leftPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element) {
        if (bottomPen.getLineWidth().floatValue() > 0.0f) {
            float leftOffset = leftPen.getLineWidth().floatValue() / 2.0f;
            float rightOffset = rightPen.getLineWidth().floatValue() / 2.0f;
            int lcOffsetX = this.getOffsetX();
            int lcOffsetY = this.getOffsetY();
            this.preparePen(bottomPen, LineCapStyle.BUTT);
            if (bottomPen.getLineStyle() == LineStyleEnum.DOUBLE) {
                float bottomOffset = bottomPen.getLineWidth().floatValue();
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX) - leftOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset / 3.0f, (float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset / 3.0f);
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX) + leftOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) + bottomOffset / 3.0f, (float)(element.getX() + lcOffsetX + element.getWidth()) - rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) + bottomOffset / 3.0f);
            } else {
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX) - leftOffset, this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight(), (float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset, this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight());
            }
            this.resetPen();
        }
    }

    protected void exportRightPen(JRPen topPen, JRPen bottomPen, JRPen rightPen, JRPrintElement element) {
        if (rightPen.getLineWidth().floatValue() > 0.0f) {
            float topOffset = topPen.getLineWidth().floatValue() / 2.0f;
            float bottomOffset = bottomPen.getLineWidth().floatValue() / 2.0f;
            int lcOffsetX = this.getOffsetX();
            int lcOffsetY = this.getOffsetY();
            this.preparePen(rightPen, LineCapStyle.BUTT);
            if (rightPen.getLineStyle() == LineStyleEnum.DOUBLE) {
                float rightOffset = rightPen.getLineWidth().floatValue();
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset, (float)(element.getX() + lcOffsetX + element.getWidth()) + rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset);
                this.pdfContent.strokeLine((float)(element.getX() + lcOffsetX + element.getWidth()) - rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) - topOffset / 3.0f, (float)(element.getX() + lcOffsetX + element.getWidth()) - rightOffset / 3.0f, (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) + bottomOffset / 3.0f);
            } else {
                this.pdfContent.strokeLine(element.getX() + lcOffsetX + element.getWidth(), (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY) + topOffset, element.getX() + lcOffsetX + element.getWidth(), (float)(this.pageFormat.getPageHeight() - element.getY() - lcOffsetY - element.getHeight()) - bottomOffset);
            }
            this.resetPen();
        }
    }

    private void preparePen(JRPen pen, LineCapStyle lineCap) {
        float lineWidth = pen.getLineWidth().floatValue();
        if (lineWidth <= 0.0f) {
            return;
        }
        PdfContent pdfContent = this.pdfProducer.getPdfContent();
        pdfContent.setLineWidth(lineWidth);
        pdfContent.setLineCap(lineCap);
        Color color = pen.getLineColor();
        pdfContent.setStrokeColor(color);
        block0 : switch (pen.getLineStyle()) {
            case DOUBLE: {
                pdfContent.setLineWidth(lineWidth / 3.0f);
                pdfContent.setLineDash(0.0f);
                break;
            }
            case DOTTED: {
                switch (lineCap) {
                    case BUTT: {
                        pdfContent.setLineDash(lineWidth, lineWidth, 0.0f);
                        break block0;
                    }
                    case PROJECTING_SQUARE: {
                        pdfContent.setLineDash(0.0f, 2.0f * lineWidth, 0.0f);
                        break block0;
                    }
                }
                break;
            }
            case DASHED: {
                switch (lineCap) {
                    case BUTT: {
                        pdfContent.setLineDash(5.0f * lineWidth, 3.0f * lineWidth, 0.0f);
                        break block0;
                    }
                    case PROJECTING_SQUARE: {
                        pdfContent.setLineDash(4.0f * lineWidth, 4.0f * lineWidth, 0.0f);
                        break block0;
                    }
                }
                break;
            }
            default: {
                pdfContent.setLineDash(0.0f);
            }
        }
    }

    private void resetPen() {
        this.pdfContent.resetStrokeColor();
    }

    protected static synchronized void registerFonts() {
        if (!fontsRegistered) {
            List fontDirs;
            List fontFiles = JRPropertiesUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).getProperties(PDF_FONT_FILES_PREFIX);
            if (!fontFiles.isEmpty()) {
                for (JRPropertiesUtil.PropertySuffix font : fontFiles) {
                    String file = font.getValue();
                    if (file.toLowerCase().endsWith(".ttc")) {
                        FontFactory.register((String)file);
                        continue;
                    }
                    String alias = font.getSuffix();
                    FontFactory.register((String)file, (String)alias);
                }
            }
            if (!(fontDirs = JRPropertiesUtil.getInstance((JasperReportsContext)DefaultJasperReportsContext.getInstance()).getProperties(PDF_FONT_DIRS_PREFIX)).isEmpty()) {
                for (JRPropertiesUtil.PropertySuffix dir : fontDirs) {
                    FontFactory.registerDirectory((String)dir.getValue());
                }
            }
            fontsRegistered = true;
        }
    }

    protected void initBookmarks(List<ExporterInputItem> items) {
        this.bookmarkStack = new BookmarkStack();
        int rootLevel = items.size() > 1 && ((PdfExporterConfiguration)this.getCurrentConfiguration()).isCreatingBatchModeBookmarks() != false ? -1 : 0;
        Bookmark bookmark = new Bookmark(this.pdfProducer.getRootOutline(), rootLevel);
        this.bookmarkStack.push(bookmark);
    }

    protected void addBookmark(int level, String title, int x, int y) {
        if (!this.bookmarksEnabled) {
            return;
        }
        Bookmark parent = this.bookmarkStack.peek();
        while (parent.level >= level) {
            this.bookmarkStack.pop();
            parent = this.bookmarkStack.peek();
        }
        if (!((PdfReportConfiguration)this.getCurrentItemConfiguration()).isCollapseMissingBookmarkLevels().booleanValue()) {
            for (int i = parent.level + 1; i < level; ++i) {
                Bookmark emptyBookmark = new Bookmark(parent, EMPTY_BOOKMARK_TITLE);
                this.bookmarkStack.push(emptyBookmark);
                parent = emptyBookmark;
            }
        }
        int height = OrientationEnum.LANDSCAPE.equals((Object)this.pageFormat.getOrientation()) ? y : this.pageFormat.getPageHeight() - y;
        Bookmark bookmark = new Bookmark(parent, x, height, title);
        this.bookmarkStack.push(bookmark);
    }

    protected void setAnchor(PdfChunk chunk, JRPrintAnchor anchor, JRPrintElement element) {
        String anchorName = anchor.getAnchorName();
        if (anchorName != null) {
            chunk.setLocalDestination(anchorName);
        }
        if (anchor.getBookmarkLevel() != 0) {
            if (anchorName == null) {
                anchorName = element instanceof JRPrintText ? ((JRPrintText)element).getFullText() : null;
            }
            int x = OrientationEnum.LANDSCAPE.equals((Object)this.pageFormat.getOrientation()) ? this.getOffsetY() + element.getY() : this.getOffsetX() + element.getX();
            int y = OrientationEnum.LANDSCAPE.equals((Object)this.pageFormat.getOrientation()) ? this.getOffsetX() + element.getX() : this.getOffsetY() + element.getY();
            this.addBookmark(anchor.getBookmarkLevel(), anchorName, x, y);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exportFrame(JRPrintFrame frame) throws IOException, JRException {
        if (frame.getMode() == ModeEnum.OPAQUE) {
            int x = frame.getX() + this.getOffsetX();
            int y = frame.getY() + this.getOffsetY();
            Color backcolor = frame.getBackcolor();
            PdfContent pdfContent = this.pdfProducer.getPdfContent();
            pdfContent.setFillColor(backcolor);
            pdfContent.fillRectangle(x, this.pageFormat.getPageHeight() - y, frame.getWidth(), -frame.getHeight());
            pdfContent.resetFillColor();
        }
        this.setFrameElementsOffset(frame, false);
        try {
            this.exportElements(frame.getElements());
        }
        finally {
            this.restoreElementOffsets();
        }
        this.exportBox(frame.getLineBox(), (JRPrintElement)frame);
    }

    protected PrintPageFormat getCurrentPageFormat() {
        return this.pageFormat;
    }

    protected int getOffsetX() {
        return super.getOffsetX() + (this.insideFrame() ? 0 : (this.crtDocumentPageNumber % 2 == 0 ? this.crtEvenPageOffsetX : this.crtOddPageOffsetX));
    }

    protected int getOffsetY() {
        return super.getOffsetY() + (this.insideFrame() ? 0 : (this.crtDocumentPageNumber % 2 == 0 ? this.crtEvenPageOffsetY : this.crtOddPageOffsetY));
    }

    protected void exportGenericElement(JRGenericPrintElement element) {
        GenericElementPdfHandler handler = (GenericElementPdfHandler)GenericElementHandlerEnviroment.getInstance((JasperReportsContext)this.getJasperReportsContext()).getElementHandler(element.getGenericType(), PDF_EXPORTER_KEY);
        if (handler != null) {
            handler.exportElement((JRPdfExporterContext)this.exporterContext, element);
        } else if (log.isDebugEnabled()) {
            log.debug((Object)("No PDF generic element handler for " + element.getGenericType()));
        }
    }

    public String getExporterKey() {
        return PDF_EXPORTER_KEY;
    }

    public String getExporterPropertiesPrefix() {
        return PDF_EXPORTER_PROPERTIES_PREFIX;
    }

    public static int getIntegerPermissions(String permissions) {
        int permission = 0;
        if (permissions != null && permissions.length() > 0) {
            String[] perms;
            for (String perm : perms = permissions.split("\\|")) {
                if (PdfPermissionsEnum.ALL.equals((Object)PdfPermissionsEnum.getByName(perm))) {
                    permission = PdfExporterConfiguration.ALL_PERMISSIONS;
                    break;
                }
                if (perm == null || perm.length() <= 0) continue;
                permission |= PdfPermissionsEnum.getByName(perm).getPdfPermission().intValue();
            }
        }
        return permission;
    }

    static {
        pdfProducerCache = new JRSingletonCache(PdfProducerFactory.class);
    }

    protected class ExporterContext
    extends JRAbstractExporter.BaseExporterContext
    implements JRPdfExporterContext {
        protected ExporterContext() {
            super((JRAbstractExporter)JRPdfExporter.this);
        }

        @Override
        public PdfWriter getPdfWriter() {
            if (JRPdfExporter.this.pdfProducer instanceof ClassicPdfProducer) {
                return ((ClassicPdfProducer)JRPdfExporter.this.pdfProducer).getPdfWriter();
            }
            throw new JRRuntimeException("Not using the classic PDF producer");
        }

        @Override
        public PdfProducer getPdfProducer() {
            return JRPdfExporter.this.pdfProducer;
        }
    }

    private class InternalImageProcessor {
        private final JRPrintImage printImage;
        private final RenderersCache imageRenderersCache;
        private final int topPadding;
        private final int leftPadding;
        private final int bottomPadding;
        private final int rightPadding;
        private final int availableImageWidth;
        private final int availableImageHeight;

        private InternalImageProcessor(JRPrintImage printImage) {
            this.printImage = printImage;
            this.imageRenderersCache = printImage.isUsingCache() ? JRPdfExporter.this.renderersCache : new RenderersCache(JRPdfExporter.this.getJasperReportsContext());
            this.topPadding = printImage.getLineBox().getTopPadding();
            this.leftPadding = printImage.getLineBox().getLeftPadding();
            this.bottomPadding = printImage.getLineBox().getBottomPadding();
            this.rightPadding = printImage.getLineBox().getRightPadding();
            int tmpAvailableImageWidth = printImage.getWidth() - this.leftPadding - this.rightPadding;
            this.availableImageWidth = tmpAvailableImageWidth < 0 ? 0 : tmpAvailableImageWidth;
            int tmpAvailableImageHeight = printImage.getHeight() - this.topPadding - this.bottomPadding;
            this.availableImageHeight = tmpAvailableImageHeight < 0 ? 0 : tmpAvailableImageHeight;
        }

        private InternalImageProcessorResult process(Renderable renderer) throws JRException, IOException {
            InternalImageProcessorResult imageProcessorResult = null;
            if (renderer instanceof ResourceRenderer) {
                renderer = this.imageRenderersCache.getLoadedRenderer((ResourceRenderer)renderer);
            }
            if (renderer instanceof Graphics2DRenderable) {
                imageProcessorResult = this.processGraphics2D(renderer.getId(), (Graphics2DRenderable)renderer);
            } else if (renderer instanceof DataRenderable) {
                boolean isSvgData = JRPdfExporter.this.getRendererUtil().isSvgData((DataRenderable)renderer);
                if (isSvgData) {
                    imageProcessorResult = this.processGraphics2D(renderer.getId(), (Graphics2DRenderable)new WrappingSvgDataToGraphics2DRenderer((DataRenderable)renderer));
                } else {
                    switch (this.printImage.getScaleImage()) {
                        case CLIP: {
                            imageProcessorResult = this.imageClip(this.getImageFromCache(renderer.getId(), (DataRenderable)renderer));
                            break;
                        }
                        case FILL_FRAME: {
                            imageProcessorResult = this.imageFillFrame(this.getImageFromCache(renderer.getId(), (DataRenderable)renderer));
                            break;
                        }
                        default: {
                            imageProcessorResult = this.imageRetainShape(this.getImageFromCache(renderer.getId(), (DataRenderable)renderer));
                        }
                    }
                }
            } else {
                throw new JRException("engine.renderable.must.implement.interface", new Object[]{renderer.getClass().getName(), DataRenderable.class.getName() + " or " + Graphics2DRenderable.class.getName()});
            }
            return imageProcessorResult;
        }

        private Pair<PdfImage, ExifOrientationEnum> getImageFromCache(String rendererId, DataRenderable renderer) throws JRException {
            Pair imagePair = null;
            if (this.printImage.isUsingCache() && JRPdfExporter.this.loadedImagesMap.containsKey(rendererId)) {
                imagePair = JRPdfExporter.this.loadedImagesMap.get(rendererId);
            } else {
                byte[] data = renderer.getData(JRPdfExporter.this.jasperReportsContext);
                if (ImageTypeEnum.WEBP == JRTypeSniffer.getImageTypeValue((byte[])data)) {
                    WrappingImageDataToGraphics2DRenderer graphics2DRenderer = new WrappingImageDataToGraphics2DRenderer(renderer);
                    data = new WrappingRenderToImageDataRenderer((Graphics2DRenderable)graphics2DRenderer, (DimensionRenderable)graphics2DRenderer, null).getData(JRPdfExporter.this.jasperReportsContext);
                }
                try {
                    imagePair = new Pair((Object)JRPdfExporter.this.pdfProducer.createImage(data, true), (Object)ImageUtil.getExifOrientation((byte[])data));
                }
                catch (Exception e) {
                    throw new JRException((Throwable)e);
                }
                if (this.printImage.isUsingCache()) {
                    JRPdfExporter.this.loadedImagesMap.put(rendererId, (Pair<PdfImage, ExifOrientationEnum>)imagePair);
                }
            }
            return imagePair;
        }

        private InternalImageProcessorResult imageClip(Pair<PdfImage, ExifOrientationEnum> imagePair) throws JRException {
            PdfImage image = (PdfImage)imagePair.first();
            image.scalePercent(100.0f);
            image.setRotationDegrees(0);
            int plainWidth = (int)image.getPlainWidth();
            int plainHeight = (int)image.getPlainHeight();
            int clipWidth = Math.min(plainWidth, this.availableImageWidth);
            int clipHeight = Math.min(plainHeight, this.availableImageHeight);
            int xoffset = (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this.printImage) * (float)(this.availableImageWidth - plainWidth));
            int yoffset = (int)(ImageUtil.getYAlignFactor((JRImageAlignment)this.printImage) * (float)(this.availableImageHeight - plainHeight));
            int translateX = xoffset;
            int translateY = yoffset;
            int angle = 0;
            switch (ImageUtil.getRotation((RotationEnum)this.printImage.getRotation(), (ExifOrientationEnum)((ExifOrientationEnum)imagePair.second()))) {
                case LEFT: {
                    clipWidth = Math.min(plainWidth, this.availableImageHeight);
                    clipHeight = Math.min(plainHeight, this.availableImageWidth);
                    xoffset = (int)(ImageUtil.getYAlignFactor((JRImageAlignment)this.printImage) * (float)(this.availableImageWidth - plainHeight));
                    yoffset = (int)((1.0f - ImageUtil.getXAlignFactor((JRImageAlignment)this.printImage)) * (float)(this.availableImageHeight - plainWidth));
                    translateX = (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this.printImage) * (float)(this.availableImageHeight - plainWidth));
                    translateY = xoffset;
                    angle = 90;
                    break;
                }
                case RIGHT: {
                    clipWidth = Math.min(plainWidth, this.availableImageHeight);
                    clipHeight = Math.min(plainHeight, this.availableImageWidth);
                    xoffset = (int)((1.0f - ImageUtil.getYAlignFactor((JRImageAlignment)this.printImage)) * (float)(this.availableImageWidth - plainHeight));
                    yoffset = (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this.printImage) * (float)(this.availableImageHeight - plainWidth));
                    translateX = (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this.printImage) * (float)(this.availableImageHeight - plainWidth));
                    translateY = (int)(ImageUtil.getYAlignFactor((JRImageAlignment)this.printImage) * (float)(this.availableImageWidth - plainHeight));
                    angle = -90;
                    break;
                }
                case UPSIDE_DOWN: {
                    clipWidth = Math.min(plainWidth, this.availableImageWidth);
                    clipHeight = Math.min(plainHeight, this.availableImageHeight);
                    xoffset = (int)((1.0f - ImageUtil.getXAlignFactor((JRImageAlignment)this.printImage)) * (float)(this.availableImageWidth - plainWidth));
                    yoffset = (int)((1.0f - ImageUtil.getYAlignFactor((JRImageAlignment)this.printImage)) * (float)(this.availableImageHeight - plainHeight));
                    translateX = (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this.printImage) * (float)(this.availableImageWidth - plainWidth));
                    translateY = (int)(ImageUtil.getYAlignFactor((JRImageAlignment)this.printImage) * (float)(this.availableImageHeight - plainHeight));
                    angle = 180;
                    break;
                }
            }
            translateX = translateX > 0 ? 0 : translateX;
            translateY = translateY > 0 ? 0 : translateY;
            image = JRPdfExporter.this.pdfProducer.clipImage(image, clipWidth, clipHeight, translateX, translateY);
            image.scaleAbsolute(plainWidth, plainHeight);
            image.setRotationDegrees(angle);
            PdfChunk chunk = JRPdfExporter.this.pdfProducer.createChunk(image);
            return new InternalImageProcessorResult(chunk, image.getScaledWidth(), image.getScaledHeight(), xoffset, yoffset);
        }

        private InternalImageProcessorResult imageFillFrame(Pair<PdfImage, ExifOrientationEnum> imagePair) throws JRException {
            PdfImage image = (PdfImage)imagePair.first();
            switch (ImageUtil.getRotation((RotationEnum)this.printImage.getRotation(), (ExifOrientationEnum)((ExifOrientationEnum)imagePair.second()))) {
                case LEFT: {
                    image.scaleAbsolute(this.availableImageHeight, this.availableImageWidth);
                    image.setRotationDegrees(90);
                    break;
                }
                case RIGHT: {
                    image.scaleAbsolute(this.availableImageHeight, this.availableImageWidth);
                    image.setRotationDegrees(-90);
                    break;
                }
                case UPSIDE_DOWN: {
                    image.scaleAbsolute(this.availableImageWidth, this.availableImageHeight);
                    image.setRotationDegrees(180);
                    break;
                }
                default: {
                    image.scaleAbsolute(this.availableImageWidth, this.availableImageHeight);
                    image.setRotationDegrees(0);
                }
            }
            PdfChunk chunk = JRPdfExporter.this.pdfProducer.createChunk(image);
            return new InternalImageProcessorResult(chunk, image.getScaledWidth(), image.getScaledHeight(), 0, 0);
        }

        private InternalImageProcessorResult imageRetainShape(Pair<PdfImage, ExifOrientationEnum> imagePair) throws JRException {
            float plainWidth = 0.0f;
            float plainHeight = 0.0f;
            int xoffset = 0;
            int yoffset = 0;
            PdfImage image = (PdfImage)imagePair.first();
            image.setRotationDegrees(0);
            switch (ImageUtil.getRotation((RotationEnum)this.printImage.getRotation(), (ExifOrientationEnum)((ExifOrientationEnum)imagePair.second()))) {
                case LEFT: {
                    image.scaleToFit(this.availableImageHeight, this.availableImageWidth);
                    plainWidth = image.getPlainHeight();
                    plainHeight = image.getPlainWidth();
                    image.setRotationDegrees(90);
                    break;
                }
                case RIGHT: {
                    image.scaleToFit(this.availableImageHeight, this.availableImageWidth);
                    plainWidth = image.getPlainHeight();
                    plainHeight = image.getPlainWidth();
                    image.setRotationDegrees(-90);
                    break;
                }
                case UPSIDE_DOWN: {
                    image.scaleToFit(this.availableImageWidth, this.availableImageHeight);
                    plainWidth = image.getPlainWidth();
                    plainHeight = image.getPlainHeight();
                    image.setRotationDegrees(180);
                    break;
                }
                default: {
                    image.scaleToFit(this.availableImageWidth, this.availableImageHeight);
                    plainWidth = image.getPlainWidth();
                    plainHeight = image.getPlainHeight();
                    image.setRotationDegrees(0);
                }
            }
            switch (this.printImage.getRotation()) {
                case LEFT: {
                    xoffset = (int)(ImageUtil.getYAlignFactor((JRImageAlignment)this.printImage) * ((float)this.availableImageWidth - plainWidth));
                    yoffset = (int)((1.0f - ImageUtil.getXAlignFactor((JRImageAlignment)this.printImage)) * ((float)this.availableImageHeight - plainHeight));
                    break;
                }
                case RIGHT: {
                    xoffset = (int)((1.0f - ImageUtil.getYAlignFactor((JRImageAlignment)this.printImage)) * ((float)this.availableImageWidth - plainWidth));
                    yoffset = (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this.printImage) * ((float)this.availableImageHeight - plainHeight));
                    break;
                }
                case UPSIDE_DOWN: {
                    xoffset = (int)((1.0f - ImageUtil.getXAlignFactor((JRImageAlignment)this.printImage)) * ((float)this.availableImageWidth - plainWidth));
                    yoffset = (int)((1.0f - ImageUtil.getYAlignFactor((JRImageAlignment)this.printImage)) * ((float)this.availableImageHeight - plainHeight));
                    break;
                }
                default: {
                    xoffset = (int)(ImageUtil.getXAlignFactor((JRImageAlignment)this.printImage) * ((float)this.availableImageWidth - plainWidth));
                    yoffset = (int)(ImageUtil.getYAlignFactor((JRImageAlignment)this.printImage) * ((float)this.availableImageHeight - plainHeight));
                }
            }
            xoffset = xoffset < 0 ? 0 : xoffset;
            yoffset = yoffset < 0 ? 0 : yoffset;
            PdfChunk chunk = JRPdfExporter.this.pdfProducer.createChunk(image);
            return new InternalImageProcessorResult(chunk, image.getScaledWidth(), image.getScaledHeight(), xoffset, yoffset);
        }

        private InternalImageProcessorResult processGraphics2D(String rendererId, Graphics2DRenderable renderer) throws JRException, IOException {
            Pair imagePair = null;
            if (this.printImage.isUsingCache() && JRPdfExporter.this.loadedImagesMap.containsKey(rendererId)) {
                imagePair = JRPdfExporter.this.loadedImagesMap.get(rendererId);
            } else {
                Dimension2D dimension;
                double renderWidth = 0.0;
                double renderHeight = 0.0;
                Dimension2D dimension2D = dimension = renderer instanceof DimensionRenderable ? ((DimensionRenderable)renderer).getDimension(JRPdfExporter.this.jasperReportsContext) : null;
                if (dimension == null) {
                    renderWidth = this.availableImageWidth;
                    renderHeight = this.availableImageHeight;
                } else {
                    renderWidth = dimension.getWidth();
                    renderHeight = dimension.getHeight();
                }
                PdfImage image = JRPdfExporter.this.pdfProducer.drawImage(this.printImage, renderer, ((PdfReportConfiguration)JRPdfExporter.this.getCurrentItemConfiguration()).isForceSvgShapes(), renderWidth, renderHeight);
                try {
                    imagePair = new Pair((Object)image, (Object)ExifOrientationEnum.NORMAL);
                }
                catch (Exception e) {
                    throw new JRException((Throwable)e);
                }
                if (this.printImage.isUsingCache()) {
                    JRPdfExporter.this.loadedImagesMap.put(rendererId, (Pair<PdfImage, ExifOrientationEnum>)imagePair);
                }
            }
            InternalImageProcessorResult imageProcessorResult = null;
            switch (this.printImage.getScaleImage()) {
                case CLIP: {
                    imageProcessorResult = this.imageClip(imagePair);
                    break;
                }
                case FILL_FRAME: {
                    imageProcessorResult = this.imageFillFrame(imagePair);
                    break;
                }
                default: {
                    imageProcessorResult = this.imageRetainShape(imagePair);
                }
            }
            return imageProcessorResult;
        }
    }

    private class InternalImageProcessorResult {
        private final PdfChunk chunk;
        private final float scaledWidth;
        private final float scaledHeight;
        private final int xoffset;
        private final int yoffset;

        private InternalImageProcessorResult(PdfChunk chunk, float scaledWidth, float scaledHeight, int xoffset, int yoffset) {
            this.chunk = chunk;
            this.scaledWidth = scaledWidth;
            this.scaledHeight = scaledHeight;
            this.xoffset = xoffset;
            this.yoffset = yoffset;
        }
    }

    protected static class BookmarkStack {
        LinkedList<Bookmark> stack = new LinkedList();

        BookmarkStack() {
        }

        void push(Bookmark bookmark) {
            this.stack.add(bookmark);
        }

        Bookmark pop() {
            return this.stack.removeLast();
        }

        Bookmark peek() {
            return this.stack.getLast();
        }
    }

    protected static class Bookmark {
        final PdfOutlineEntry pdfOutline;
        final int level;

        Bookmark(Bookmark parent, int x, int top, String title) {
            this.pdfOutline = parent.pdfOutline.createChild(title, x, top);
            this.level = parent.level + 1;
        }

        Bookmark(Bookmark parent, String title) {
            this.pdfOutline = parent.pdfOutline.createChild(title);
            this.level = parent.level + 1;
        }

        Bookmark(PdfOutlineEntry pdfOutline, int level) {
            this.pdfOutline = pdfOutline;
            this.level = level;
        }
    }
}

