/*
 * Decompiled with CFR 0.152.
 */
package com.swabunga.spell.swing;

import com.swabunga.spell.engine.SpellDictionary;
import com.swabunga.spell.engine.SpellDictionaryCachedDichoDisk;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.event.DocumentWordTokenizer;
import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.WordTokenizer;
import com.swabunga.spell.swing.JSpellDialog;
import com.swabunga.spell.swing.autospell.AutoSpellCheckHandler;
import com.swabunga.spell.swing.autospell.AutoSpellEditorKit;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.io.File;
import java.io.IOException;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.swing.JEditorPane;
import javax.swing.SwingUtilities;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyledEditorKit;

public class JTextComponentSpellChecker
implements SpellCheckListener {
    private String dialogTitle = null;
    private SpellChecker spellCheck = null;
    private JSpellDialog dlg = null;
    private JTextComponent textComp = null;
    private ResourceBundle messages;
    private SpellDictionary mainDict = null;
    private AutoSpellCheckHandler markHandler;

    public JTextComponentSpellChecker(SpellDictionary spellDictionary) {
        this(spellDictionary, null, null);
    }

    public JTextComponentSpellChecker(String string) throws IOException {
        this(string, null);
    }

    public JTextComponentSpellChecker(String string, String string2) throws IOException {
        this((SpellDictionary)new SpellDictionaryHashMap(new File(string)), null, string2);
    }

    public JTextComponentSpellChecker(String string, String string2, String string3) throws IOException {
        this((SpellDictionary)new SpellDictionaryHashMap(new File(string), new File(string2)), null, string3);
    }

    public JTextComponentSpellChecker(SpellDictionary spellDictionary, SpellDictionary spellDictionary2, String string) {
        this.spellCheck = new SpellChecker(spellDictionary);
        this.mainDict = spellDictionary;
        this.spellCheck.setCache();
        if (spellDictionary2 != null) {
            this.spellCheck.setUserDictionary(spellDictionary2);
        }
        this.spellCheck.addSpellCheckListener((SpellCheckListener)this);
        this.dialogTitle = string;
        this.messages = ResourceBundle.getBundle("com.swabunga.spell.swing.messages", Locale.getDefault());
        this.markHandler = new AutoSpellCheckHandler(this.spellCheck, this.messages);
    }

    public void setUserDictionary(SpellDictionary spellDictionary) {
        if (this.spellCheck != null) {
            this.spellCheck.setUserDictionary(spellDictionary);
        }
    }

    private void setupDialog(JTextComponent jTextComponent) {
        Component component = SwingUtilities.getRoot(jTextComponent);
        if (this.dlg != null && this.dlg.getOwner() == component) {
            return;
        }
        if (component != null && component instanceof Window) {
            if (component instanceof Frame) {
                this.dlg = new JSpellDialog((Frame)component, this.dialogTitle, true);
            }
            if (component instanceof Dialog) {
                this.dlg = new JSpellDialog((Dialog)component, this.dialogTitle, true);
            }
            if (this.dlg != null) {
                Window window = (Window)component;
                int n = (int)(window.getLocation().getX() + (double)(window.getWidth() / 2) - (double)(this.dlg.getWidth() / 2));
                int n2 = (int)(window.getLocation().getY() + (double)(window.getHeight() / 2) - (double)(this.dlg.getHeight() / 2));
                ((Component)this.dlg).setLocation(n, n2);
            }
        } else {
            this.dlg = new JSpellDialog((Frame)null, this.dialogTitle, true);
        }
    }

    public synchronized int spellCheck(JTextComponent jTextComponent) {
        this.setupDialog(jTextComponent);
        this.textComp = jTextComponent;
        DocumentWordTokenizer documentWordTokenizer = new DocumentWordTokenizer(jTextComponent.getDocument());
        int n = this.spellCheck.checkSpelling((WordTokenizer)documentWordTokenizer);
        jTextComponent.requestFocus();
        jTextComponent.setCaretPosition(0);
        this.textComp = null;
        try {
            if (this.mainDict instanceof SpellDictionaryCachedDichoDisk) {
                ((SpellDictionaryCachedDichoDisk)this.mainDict).saveCache();
            }
        }
        catch (IOException iOException) {
            System.err.println(iOException.getMessage());
        }
        return n;
    }

    public void startAutoSpellCheck(JEditorPane jEditorPane) {
        Document document = jEditorPane.getDocument();
        jEditorPane.setEditorKit(new AutoSpellEditorKit((StyledEditorKit)jEditorPane.getEditorKit()));
        jEditorPane.setDocument(document);
        this.markHandler.addJEditorPane(jEditorPane);
    }

    public void stopAutoSpellCheck(JEditorPane jEditorPane) {
        if (jEditorPane.getEditorKit() instanceof AutoSpellEditorKit) {
            Document document = jEditorPane.getDocument();
            StyledEditorKit styledEditorKit = ((AutoSpellEditorKit)jEditorPane.getEditorKit()).getStyledEditorKit();
            jEditorPane.setEditorKit(styledEditorKit);
            jEditorPane.setDocument(document);
        }
        this.markHandler.removeJEditorPane(jEditorPane);
    }

    public void spellingError(SpellCheckEvent spellCheckEvent) {
        spellCheckEvent.getSuggestions();
        int n = spellCheckEvent.getWordContextPosition();
        int n2 = n + spellCheckEvent.getInvalidWord().length();
        this.textComp.requestFocus();
        this.textComp.setCaretPosition(0);
        this.textComp.setCaretPosition(n);
        this.textComp.moveCaretPosition(n2);
        this.dlg.show(spellCheckEvent);
    }
}

