/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jguard.example.struts.admin.actions;

import java.security.Principal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.security.auth.Subject;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.sf.jguard.core.authentication.credentials.JGuardCredential;
import net.sf.jguard.core.principals.RolePrincipal;
import net.sf.jguard.example.struts.actions.BaseAction;
import net.sf.jguard.ext.authentication.AuthenticationException;
import net.sf.jguard.ext.authentication.manager.AuthenticationManager;
import net.sf.jguard.ext.registration.RegistrationException;
import net.sf.jguard.ext.registration.SubjectTemplate;
import net.sf.jguard.jee.authentication.http.HttpAuthenticationUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;

public class UserDispatchAction
extends BaseAction {
    private static Logger logger = Logger.getLogger((Class)(class$net$sf$jguard$example$struts$admin$actions$UserDispatchAction == null ? (class$net$sf$jguard$example$struts$admin$actions$UserDispatchAction = UserDispatchAction.class$((String)"net.sf.jguard.example.struts.admin.actions.UserDispatchAction")) : class$net$sf$jguard$example$struts$admin$actions$UserDispatchAction));
    static /* synthetic */ Class class$net$sf$jguard$example$struts$admin$actions$UserDispatchAction;

    public ActionForward list(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DynaActionForm dyna = (DynaActionForm)form;
        Set users = null;
        AuthenticationManager am = (AuthenticationManager)request.getSession().getServletContext().getAttribute("authenticationManager");
        try {
            users = am.getUsers();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)" listing users");
                Iterator usersIt = users.iterator();
                while (usersIt.hasNext()) {
                    Subject user = (Subject)usersIt.next();
                    logger.debug((Object)user);
                }
            }
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
        }
        ArrayList usersList = new ArrayList(users);
        dyna.set("users", usersList);
        return mapping.findForward("listUsersOK");
    }

    public ActionForward read(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        JGuardCredential jcred;
        DynaActionForm dyna = (DynaActionForm)form;
        AuthenticationManager authenticationManager = (AuthenticationManager)request.getSession().getServletContext().getAttribute("authenticationManager");
        Subject user = authenticationManager.findUser((String)dyna.get("login"));
        this.resetForm(dyna);
        Set<Object> privCred = user.getPrivateCredentials();
        Iterator<Object> itCred = privCred.iterator();
        while (itCred.hasNext()) {
            jcred = (JGuardCredential)itCred.next();
            dyna.set(jcred.getId(), jcred.getValue());
        }
        Set<Object> pubCred = user.getPublicCredentials();
        itCred = pubCred.iterator();
        while (itCred.hasNext()) {
            jcred = (JGuardCredential)itCred.next();
            dyna.set(jcred.getId(), jcred.getValue());
        }
        dyna.set("oldLogin", (Object)((String)dyna.get("login")));
        HashSet<Principal> principals = new HashSet<Principal>(user.getPrincipals());
        Set localPrincipals = authenticationManager.getLocalPrincipals();
        principals.retainAll(localPrincipals);
        dyna.set("principals", new ArrayList<Principal>(principals));
        HashSet tempCol = new HashSet(authenticationManager.getLocalPrincipals());
        tempCol.removeAll(user.getPrincipals());
        request.setAttribute("allPrincipals", tempCol);
        request.setAttribute("action", (Object)"update");
        return mapping.findForward("readUserOK");
    }

    public ActionForward newUser(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AuthenticationManager authenticationManager = (AuthenticationManager)request.getSession().getServletContext().getAttribute("authenticationManager");
        DynaActionForm dyna = (DynaActionForm)form;
        this.resetForm(dyna);
        request.setAttribute("allPrincipals", (Object)authenticationManager.getLocalPrincipals());
        request.setAttribute("action", (Object)"create");
        return mapping.findForward("readUserOK");
    }

    public ActionForward create(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        logger.debug((Object)" into UserDispatchAction.create");
        DynaActionForm dyna = (DynaActionForm)form;
        AuthenticationManager am = (AuthenticationManager)request.getSession().getServletContext().getAttribute("authenticationManager");
        SubjectTemplate st = new SubjectTemplate();
        HashSet privRequiredCred = new HashSet();
        this.addCredential(privRequiredCred, "login", (String)dyna.get("login"));
        this.addCredential(privRequiredCred, "password", (String)dyna.get("password"));
        st.setPrivateRequiredCredentials(privRequiredCred);
        HashSet publicRequiredCred = new HashSet();
        this.addCredential(publicRequiredCred, "firstname", (String)dyna.get("firstname"));
        this.addCredential(publicRequiredCred, "lastname", (String)dyna.get("lastname"));
        this.addCredential(publicRequiredCred, "location", (String)dyna.get("location"));
        st.setPublicRequiredCredentials(publicRequiredCred);
        HashSet privOptionalCred = new HashSet();
        this.addCredential(privOptionalCred, "country", (String)dyna.get("country"));
        this.addCredential(privOptionalCred, "religion", (String)dyna.get("religion"));
        st.setPrivateOptionalCredentials(privOptionalCred);
        HashSet publicOptionalCred = new HashSet();
        this.addCredential(publicOptionalCred, "hobbies", (String)dyna.get("hobbies"));
        st.setPublicOptionalCredentials(publicOptionalCred);
        st.getPrincipals().clear();
        String principalsNames = (String)dyna.get("userPrincipalsNames");
        logger.debug((Object)(" create user: principalsNames from form =" + principalsNames));
        try {
            SubjectTemplate stClone = (SubjectTemplate)am.getDefaultSubjectTemplate().clone();
            stClone.getPrincipals().clear();
            this.addPrincipals(principalsNames, stClone.getPrincipals(), am);
            Subject userCreated = am.createUser(st, stClone);
            logger.debug((Object)("user created =" + userCreated));
        }
        catch (RegistrationException e) {
            logger.error((Object)e.getMissingPrivateCredential());
            logger.error((Object)e.getMissingPublicCredential());
            logger.error((Object)e);
        }
        catch (AuthenticationException e) {
            logger.error((Object)e);
        }
        catch (CloneNotSupportedException e) {
            logger.error((Object)e);
        }
        return mapping.findForward("createUserOK");
    }

    public ActionForward update(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DynaActionForm dyna = (DynaActionForm)form;
        AuthenticationManager am = (AuthenticationManager)request.getSession().getServletContext().getAttribute("authenticationManager");
        Subject user = new Subject();
        Set<Object> privCred = user.getPrivateCredentials();
        this.addCredential(privCred, "login", (String)dyna.get("login"));
        this.addCredential(privCred, "password", (String)dyna.get("password"));
        this.addCredential(privCred, "country", (String)dyna.get("country"));
        this.addCredential(privCred, "religion", (String)dyna.get("religion"));
        Set<Object> publicCred = user.getPublicCredentials();
        this.addCredential(publicCred, "firstname", (String)dyna.get("firstname"));
        this.addCredential(publicCred, "lastname", (String)dyna.get("lastname"));
        this.addCredential(publicCred, "location", (String)dyna.get("location"));
        this.addCredential(publicCred, "hobbies", (String)dyna.get("hobbies"));
        user.getPrincipals().clear();
        String principalsNames = (String)dyna.get("userPrincipalsNames");
        logger.debug((Object)("update user :principalsNames from form =" + principalsNames));
        this.addPrincipals(principalsNames, user.getPrincipals(), am);
        JGuardCredential jcred = new JGuardCredential();
        jcred.setId("login");
        jcred.setValue((Object)((String)dyna.get("oldLogin")));
        try {
            am.updateUser(jcred, user);
            logger.debug((Object)("after update  user content=" + user));
        }
        catch (AuthenticationException e) {
            e.printStackTrace();
        }
        return mapping.findForward("updateUserOK");
    }

    public ActionForward delete(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        DynaActionForm dyna = (DynaActionForm)form;
        AuthenticationManager am = (AuthenticationManager)request.getSession().getServletContext().getAttribute("authenticationManager");
        Subject user = am.findUser((String)dyna.get("login"));
        try {
            am.deleteUser(user);
        }
        catch (AuthenticationException e) {
            logger.error((Object)e.getMessage());
        }
        return mapping.findForward("deleteUserOK");
    }

    private void resetForm(DynaActionForm dyna) {
        dyna.set("login", (Object)"");
        dyna.set("password", (Object)"");
        dyna.set("firstname", (Object)"");
        dyna.set("lastname", (Object)"");
        dyna.set("location", (Object)"");
        dyna.set("country", (Object)"");
        dyna.set("religion", (Object)"");
        dyna.set("hobbies", (Object)"");
        Collection tempCol = (Collection)dyna.get("principals");
        tempCol.clear();
        dyna.set("principals", (Object)tempCol);
    }

    private void addCredential(Set credentials, String id, String value) {
        if (StringUtils.isNotEmpty((String)value)) {
            JGuardCredential jcred = new JGuardCredential();
            jcred.setId(id);
            jcred.setValue((Object)value);
            credentials.add(jcred);
        }
    }

    private void addPrincipals(String principalNames, Set principalsSet, AuthenticationManager am) {
        logger.debug((Object)("principalNames=" + principalNames));
        if (!"".equals(principalNames)) {
            String[] prinNames = principalNames.split("\ufffd");
            for (int i = 0; i < prinNames.length; ++i) {
                try {
                    logger.debug((Object)("current principal name=" + prinNames[i]));
                    RolePrincipal principal = (RolePrincipal)am.getLocalPrincipal(prinNames[i]);
                    if (principal == null) {
                        logger.info((Object)"local principal not found");
                        return;
                    }
                    logger.debug((Object)("local principal found=" + principal));
                    principalsSet.add(principal);
                    continue;
                }
                catch (AuthenticationException e) {
                    logger.error((Object)e.getMessage());
                }
            }
        }
    }

    public ActionForward setActiveOnRolePrincipal(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String roleName = request.getParameter("roleName");
        String applicationName = request.getParameter("applicationName");
        boolean active = Boolean.valueOf(request.getParameter("active"));
        AuthenticationManager authenticationManager = (AuthenticationManager)request.getSession().getServletContext().getAttribute("authenticationManager");
        HttpAuthenticationUtils auth = (HttpAuthenticationUtils)request.getSession(true).getAttribute("authenticationUtils");
        try {
            authenticationManager.setActiveOnRolePrincipal(auth.getSubject(), roleName, applicationName, active);
        }
        catch (AuthenticationException e) {
            logger.error((Object)e.getMessage());
        }
        return mapping.findForward("welcome");
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

