<%@ taglib prefix="html" uri="http://struts.apache.org/tags-html-el" %>
<%@ taglib prefix="c" uri="http://java.sun.com/jstl/core" %>
<link href="<html:rewrite page="/../css/jGuardExample.css" />" rel="stylesheet" type="text/css">
<script type="text/javascript">

	function save(){
		var prinNames = document.getElementById('userPrincipals');
		var strUserPrincipals="";
		
		for(var r=1;r<prinNames.options.length;r++){
		    strUserPrincipals += prinNames.options[r].value+"";
		}

		document.forms[0].userPrincipalsNames.value=strUserPrincipals;
		document.forms[0].submit();
	}
	
	function addPrincipal(var1, var2){
		moveOptions(var1, var2);
	}

	function removePrincipal(var1, var2){
		moveOptions(var1, var2);
	}

	function addOption(theSel, theText, theValue){
		var newOpt = new Option(theText, theValue);
		var selLength = theSel.length;
		theSel.options[selLength] = newOpt;
	}

	function deleteOption(theSel, theIndex){
		var selLength = theSel.length;
		if(selLength>0)	{
			theSel.options[theIndex] = null;
		}
	}

	function moveOptions(theSelFrom, theSelTo){
		var selLength = theSelFrom.length;
		selectedText = new Array();
		selectedValues = new Array();
		var selectedCount = 0;

		var i;
	
		// Find the selected Options in reverse order
		// and delete them from the 'from' Select.
		for(i=selLength-1; i>=0; i--)	{
			if(theSelFrom.options[i].selected){
				selectedText[selectedCount] = theSelFrom.options[i].text;
				selectedValues[selectedCount] = theSelFrom.options[i].value;
				deleteOption(theSelFrom, i);
				selectedCount++;
			}
		}
	
		// Add the selected text/values in reverse order.
		// This will add the Options to the 'to' Select
		// in the same order as they were in the 'from' Select.
		for(i=selectedCount-1; i>=0; i--){
			addOption(theSelTo, selectedText[i], selectedValues[i]);
		}
	}

</script>
<title>user</title>
<html:form action="/User.do" >
	<input type="hidden" name="method" value="<c:out value="${action}"/>">
	<h3>User</h3>
	<table>
		<tr>
			<td>Login</td>
			<td><html:text property="login" value="${generalForm.map.login}" /></td>
			<html:hidden property="oldLogin" value="${generalForm.map.oldLogin}" />
			<html:hidden property="userPrincipalsNames" value="" />
		</tr>
		<tr>
			<td>Password</td>
			<td><html:text property="password" value="${generalForm.map.password}" /></td>
		</tr>
		<tr>
			<td>Firstname</td>
			<td><html:text property="firstname" value="${generalForm.map.firstname}" /></td>
		</tr>
		<tr>
			<td>Lastname</td>
			<td><html:text property="lastname" value="${generalForm.map.lastname}" /></td>
		</tr>
		<tr>
			<td>Location</td>
			<td><html:text property="location" value="${generalForm.map.location}" /></td>
		</tr>
		<tr>
			<td>Country</td>
			<td><html:text property="country" value="${generalForm.map.country}" /></td>
		</tr>
		<tr>
			<td>Religion</td>
			<td><html:text property="religion" value="${generalForm.map.religion}" /></td>
		</tr>
		<tr>
			<td>Hobbies</td>
			<td><html:text property="hobbies" value="${generalForm.map.hobbies}" /></td>
		</tr>
	</table>
	
	<div>
		<select id="userPrincipals" multiple="multiple" size="10">
			<option value="----" disabled="disabled"> - - principals owned by user - - </option>
			<c:forEach var="userPrincipal" items="${generalForm.map.principals}" varStatus="statusPrincipal">
				<option value="<c:out value="${userPrincipal.name}"/>"><c:out value="${userPrincipal.name}"/></option>
			</c:forEach>
		</select>

		<select id="principals" multiple="multiple" size="10">
			<option value="----" disabled="disabled">- - available principals - - </option>
			<c:forEach var="principal" items="${allPrincipals}" varStatus="statusPrincipal">
				<option value="<c:out value="${principal.name}"/>"><c:out value="${principal.name}"/></option>
			</c:forEach>
		</select>
	</div>	
	<div>
		<input type="button" value=" &lt; &lt; &lt; add" onclick="javascript:addPrincipal(this.form.principals, this.form.userPrincipals);" />
		<input type="button" value="remove &gt; &gt; &gt; " onclick="javascript:removePrincipal(this.form.userPrincipals, this.form.principals);" />
	</div>
	
	<input type="button" value="Save" onclick="javascript:save();"/>
</html:form>
