/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Builtins.Goals;

import ubc.cs.JLog.Builtins.Goals.jCallGoal;
import ubc.cs.JLog.Foundation.iGoalStack;
import ubc.cs.JLog.Foundation.jGoal;
import ubc.cs.JLog.Foundation.jPrologServiceThread;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Terms.jTerm;

public class jTimeGoal
extends jCallGoal {
    protected jReportTimeGoal report_time_goal = new jReportTimeGoal(this);

    public jTimeGoal(jTerm c) {
        super(c);
    }

    public boolean prove(iGoalStack goals, iGoalStack proved) {
        jGoal eg = goals.empty() ? null : goals.peek();
        this.report_time_goal.start_time = this.report_time_goal.last_time = System.currentTimeMillis();
        this.report_time_goal.total_time = 0L;
        goals.push(this.report_time_goal);
        super.prove(goals, proved);
        this.setEndGoal(eg);
        return true;
    }

    public String getName() {
        return "time";
    }

    public int getArity() {
        return 1;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.getName() + "/" + String.valueOf(this.getArity()) + " goal: ");
        sb.append(this.getName() + "(" + this.callee.toString() + ")");
        return sb.toString();
    }

    protected class jReportTimeGoal
    extends jGoal {
        public long start_time;
        public long last_time;
        public long total_time;
        protected jTimeGoal parent;

        public jReportTimeGoal(jTimeGoal p) {
            this.parent = p;
        }

        public boolean prove(iGoalStack goals, iGoalStack proved) {
            long current_time = System.currentTimeMillis();
            long elapsed_time = current_time - this.last_time;
            this.total_time += elapsed_time;
            Thread t = Thread.currentThread();
            if (t instanceof jPrologServiceThread) {
                jPrologServiceThread pst = (jPrologServiceThread)t;
                jPrologServices ps = pst.getPrologServices();
                pst.printOutput("Time (ms): " + Long.toString(elapsed_time) + " ");
                pst.printOutput("Total time (ms): " + Long.toString(this.total_time));
                pst.printOutput("\n");
            }
            proved.push(this);
            return true;
        }

        public boolean retry(iGoalStack goals, iGoalStack proved) {
            this.last_time = System.currentTimeMillis();
            goals.push(this);
            return false;
        }

        public String getName() {
            return "REPORT_TIME";
        }

        public int getArity() {
            return 0;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.getName() + "/" + String.valueOf(this.getArity()));
            return sb.toString();
        }
    }
}

