/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Builtins;

import ubc.cs.JLog.Builtins.Goals.jAssertGoal;
import ubc.cs.JLog.Builtins.InvalidAssertException;
import ubc.cs.JLog.Foundation.iGoalStack;
import ubc.cs.JLog.Foundation.jDynamicRuleDefinitions;
import ubc.cs.JLog.Foundation.jGoal;
import ubc.cs.JLog.Foundation.jKnowledgeBase;
import ubc.cs.JLog.Foundation.jRule;
import ubc.cs.JLog.Foundation.jRuleDefinitions;
import ubc.cs.JLog.Foundation.jVariableRegistry;
import ubc.cs.JLog.Terms.PredicateExpectedException;
import ubc.cs.JLog.Terms.jAtom;
import ubc.cs.JLog.Terms.jIf;
import ubc.cs.JLog.Terms.jPredicate;
import ubc.cs.JLog.Terms.jPredicateTerms;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jUnaryBuiltinPredicate;
import ubc.cs.JLog.Terms.jVariable;

public class jAssert
extends jUnaryBuiltinPredicate {
    public static final boolean FIRST = false;
    public static final boolean LAST = true;

    public jAssert(jTerm t) {
        super(t, 4);
    }

    public String getName() {
        return "assert";
    }

    public boolean prove(jAssertGoal ag, jKnowledgeBase kb) {
        jTerm t = ag.term.getTerm();
        if (t instanceof jIf) {
            jIf jif = (jIf)t;
            jTerm lhs = jif.getLHS().getTerm();
            jPredicate head = null;
            jPredicateTerms base = null;
            jVariableRegistry vars = new jVariableRegistry();
            if (!(lhs instanceof jPredicate)) {
                throw new InvalidAssertException("Expected single predicate before if operator in assert.");
            }
            head = (jPredicate)lhs;
            try {
                base = new jPredicateTerms();
                base.makePredicateTerms(jif.getRHS().getTerm());
            }
            catch (PredicateExpectedException e) {
                throw new InvalidAssertException("Expected predicates after if operator.");
            }
            return this.assertPredicate((jPredicate)head.copy(vars), (jPredicateTerms)base.copy(vars), kb, ag.addlast);
        }
        if (t instanceof jPredicate) {
            return this.assertPredicate((jPredicate)t.copy(), null, kb, ag.addlast);
        }
        if (t instanceof jAtom) {
            jPredicate tp = new jPredicate((jAtom)t);
            return this.assertPredicate(tp, null, kb, ag.addlast);
        }
        throw new InvalidAssertException("Asserted term cannot be builtin or unbound variable.");
    }

    protected boolean assertPredicate(jPredicate h, jPredicateTerms b, jKnowledgeBase kb, boolean addlast) {
        jRule rule = new jRule(h, b == null ? new jPredicateTerms() : b);
        jRuleDefinitions rds = h.getCachedRuleDefinitions();
        if (rds == null) {
            rds = kb.getRuleDefinitionsMatch(rule);
        }
        if (rds == null) {
            kb.makeRuleDefinitionDynamic(rule);
            if (addlast) {
                kb.addRuleLast(rule);
            } else {
                kb.addRuleFirst(rule);
            }
        } else if (rds instanceof jDynamicRuleDefinitions) {
            if (addlast) {
                rds.addRuleLast(rule);
            } else {
                rds.addRuleFirst(rule);
            }
        } else {
            throw new InvalidAssertException("Asserted term '" + h.getName() + "/" + String.valueOf(h.getArity()) + "' must be dynamic.");
        }
        rule.consult(kb);
        return true;
    }

    public void addGoals(jGoal g, jVariable[] vars, iGoalStack goals) {
        goals.push(new jAssertGoal(this, this.rhs.duplicate(vars), true));
    }

    public void addGoals(jGoal g, iGoalStack goals) {
        goals.push(new jAssertGoal(this, this.rhs, true));
    }

    protected jUnaryBuiltinPredicate duplicate(jTerm r) {
        return new jAssert(r);
    }
}

