/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Foundation;

import java.util.EmptyStackException;
import java.util.Vector;
import ubc.cs.JLog.Foundation.DebugStackException;
import ubc.cs.JLog.Foundation.iGoalStack;
import ubc.cs.JLog.Foundation.jDebugFailGoalEvent;
import ubc.cs.JLog.Foundation.jDebugGoalStack;
import ubc.cs.JLog.Foundation.jDebugProveGoalEvent;
import ubc.cs.JLog.Foundation.jDebugProvedGoalStack;
import ubc.cs.JLog.Foundation.jDebugProvedGoalsEvent;
import ubc.cs.JLog.Foundation.jDebugProverGoalStackEvent;
import ubc.cs.JLog.Foundation.jDebugProverStartedEvent;
import ubc.cs.JLog.Foundation.jDebugRetryGoalEvent;
import ubc.cs.JLog.Foundation.jDebugTryGoalEvent;
import ubc.cs.JLog.Foundation.jGoal;
import ubc.cs.JLog.Foundation.jKnowledgeBase;
import ubc.cs.JLog.Foundation.jPrologServiceBroadcaster;
import ubc.cs.JLog.Foundation.jProver;
import ubc.cs.JLog.Terms.jPredicateTerms;

public class jDebugProver
extends jProver {
    protected jPrologServiceBroadcaster debugmessages;
    protected boolean step;

    public jDebugProver(jKnowledgeBase kb, jPrologServiceBroadcaster debugm) {
        super(kb);
        this.debugmessages = debugm;
        this.debugmessages.broadcastEvent(new jDebugProverStartedEvent(this));
    }

    public boolean prove(jPredicateTerms goal) {
        this.step = false;
        return super.prove(goal);
    }

    public synchronized void step() {
        this.step = true;
        this.notify();
    }

    protected synchronized void waitForSingleStep() {
        while (!this.step) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        this.step = false;
    }

    protected boolean internal_prove() {
        try {
            while (!this.goals.empty()) {
                jDebugProvedGoalStack.jDebugGoalItem item;
                jGoal tryg = this.goals.pop();
                jGoal nextg = ((jDebugGoalStack)this.goals).peekTopGoal();
                this.debugmessages.broadcastEvent(new jDebugTryGoalEvent(tryg, nextg));
                this.waitForSingleStep();
                if (!tryg.prove(this.goals, this.proved)) {
                    jGoal retryg;
                    this.debugmessages.broadcastEvent(new jDebugFailGoalEvent(tryg));
                    do {
                        retryg = this.proved.pop();
                        this.debugmessages.broadcastEvent(new jDebugRetryGoalEvent(retryg));
                    } while (!retryg.retry(this.goals, this.proved));
                    continue;
                }
                Vector sub_goals = ((jDebugGoalStack)this.goals).getTopGoals(nextg);
                try {
                    item = ((jDebugProvedGoalStack)this.proved).getDebugItem(tryg);
                }
                catch (DebugStackException e) {
                    item = ((jDebugProvedGoalStack)this.proved).peekDebugItem();
                }
                item.setNextGoal(nextg);
                item.setSubGoals(sub_goals);
                this.debugmessages.broadcastEvent(new jDebugProveGoalEvent(tryg, sub_goals));
                jGoal topg = ((jDebugGoalStack)this.goals).peekTopGoal();
                Vector proved_goals = ((jDebugProvedGoalStack)this.proved).getProvedDebugItems(topg);
                this.debugmessages.broadcastEvent(new jDebugProvedGoalsEvent(proved_goals));
            }
            return true;
        }
        catch (EmptyStackException e) {
            return false;
        }
    }

    protected boolean internal_retry() {
        while (!this.proved.empty()) {
            jGoal retryg = this.proved.pop();
            this.debugmessages.broadcastEvent(new jDebugRetryGoalEvent(retryg));
            if (!retryg.retry(this.goals, this.proved)) continue;
            return true;
        }
        return false;
    }

    protected iGoalStack createGoalsStack() {
        jDebugGoalStack gs = new jDebugGoalStack();
        this.debugmessages.broadcastEvent(new jDebugProverGoalStackEvent(this, gs, false));
        return gs;
    }

    protected iGoalStack createProvedStack() {
        jDebugProvedGoalStack gs = new jDebugProvedGoalStack();
        this.debugmessages.broadcastEvent(new jDebugProverGoalStackEvent(this, gs, true));
        return gs;
    }
}

