/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Foundation;

import java.io.PrintWriter;
import ubc.cs.JLog.Foundation.InvalidInputException;
import ubc.cs.JLog.Foundation.iPrologServiceText;
import ubc.cs.JLog.Foundation.jDebugProver;
import ubc.cs.JLog.Foundation.jPrologServiceBroadcaster;
import ubc.cs.JLog.Foundation.jPrologServiceEvent;
import ubc.cs.JLog.Foundation.jPrologServices;
import ubc.cs.JLog.Foundation.jProver;
import ubc.cs.JLog.Foundation.jRetryQueryThread;
import ubc.cs.JLog.Foundation.jUserQueryEvent;
import ubc.cs.JLog.Foundation.jVariableVector;
import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.TokenizeStreamException;
import ubc.cs.JLog.Parser.pParseStream;
import ubc.cs.JLog.Terms.jPredicateTerms;
import ubc.cs.JLog.Terms.jVariable;

public class jUserQueryThread
extends jRetryQueryThread {
    protected iPrologServiceText qinput;
    protected PrintWriter output;
    protected jPrologServiceBroadcaster beginq = null;
    protected jPrologServiceBroadcaster retryq = null;
    protected jPrologServiceBroadcaster endq = null;
    protected jPrologServiceBroadcaster debugm = null;
    protected jProver prover = null;
    protected jPredicateTerms query = null;
    protected boolean result = false;
    protected int retry = 0;
    protected jVariableVector var_vector = null;

    public jUserQueryThread(jPrologServices ps, iPrologServiceText qin, PrintWriter o) {
        super(ps);
        this.setName("UserQueryThread");
        this.qinput = qin;
        this.output = o;
    }

    public void setListeners(jPrologServiceBroadcaster b, jPrologServiceBroadcaster r, jPrologServiceBroadcaster e, jPrologServiceBroadcaster s, jPrologServiceBroadcaster d) {
        this.setStoppedListeners(s);
        this.beginq = b;
        this.retryq = r;
        this.endq = e;
        this.debugm = d;
    }

    public synchronized void retry() {
        ++this.retry;
        this.notify();
    }

    protected synchronized boolean waitForRetry() {
        while (this.retry <= 0) {
            try {
                this.wait();
            }
            catch (InterruptedException e) {
                return false;
            }
        }
        --this.retry;
        return true;
    }

    public void run() {
        if (this.beginq != null) {
            this.beginq.broadcastEvent(new jPrologServiceEvent());
        }
        try {
            this.query();
            if (this.retryq != null) {
                this.retryq.broadcastEvent(new jUserQueryEvent(this.result));
            }
            while (this.result) {
                if (!this.waitForRetry()) continue;
                this.internal_retry();
                this.internal_display();
                if (this.retryq == null) continue;
                this.retryq.broadcastEvent(new jUserQueryEvent(this.result));
            }
        }
        catch (ThreadDeath e) {
            throw e;
        }
        catch (Error e) {
            this.output.println("JAVA ERROR:");
            this.output.println(e.toString() + "\n");
            this.output.flush();
            this.qinput.requestFocus();
            throw e;
        }
        finally {
            if (this.allow_release) {
                this.prolog.release();
            }
            this.var_vector = null;
            if (this.endq != null) {
                this.endq.broadcastEvent(new jPrologServiceEvent());
            }
        }
    }

    protected void query() {
        pParseStream parser = new pParseStream(this.qinput.getText(), this.prolog.getKnowledgeBase(), this.prolog.getPredicateRegistry(), this.prolog.getOperatorRegistry());
        try {
            this.result = false;
            this.query = parser.parseQuery();
            if (this.query != null) {
                this.var_vector = new jVariableVector();
                this.query.registerVariables(this.var_vector);
                this.output.println(this.query.toString(true));
                this.output.flush();
                this.internal_prove();
                this.internal_display();
            } else {
                this.output.println("empty query.");
                this.output.flush();
            }
        }
        catch (SyntaxErrorException e) {
            this.output.println("SYNTAX ERROR:");
            this.output.println(e.toString() + "\n");
            this.output.flush();
            this.qinput.setCaretPosition(e.getPosition());
            this.qinput.select(e.getPosition(), e.getPosition() + 1);
            this.qinput.requestFocus();
        }
        catch (TokenizeStreamException e) {
            this.output.println("INTERNAL ERROR:");
            this.output.println(e.toString() + "\n");
            this.output.flush();
            this.qinput.setCaretPosition(e.getPosition());
            this.qinput.select(e.getPosition(), e.getPosition() + 1);
            this.qinput.requestFocus();
        }
        catch (RuntimeException e) {
            this.output.println("ERROR:");
            this.output.println(e.toString() + "\n");
            this.output.flush();
            this.qinput.requestFocus();
        }
    }

    protected void internal_prove() {
        this.prover = this.prolog.getDebugging() ? new jDebugProver(this.prolog.getKnowledgeBase(), this.debugm) : new jProver(this.prolog.getKnowledgeBase());
        this.result = this.prover.prove(this.query);
    }

    protected void internal_retry() {
        if (this.result) {
            try {
                this.result = this.prover.retry();
            }
            catch (InvalidInputException e) {
                if (!e.isHandled()) {
                    this.output.println("ERROR:");
                    this.output.println(e.toString() + "\n");
                    this.output.flush();
                    this.qinput.requestFocus();
                }
                this.result = false;
            }
            catch (RuntimeException e) {
                this.output.println("ERROR:");
                this.output.println(e.toString() + "\n");
                this.output.flush();
                this.qinput.requestFocus();
                this.result = false;
            }
        }
    }

    protected void internal_display() {
        if (this.query == null) {
            return;
        }
        if (this.result) {
            jVariable[] vars = this.var_vector.getVariables();
            int max = vars.length;
            for (int i = 0; i < max; ++i) {
                if (!vars[i].isNamedForDisplay()) continue;
                this.output.println(vars[i].getName() + " = " + vars[i].toString(false));
            }
            this.output.println("yes");
        } else {
            this.output.println("no");
        }
        this.output.flush();
    }
}

