/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Parser;

import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.pToken;

class pInteger
extends pToken {
    protected int value;

    public pInteger(String s, int pos, int line, int cpos) {
        super(s, pos, line, cpos);
        try {
            this.value = Integer.valueOf(s);
        }
        catch (NumberFormatException e) {
            throw new SyntaxErrorException("Invalid integer number format at ", pos, line, cpos);
        }
    }

    public pInteger(String sb, String sn, int pos, int line, int cpos) {
        block7: {
            super(sb + "'" + sn, pos, line, cpos);
            try {
                int base = Integer.valueOf(sb);
                if (base == 0) {
                    if (sn.length() != 1) {
                        throw new SyntaxErrorException("Expected single character at ", pos + sb.length() + 1, line, cpos + sb.length() + 1);
                    }
                    this.value = sn.charAt(0);
                    break block7;
                }
                if (base >= 2 && base <= 36) {
                    this.value = 0;
                    int cnt = sn.length();
                    int multi = 1;
                    while (cnt >= 0) {
                        int result = Character.digit(sn.charAt(cnt), base);
                        if (result < 0) {
                            throw new SyntaxErrorException("Expected valid number character within radix at ", pos + sb.length() - cnt + 1, line, cpos + sb.length() - cnt + 1);
                        }
                        this.value += result * multi;
                        --cnt;
                        multi *= base;
                    }
                    break block7;
                }
                throw new SyntaxErrorException("Invalid radix range at ", pos, line, cpos);
            }
            catch (NumberFormatException e) {
                throw new SyntaxErrorException("Invalid integer number format at ", pos, line, cpos);
            }
        }
    }

    public int getValue() {
        return this.value;
    }
}

