/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Parser;

import java.io.Reader;
import java.util.Enumeration;
import java.util.Hashtable;
import ubc.cs.JLog.Foundation.jKnowledgeBase;
import ubc.cs.JLog.Foundation.jProver;
import ubc.cs.JLog.Foundation.jRule;
import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.pOperatorRegistry;
import ubc.cs.JLog.Parser.pPacket;
import ubc.cs.JLog.Parser.pPreParseStream;
import ubc.cs.JLog.Parser.pPredicateRegistry;
import ubc.cs.JLog.Parser.pTermToPacketHashtable;
import ubc.cs.JLog.Parser.pToken;
import ubc.cs.JLog.Parser.pUpdateDatabaseRules;
import ubc.cs.JLog.Parser.pVariableRegistry;
import ubc.cs.JLog.Terms.PredicateExpectedException;
import ubc.cs.JLog.Terms.jCommand;
import ubc.cs.JLog.Terms.jDCG;
import ubc.cs.JLog.Terms.jIf;
import ubc.cs.JLog.Terms.jPredicate;
import ubc.cs.JLog.Terms.jPredicateTerms;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jVariable;

public class pParseStream {
    protected pPreParseStream parser;
    protected jKnowledgeBase database;

    public pParseStream(String s, jKnowledgeBase kb, pPredicateRegistry pr, pOperatorRegistry or) {
        this.parser = new pPreParseStream(s, pr, or);
        this.database = kb;
    }

    public pParseStream(Reader r, jKnowledgeBase kb, pPredicateRegistry pr, pOperatorRegistry or) {
        this.parser = new pPreParseStream(r, pr, or);
        this.database = kb;
    }

    public jPredicateTerms parseQuery() {
        return this.parseQuery(null);
    }

    public jPredicateTerms parseQuery(Hashtable assignments) {
        pPacket pp = this.parser.parse();
        if (pp != null) {
            jPredicateTerms base;
            pVariableRegistry vars = new pVariableRegistry();
            pTermToPacketHashtable phash = new pTermToPacketHashtable();
            if (assignments != null) {
                Enumeration e = assignments.keys();
                while (e.hasMoreElements()) {
                    String s = (String)e.nextElement();
                    jTerm t = (jTerm)assignments.get(s);
                    jVariable v = vars.getVariable(s);
                    v.setBinding(t);
                }
            }
            pp.setGeneric(false);
            jTerm term = pp.getTerm(vars, phash);
            if (term instanceof jCommand) {
                term = ((jCommand)term).getRHS();
            }
            try {
                base = new jPredicateTerms();
                base.makePredicateTerms(term);
            }
            catch (PredicateExpectedException e) {
                pToken pt = phash.getToken(e.getTerm(), pp);
                throw new SyntaxErrorException("Expected predicate at ", pt.getPosition(), pt.getLine(), pt.getCharPos());
            }
            return base;
        }
        return null;
    }

    public jTerm parseTerm() {
        pPacket pp = this.parser.parse();
        if (pp != null) {
            pVariableRegistry vars = new pVariableRegistry();
            pTermToPacketHashtable phash = new pTermToPacketHashtable();
            pp.setGeneric(false);
            jTerm term = pp.getTerm(vars, phash);
            if (term instanceof jCommand) {
                term = ((jCommand)term).getRHS();
            }
            return term;
        }
        return null;
    }

    public void parseSource() {
        pPacket pp;
        pUpdateDatabaseRules dhash = new pUpdateDatabaseRules(this.database);
        while ((pp = this.parser.parse()) != null) {
            jPredicateTerms base;
            jPredicate head;
            pVariableRegistry vars = new pVariableRegistry();
            pTermToPacketHashtable phash = new pTermToPacketHashtable();
            pp.setGeneric(true);
            jTerm term = pp.getTerm(vars, phash);
            if (term instanceof jIf) {
                jIf jif = (jIf)term;
                jTerm lhs = jif.getLHS();
                if (!(lhs instanceof jPredicate)) {
                    pToken pt = phash.getToken(term, pp);
                    throw new SyntaxErrorException("Expected single predicate before if operator at ", pt.getPosition(), pt.getLine(), pt.getCharPos());
                }
                head = (jPredicate)lhs;
                try {
                    base = new jPredicateTerms();
                    base.makePredicateTerms(jif.getRHS());
                }
                catch (PredicateExpectedException e) {
                    pToken pt = phash.getToken(e.getTerm(), pp);
                    throw new SyntaxErrorException("Expected predicate at ", pt.getPosition(), pt.getLine(), pt.getCharPos());
                }
                dhash.addRule(new jRule(head, base));
                continue;
            }
            if (term instanceof jCommand) {
                jCommand command = (jCommand)term;
                try {
                    base = new jPredicateTerms();
                    base.makePredicateTerms(command.getRHS());
                }
                catch (PredicateExpectedException e) {
                    pToken pt = phash.getToken(e.getTerm(), pp);
                    throw new SyntaxErrorException("Expected predicate at ", pt.getPosition(), pt.getLine(), pt.getCharPos());
                }
                this.query(base);
                continue;
            }
            if (term instanceof jDCG) {
                jDCG dcg = (jDCG)term;
                try {
                    dhash.addRule(dcg.makeDCGRule());
                    continue;
                }
                catch (PredicateExpectedException e) {
                    pToken pt = phash.getToken(e.getTerm(), pp);
                    throw new SyntaxErrorException("Expected predicate at ", pt.getPosition(), pt.getLine(), pt.getCharPos());
                }
            }
            if (term instanceof jPredicate) {
                head = (jPredicate)term;
                base = new jPredicateTerms();
                dhash.addRule(new jRule(head, base));
                continue;
            }
            pToken pt = phash.getToken(term, pp);
            throw new SyntaxErrorException("Expected predicate or rule at ", pt.getPosition(), pt.getLine(), pt.getCharPos());
        }
    }

    protected void query(jPredicateTerms q) {
        jProver prover = new jProver(this.database);
        prover.prove(q);
    }
}

