/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Parser;

import java.io.IOException;
import java.io.Reader;
import java.util.Stack;
import ubc.cs.JLog.Parser.SyntaxErrorException;
import ubc.cs.JLog.Parser.TokenizeStreamException;
import ubc.cs.JLog.Parser.pPreToken;
import ubc.cs.JLog.Parser.pTokenizerTable;

class pPreTokenizeStream {
    protected Reader reader;
    protected Stack pushback;
    protected Stack previous_tables;
    protected pTokenizerTable current_table;
    protected int currentPosition = 0;
    protected boolean read_pushedback = false;
    protected int read_pushback;
    public static final int TOKEN_EOF = -1;

    public pPreTokenizeStream(Reader r) {
        this.reader = r;
        this.current_table = null;
        this.previous_tables = new Stack();
        this.pushback = new Stack();
    }

    public void useTokenizerTable(pTokenizerTable t) {
        if (this.current_table != null) {
            this.previous_tables.push(this.current_table);
        }
        this.current_table = t;
    }

    public pTokenizerTable popTokenizerTable() {
        pTokenizerTable t = this.current_table;
        if (this.previous_tables.empty()) {
            return null;
        }
        this.current_table = (pTokenizerTable)this.previous_tables.pop();
        return t;
    }

    public void pushBackToken(pPreToken p) {
        this.pushback.push(p);
    }

    public pPreToken getNextToken() {
        boolean collectall;
        if (!this.pushback.empty()) {
            return (pPreToken)this.pushback.pop();
        }
        int startpos = this.currentPosition;
        if (this.current_table == null) {
            throw new TokenizeStreamException("There is no Tokenizing Table");
        }
        int[] table = this.current_table.getTokenTable();
        int c = this.read();
        if (c < 0) {
            return new pPreToken(-1, startpos);
        }
        if (c >= table.length || table[c] == 0) {
            throw new SyntaxErrorException("Unknown character at position ", startpos);
        }
        StringBuffer sb = new StringBuffer();
        sb.append((char)c);
        pPreToken pt = new pPreToken(table[c], startpos);
        boolean bl = collectall = pt.getType() < 65280;
        while (collectall) {
            c = this.read();
            if (c < 0 || c >= table.length || table[c] != pt.getType()) {
                this.pushbackRead(c);
                break;
            }
            sb.append((char)c);
        }
        pt.setToken(sb.toString());
        return pt;
    }

    protected int read() {
        ++this.currentPosition;
        if (this.read_pushedback) {
            this.read_pushedback = false;
            return this.read_pushback;
        }
        try {
            return this.reader.read();
        }
        catch (IOException e) {
            throw new TokenizeStreamException("IO error occurred while reading at position ", this.currentPosition - 1, e);
        }
    }

    protected void pushbackRead(int c) {
        this.read_pushedback = true;
        this.read_pushback = c;
        --this.currentPosition;
    }
}

