/*
 * Decompiled with CFR 0.152.
 */
package ubc.cs.JLog.Terms;

import java.util.Enumeration;
import java.util.Vector;
import ubc.cs.JLog.Foundation.iGoalStack;
import ubc.cs.JLog.Foundation.jGoal;
import ubc.cs.JLog.Foundation.jRule;
import ubc.cs.JLog.Terms.Goals.jFailGoal;
import ubc.cs.JLog.Terms.InvalidDCGFormException;
import ubc.cs.JLog.Terms.iList;
import ubc.cs.JLog.Terms.iPredicate;
import ubc.cs.JLog.Terms.jAtom;
import ubc.cs.JLog.Terms.jBinaryBuiltinPredicate;
import ubc.cs.JLog.Terms.jCompoundTerm;
import ubc.cs.JLog.Terms.jCons;
import ubc.cs.JLog.Terms.jIf;
import ubc.cs.JLog.Terms.jListPair;
import ubc.cs.JLog.Terms.jNullList;
import ubc.cs.JLog.Terms.jOr;
import ubc.cs.JLog.Terms.jPredicate;
import ubc.cs.JLog.Terms.jPredicateTerms;
import ubc.cs.JLog.Terms.jTerm;
import ubc.cs.JLog.Terms.jUnify;
import ubc.cs.JLog.Terms.jVariable;

public class jDCG
extends jBinaryBuiltinPredicate {
    public jDCG(jTerm l, jTerm r) {
        super(l, r, 4);
    }

    public jDCG(jTerm r) {
        super(null, r, 4);
    }

    public String getName() {
        return "-->";
    }

    public jRule makeDCGRule() {
        jPredicateTerms base = new jPredicateTerms();
        jVariable firstv = new jVariable("S0");
        jVariable lastv = new jVariable("S");
        jPredicate head = this.makeDCGHead(firstv, lastv);
        if (this.rhs != null) {
            base.makePredicateTerms(this.makeDCGBase(firstv, lastv));
        }
        return new jRule(head, base);
    }

    public jTerm makeDCGTerm(jTerm S, jTerm E) {
        jTerm t = this.makeDCGBase(S, E);
        if (this.lhs != null) {
            return new jIf(this.makeDCGHead(S, E), t);
        }
        return t;
    }

    public jTerm makeDCGTerm() {
        return this.makeDCGTerm(new jVariable("S0"), new jVariable("S"));
    }

    protected jTerm makeDCGBase(jTerm S0, jTerm SN) {
        Vector predicate_registry = new Vector();
        jTerm t = this.makeDCGBaseTerm(this.rhs, predicate_registry);
        this.updateDCGPredicateRegistry(predicate_registry, S0, SN, new dcgVariableGenerator());
        return t;
    }

    protected jTerm makeDCGBaseTerm(jTerm r, Vector pr) {
        jCompoundTerm terms = new jCompoundTerm();
        this.makeDCGBaseCompoundTerm(r, terms, pr);
        jTerm dcg_term = terms.unmakeCompoundTerm();
        if (dcg_term == null) {
            throw new InvalidDCGFormException("Expected term on RHS.", this);
        }
        return dcg_term;
    }

    protected void updateDCGPredicateRegistry(Vector pr, jTerm S, jTerm E, dcgVariableGenerator g) {
        int max = pr.size();
        jTerm v = S;
        for (int i = 0; i < max; ++i) {
            jTerm next = i < max - 1 ? g.createVariable() : E;
            Object o = pr.elementAt(i);
            if (o instanceof dcgNotFork) {
                dcgNotFork nf = (dcgNotFork)o;
                this.updateDCGPredicateRegistry(nf.lhs, v, g.createVariable(), g);
                nf.unify.updatePredicate(v, next);
            } else if (o instanceof dcgFork) {
                dcgFork f = (dcgFork)o;
                this.updateDCGPredicateRegistry(f.lhs, v, next, g);
                this.updateDCGPredicateRegistry(f.rhs, v, next, g);
            } else {
                iPredicateUpdate up = (iPredicateUpdate)o;
                up.updatePredicate(v, next);
            }
            v = next;
        }
    }

    protected void makeDCGBaseCompoundTerm(jTerm r, jCompoundTerm terms, Vector pr) {
        jTerm rt = r.getTerm();
        if (rt instanceof jListPair) {
            this.makeDCGConsList((jListPair)rt, terms, pr);
        } else if (rt instanceof jVariable) {
            terms.addTerm(this.makeDCGPhrase((jVariable)rt, pr));
        } else if (rt instanceof jCons) {
            jCons cons_rt = (jCons)rt;
            jCompoundTerm ct = new jCompoundTerm();
            this.makeDCGBaseCompoundTerm(cons_rt.getLHS(), ct, pr);
            Enumeration e = ct.enumTerms();
            while (e.hasMoreElements()) {
                terms.addTerm((jTerm)e.nextElement());
            }
            ct = new jCompoundTerm();
            this.makeDCGBaseCompoundTerm(cons_rt.getRHS(), ct, pr);
            e = ct.enumTerms();
            while (e.hasMoreElements()) {
                terms.addTerm((jTerm)e.nextElement());
            }
        } else if (rt instanceof jOr) {
            jOr or_rt = (jOr)rt;
            Vector lv = new Vector();
            Vector rv = new Vector();
            terms.addTerm(new jOr(this.makeDCGBaseTerm(or_rt.getLHS(), lv), this.makeDCGBaseTerm(or_rt.getRHS(), rv)));
            this.addDCGFork(pr, lv, rv);
        } else if (rt instanceof jPredicate) {
            jPredicate pt = (jPredicate)rt;
            if (pt.getName().equals("not")) {
                jCompoundTerm ct = new jCompoundTerm();
                Vector lv = new Vector();
                Enumeration e = pt.getArguments().enumTerms();
                while (e.hasMoreElements()) {
                    ct.addTerm(this.makeDCGBaseTerm((jTerm)e.nextElement(), lv));
                }
                terms.addTerm(new jPredicate(pt.getName(), ct));
                jUnify un = new jUnify();
                terms.addTerm(un);
                pr.addElement(new dcgNotFork(lv, new dcgUnifyPredicateUpdate(un)));
            } else if (pt.getName().equals("{}")) {
                Enumeration e = pt.getArguments().enumTerms();
                while (e.hasMoreElements()) {
                    terms.addTerm((jTerm)e.nextElement());
                }
            } else if (pt.getName().equals("->") && pt.getArity() == 2) {
                jCompoundTerm ct = new jCompoundTerm();
                ct.addTerm(this.makeDCGBaseTerm(pt.getArguments().elementAt(0), pr));
                ct.addTerm(this.makeDCGBaseTerm(pt.getArguments().elementAt(1), pr));
                terms.addTerm(new jPredicate(pt.getName(), ct));
            } else if (pt.getName().equals("->") && pt.getArity() == 3) {
                jCompoundTerm ct = new jCompoundTerm();
                Vector lv = new Vector();
                Vector rv = new Vector();
                ct.addTerm(this.makeDCGBaseTerm(pt.getArguments().elementAt(0), lv));
                ct.addTerm(this.makeDCGBaseTerm(pt.getArguments().elementAt(1), lv));
                ct.addTerm(this.makeDCGBaseTerm(pt.getArguments().elementAt(2), rv));
                terms.addTerm(new jPredicate(pt.getName(), ct));
                this.addDCGFork(pr, lv, rv);
            } else {
                jPredicate p = new jPredicate(pt.getName(), this.makeCompoundTerm(pt.getArguments()));
                terms.addTerm(p);
                pr.addElement(new dcgPredicateUpdate(p));
            }
        } else if (rt instanceof jAtom) {
            jPredicate pa = new jPredicate(rt.getName(), new jCompoundTerm());
            terms.addTerm(pa);
            pr.addElement(new dcgPredicateUpdate(pa));
        } else if (rt instanceof iPredicate) {
            iPredicate ip = (iPredicate)rt;
            jPredicate p = new jPredicate(ip.getName(), this.makeCompoundTerm(ip.getArguments()));
            terms.addTerm(p);
            pr.addElement(new dcgPredicateUpdate(p));
        } else {
            terms.addTerm(rt);
        }
    }

    protected void makeDCGConsList(jListPair src, jCompoundTerm terms, Vector pr) {
        jTerm l = src;
        while (l instanceof jListPair) {
            terms.addTerm(this.makeDCGTERMINAL(l.getHead(), pr));
            l = l.getTail().getTerm();
        }
        if (l != null && !(l instanceof jNullList)) {
            terms.addTerm(this.makeDCGTERMINAL(l, pr));
        }
    }

    protected jPredicate makeDCGTERMINAL(jTerm t, Vector pr) {
        jPredicate p = new jPredicate("DCGTERMINAL", new jCompoundTerm());
        pr.addElement(new dcgTerminalPredicateUpdate(p, t));
        return p;
    }

    protected jPredicate makeDCGPhrase(jVariable v, Vector pr) {
        jCompoundTerm ct = new jCompoundTerm();
        ct.addTerm(v);
        jPredicate p = new jPredicate("phrase", ct);
        pr.addElement(new dcgPredicateUpdate(p));
        return p;
    }

    protected void addDCGFork(Vector pr, Vector l, Vector r) {
        Vector merge = null;
        if (l.size() > 0 && r.size() > 0) {
            pr.addElement(new dcgFork(l, r));
        } else if (l.size() > 0) {
            merge = l;
        } else if (r.size() > 0) {
            merge = r;
        }
        if (merge != null) {
            Enumeration e = merge.elements();
            while (e.hasMoreElements()) {
                pr.addElement(e.nextElement());
            }
        }
    }

    protected jCompoundTerm makeCompoundTerm(jCompoundTerm t) {
        jCompoundTerm ct = new jCompoundTerm();
        Enumeration e = t.enumTerms();
        while (e.hasMoreElements()) {
            ct.addTerm((jTerm)e.nextElement());
        }
        return ct;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected jPredicate makeDCGHead(jTerm S0, jTerm SN) {
        jPredicate h;
        jTerm lt = this.lhs.getTerm();
        jListPair l = null;
        if (lt instanceof jPredicate) {
            h = (jPredicate)lt;
        } else {
            if (!(lt instanceof jCons)) throw new InvalidDCGFormException("Expected predicate or predicate,list on LHS.", this);
            jCons c = (jCons)lt;
            if (!(c.getLHS().getTerm() instanceof jPredicate) || !(c.getRHS().getTerm() instanceof iList)) throw new InvalidDCGFormException("Expected predicate,list on LHS.", this);
            h = (jPredicate)c.getLHS().getTerm();
            l = c.getRHS().getTerm() instanceof jListPair ? (jListPair)c.getRHS().getTerm() : null;
        }
        jTerm t3 = l != null ? this.adjustTerminalList(l, SN) : SN;
        return this.adjustPredicate(h, S0, t3);
    }

    protected jListPair adjustTerminalList(jListPair src, jTerm SN) {
        jListPair head;
        jListPair l = head = new jListPair(src.getHead(), null);
        jTerm curr = src.getTail();
        while (curr instanceof jListPair) {
            jListPair oldl = l;
            l = new jListPair(((jListPair)curr).getHead(), null);
            oldl.setTail(l);
            curr = ((jListPair)curr).getTail();
        }
        if (curr instanceof jNullList) {
            l.setTail(SN);
        } else {
            l.setTail(new jListPair(curr, SN));
        }
        return head;
    }

    protected jPredicate adjustPredicate(jPredicate src, jTerm t2, jTerm t3) {
        jCompoundTerm ct = new jCompoundTerm(src.getArguments().size() + 2);
        Enumeration e = src.getArguments().enumTerms();
        while (e.hasMoreElements()) {
            ct.addTerm((jTerm)e.nextElement());
        }
        ct.addTerm(t2);
        ct.addTerm(t3);
        return new jPredicate(src.getName(), ct);
    }

    public void addGoals(jGoal g, jVariable[] vars, iGoalStack goals) {
        goals.push(new jFailGoal());
    }

    public void addGoals(jGoal g, iGoalStack goals) {
        goals.push(new jFailGoal());
    }

    public jBinaryBuiltinPredicate duplicate(jTerm l, jTerm r) {
        return new jDCG(l, r);
    }

    public String toString(boolean usename) {
        return this.lhs.toString(usename) + " " + this.getName() + " " + this.rhs.toString(usename);
    }

    protected class dcgVariableGenerator {
        protected int num = 1;

        public jVariable createVariable() {
            return new jVariable("S" + String.valueOf(this.num++));
        }
    }

    protected class dcgUnifyPredicateUpdate
    implements iPredicateUpdate {
        public jUnify pred;

        public dcgUnifyPredicateUpdate(jUnify p) {
            this.pred = p;
        }

        public void updatePredicate(jTerm S, jTerm E) {
            this.pred.setLHS(S);
            this.pred.setRHS(E);
        }
    }

    protected class dcgTerminalPredicateUpdate
    extends dcgPredicateUpdate {
        public jTerm term;

        public dcgTerminalPredicateUpdate(jPredicate p, jTerm t) {
            super(p);
            this.term = t;
        }

        public void updatePredicate(jTerm S, jTerm E) {
            this.pred.addTerm(S);
            this.pred.addTerm(this.term);
            this.pred.addTerm(E);
        }
    }

    protected class dcgPredicateUpdate
    implements iPredicateUpdate {
        public jPredicate pred;

        public dcgPredicateUpdate(jPredicate p) {
            this.pred = p;
        }

        public void updatePredicate(jTerm S, jTerm E) {
            this.pred.addTerm(S);
            this.pred.addTerm(E);
        }
    }

    protected static interface iPredicateUpdate {
        public void updatePredicate(jTerm var1, jTerm var2);
    }

    protected class dcgNotFork {
        public Vector lhs;
        public dcgUnifyPredicateUpdate unify;

        public dcgNotFork(Vector l, dcgUnifyPredicateUpdate u) {
            this.lhs = l;
            this.unify = u;
        }
    }

    protected class dcgFork {
        public Vector lhs;
        public Vector rhs;

        public dcgFork(Vector l, Vector r) {
            this.lhs = l;
            this.rhs = r;
        }
    }
}

