/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmpi.main;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import net.sf.jmpi.main.MpConstraint;
import net.sf.jmpi.main.MpDirection;
import net.sf.jmpi.main.MpOperator;
import net.sf.jmpi.main.MpVariable;
import net.sf.jmpi.main.MpVariables;
import net.sf.jmpi.main.expression.MpExpr;

public class MpProblem
implements MpVariables {
    protected final List<MpConstraint> constraints = new ArrayList<MpConstraint>();
    protected final HashMap<Object, MpVariable> variables = new LinkedHashMap<Object, MpVariable>();
    protected MpExpr objective = null;
    protected MpDirection optType = MpDirection.UNDEFINED;

    public MpConstraint add(MpExpr lhs, MpOperator operator, Number rhs) {
        return this.add(lhs, operator, MpExpr.sum(rhs));
    }

    public MpConstraint add(Number lhs, MpOperator operator, MpExpr rhs) {
        return this.add(MpExpr.sum(rhs), operator, rhs);
    }

    public MpConstraint add(MpExpr lhs, String operator, MpExpr rhs) {
        return this.add(lhs, MpOperator.get(operator), rhs);
    }

    public MpConstraint add(MpExpr lhs, String operator, Number rhs) {
        return this.add(lhs, MpOperator.get(operator), rhs);
    }

    public MpConstraint add(Number lhs, String operator, MpExpr rhs) {
        return this.add(lhs, MpOperator.get(operator), rhs);
    }

    public MpVariable addVar(Object variable, Class<?> type) {
        return this.addVar(-1.7976931348623157E308, variable, Double.MAX_VALUE, type);
    }

    public MpVariable addVar(Number lower, Object variable, Class<?> type) {
        return this.addVar(lower, variable, Double.MAX_VALUE, type);
    }

    public MpVariable addVar(Object variable, Number upper, Class<?> type) {
        return this.addVar(-1.7976931348623157E308, variable, upper, type);
    }

    public MpConstraint add(MpExpr lhs, MpOperator operator, MpExpr rhs) {
        MpConstraint constraint = new MpConstraint(lhs, operator, rhs);
        this.addConstraint(constraint);
        return constraint;
    }

    public MpVariable addVar(Number lower, Object var, Number upper, Class<?> type) {
        MpVariable variable = new MpVariable(var, lower, upper, MpVariable.Type.get(type));
        this.addVariable(variable);
        return variable;
    }

    public MpConstraint add(MpConstraint constraint) {
        this.addConstraint(constraint);
        return constraint;
    }

    public MpVariable add(MpVariable variable) {
        this.addVariable(variable);
        return variable;
    }

    public void add(MpProblem problem) {
        for (MpVariable variable : problem.getVariables()) {
            this.addVariable(variable);
        }
        for (MpConstraint constraint : problem.getConstraints()) {
            this.addConstraint(constraint);
        }
        if (problem.getObjective() != null) {
            this.setObjective(problem.getObjective(), problem.getOptType());
        }
    }

    public void setObjective(MpExpr expression, MpDirection type) {
        this.objective = expression;
        this.optType = type;
    }

    public void addConstraint(MpConstraint constraint) {
        this.constraints.add(constraint);
    }

    public void addVariable(MpVariable variable) {
        this.variables.put(variable.getVar(), variable);
    }

    public Collection<MpConstraint> getConstraints() {
        return this.constraints;
    }

    public int getConstraintsCount() {
        return this.constraints.size();
    }

    public Collection<MpVariable> getVariables() {
        return this.variables.values();
    }

    public int getVariablesCount() {
        return this.variables.size();
    }

    public MpExpr getObjective() {
        return this.objective;
    }

    public MpDirection getOptType() {
        return this.optType;
    }

    public String toString() {
        String s = "";
        if (this.objective != null) {
            s = s + (Object)((Object)this.optType) + ":" + this.objective + "\n";
        }
        for (MpConstraint constraint : this.constraints) {
            s = s + "constraint: " + constraint + "\n";
        }
        for (MpVariable variable : this.variables.values()) {
            s = s + "variable: " + variable + "\n";
        }
        return s;
    }

    @Override
    public MpVariable getVariable(Object variable) {
        return this.variables.get(variable);
    }

    public MpVariable.Type getVariableType(Object variable) {
        return this.getVariable(variable).getType();
    }
}

