/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmpi.main;

public class MpVariable {
    protected final Object var;
    protected final Number lower;
    protected final Number upper;
    protected final Type type;

    public MpVariable(Object var, Number lower, Number upper, Type type) {
        this.var = var;
        this.lower = lower;
        this.upper = upper;
        this.type = type;
    }

    public Object getVar() {
        return this.var;
    }

    public Number getLower() {
        return this.lower;
    }

    public Number getUpper() {
        return this.upper;
    }

    public Type getType() {
        return this.type;
    }

    public String toString() {
        String s = "";
        if (this.lower.doubleValue() > -1.7976931348623157E308) {
            s = s + this.lower + " <= ";
        }
        s = s + this.var;
        if (this.upper.doubleValue() < Double.MAX_VALUE) {
            s = s + " <= " + this.upper;
        }
        return s + " : " + (Object)((Object)this.type);
    }

    public static enum Type {
        BOOL,
        INT,
        REAL;


        public boolean isInt() {
            switch (this) {
                case BOOL: 
                case INT: {
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            switch (this) {
                case BOOL: {
                    return "binary";
                }
                case INT: {
                    return "integer";
                }
            }
            return "continuous";
        }

        public static Type get(Class<?> type) {
            if (type.equals(Integer.class)) {
                return INT;
            }
            if (type.equals(Boolean.class)) {
                return BOOL;
            }
            if (type.equals(Double.class)) {
                return REAL;
            }
            throw new IllegalArgumentException();
        }
    }
}

