/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmpi.main.expression;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.jmpi.main.expression.MpExprTerm;
import net.sf.jmpi.main.expression.MpExprType;

public class MpExpr
implements Iterable<MpExprTerm> {
    List<MpExprTerm> terms = new ArrayList<MpExprTerm>();

    public void addTerm(MpExprTerm term) {
        this.terms.add(term);
    }

    protected List<MpExprTerm> mulTerm(List<MpExprTerm> terms, MpExprTerm term) {
        ArrayList<MpExprTerm> result = new ArrayList<MpExprTerm>();
        if (term.getCoeff().doubleValue() == 0.0) {
            return result;
        }
        for (MpExprTerm t : terms) {
            result.add(term.mul(t));
        }
        return result;
    }

    public MpExpr addTerm(Object ... objects) {
        double coeff = 1.0;
        ArrayList<Object> vars = new ArrayList<Object>();
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (object instanceof MpExpr) {
                throw new IllegalArgumentException("illegal argument " + object);
            }
            if (object instanceof Number) {
                coeff *= ((Number)object).doubleValue();
                continue;
            }
            vars.add(object);
        }
        if (coeff != 1.0 || !vars.isEmpty()) {
            Object[] array = new Object[vars.size()];
            for (int i = 0; i < vars.size(); ++i) {
                array[i] = vars.get(i);
            }
            this.addTerm(new MpExprTerm(coeff, array));
        }
        return this;
    }

    public MpExpr add(Object ... objects) {
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (object instanceof MpExpr) {
                for (MpExprTerm term : (MpExpr)object) {
                    this.addTerm(term);
                }
                continue;
            }
            if (object instanceof Number) {
                this.addTerm(new MpExprTerm((Number)object, new Object[0]));
                continue;
            }
            this.addTerm(new MpExprTerm(1, object));
        }
        return this;
    }

    public MpExpr mul(Object ... objects) {
        double coeff = 1.0;
        ArrayList<Object> vars = new ArrayList<Object>();
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (object instanceof MpExpr) {
                ArrayList<MpExprTerm> org = new ArrayList<MpExprTerm>(this.terms);
                this.terms.clear();
                for (MpExprTerm t0 : org) {
                    for (MpExprTerm t1 : (MpExpr)object) {
                        this.addTerm(t0.mul(t1));
                    }
                }
                continue;
            }
            if (object instanceof Number) {
                coeff *= ((Number)object).doubleValue();
                continue;
            }
            vars.add(object);
        }
        if (coeff != 1.0 || !vars.isEmpty()) {
            Object[] array = new Object[vars.size()];
            for (int i = 0; i < vars.size(); ++i) {
                array[i] = vars.get(i);
            }
            List<MpExprTerm> newTerms = this.mulTerm(new ArrayList<MpExprTerm>(this.terms), new MpExprTerm(coeff, array));
            this.terms = newTerms;
        }
        return this;
    }

    public static MpExpr sum(Object ... objects) {
        MpExpr e = new MpExpr();
        e.add(objects);
        return e;
    }

    public static MpExpr prod(Object ... objects) {
        MpExpr e = new MpExpr();
        e.add(1);
        e.mul(objects);
        return e;
    }

    public static Object var(Object o0, Object o1, Object ... objects) {
        ArrayList<Object> jointVar = new ArrayList<Object>();
        jointVar.add(o0);
        jointVar.add(o1);
        for (Object o : objects) {
            jointVar.add(o);
        }
        return jointVar;
    }

    protected static MpExpr[] interprete(Object ... objects) {
        MpExpr[] expr = new MpExpr[objects.length];
        for (int i = 0; i < objects.length; ++i) {
            Object object = objects[i];
            if (object instanceof MpExpr) {
                expr[i] = (MpExpr)object;
                continue;
            }
            if (!(object instanceof Number)) continue;
            expr[i] = MpExpr.sum(MpExpr.prod(object));
        }
        return expr;
    }

    @Override
    public Iterator<MpExprTerm> iterator() {
        return this.terms.iterator();
    }

    public int size() {
        return this.terms.size();
    }

    public String toString() {
        String s = "";
        for (int i = 0; i < this.terms.size(); ++i) {
            s = s + this.terms.get(i);
            if (i >= this.terms.size() - 1) continue;
            s = s + " + ";
        }
        return s;
    }

    public int getOrder() {
        int i = 0;
        for (MpExprTerm term : this) {
            i = Math.max(i, term.size());
        }
        return i;
    }

    public MpExprType type() {
        switch (this.getOrder()) {
            case 0: 
            case 1: {
                return MpExprType.LINEAR;
            }
            case 2: {
                return MpExprType.QUADRATIC;
            }
        }
        return MpExprType.MORE;
    }

    public static void main(String[] args) {
        MpExpr e = MpExpr.sum(1, MpExpr.prod(3, "x2"), 4, "x1");
        MpExpr e2 = MpExpr.sum(10, MpExpr.prod("x1"));
        System.out.println(MpExpr.prod(e, e2, 4.5));
    }
}

