/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmpi.main.expression;

import java.util.Arrays;

public class MpExprTerm {
    protected final Number coeff;
    protected final Object[] vars;

    public MpExprTerm(Number coeff, Object ... vars) {
        this.coeff = coeff;
        this.vars = vars;
    }

    public Number getCoeff() {
        return this.coeff;
    }

    public Object[] getVars() {
        return this.vars;
    }

    public int size() {
        return this.vars.length;
    }

    public Object var(int i) {
        return this.vars[i];
    }

    public MpExprTerm mul(Number number) {
        return new MpExprTerm(number.doubleValue() * this.coeff.doubleValue(), this.vars);
    }

    public MpExprTerm mul(Object object) {
        Object[] array = Arrays.copyOf(this.vars, this.vars.length + 1);
        array[this.vars.length] = object;
        return new MpExprTerm(this.coeff, array);
    }

    public MpExprTerm mul(MpExprTerm other) {
        int i;
        Object[] array = new Object[this.size() + other.size()];
        for (i = 0; i < this.size(); ++i) {
            array[i] = this.var(i);
        }
        for (i = 0; i < other.size(); ++i) {
            array[i + this.size()] = other.var(i);
        }
        double coeff = this.getCoeff().doubleValue() * other.getCoeff().doubleValue();
        return new MpExprTerm(coeff, array);
    }

    public String toString() {
        String s = "(";
        if (this.coeff.doubleValue() != 1.0 || this.vars.length == 0) {
            s = s + this.coeff;
            if (this.vars.length > 0) {
                s = s + " * ";
            }
        }
        for (int i = 0; i < this.vars.length; ++i) {
            s = s + this.vars[i];
            if (i >= this.vars.length - 1) continue;
            s = s + " * ";
        }
        s = s + ")";
        return s;
    }
}

