/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmpi.main.expression;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import net.sf.jmpi.main.MpConstraint;
import net.sf.jmpi.main.MpProblem;
import net.sf.jmpi.main.MpVariable;
import net.sf.jmpi.main.expression.MpExpr;
import net.sf.jmpi.main.expression.MpExprTerm;

public class MpNormalizer {
    protected Map<BooleanProduct, Object> booleanProdMap = new HashMap<BooleanProduct, Object>();

    public MpProblem resolveBooleanProducts(MpProblem org) {
        MpProblem result = new MpProblem();
        for (MpVariable var : org.getVariables()) {
            result.addVariable(var);
        }
        for (MpConstraint constraint : org.getConstraints()) {
            MpConstraint c = this.resolveBooleanProducts(constraint, result);
            result.add(c);
        }
        if (org.getObjective() != null) {
            MpExpr objective = this.resolveBooleanProducts(org.getObjective(), result);
            result.setObjective(objective, org.getOptType());
        }
        return result;
    }

    public MpConstraint resolveBooleanProducts(MpConstraint constraint, MpProblem problem) {
        MpExpr lhs = this.resolveBooleanProducts(constraint.getLhs(), problem);
        MpExpr rhs = this.resolveBooleanProducts(constraint.getRhs(), problem);
        return new MpConstraint(lhs, constraint.getOperator(), rhs);
    }

    public MpExpr resolveBooleanProducts(MpExpr expr, MpProblem problem) {
        boolean e = false;
        for (MpExprTerm term : expr) {
            int i = 0;
            for (Object var : term.getVars()) {
                if (problem.getVariableType(var) != MpVariable.Type.BOOL) continue;
                ++i;
            }
            if (i <= true) continue;
            e = true;
            break;
        }
        if (!e) {
            return expr;
        }
        MpExpr result = MpExpr.sum(new Object[0]);
        for (MpExprTerm term : expr) {
            MpExpr newTerm = MpExpr.prod(term.getCoeff());
            BooleanProduct booleanVars = new BooleanProduct();
            for (Object var : term.getVars()) {
                if (problem.getVariableType(var) == MpVariable.Type.BOOL) {
                    booleanVars.add(var);
                    continue;
                }
                newTerm.mul(var);
            }
            if (booleanVars.size() < 2) {
                for (Object obj : booleanVars) {
                    newTerm.mul(obj);
                }
            } else {
                BooleanProduct set = new BooleanProduct();
                for (Object var : booleanVars) {
                    set.add(var);
                }
                newTerm.mul(set);
                if (!this.booleanProdMap.containsKey(set)) {
                    problem.addVar(set, Boolean.class);
                    this.booleanProdMap.put(set, set);
                    for (Object var : booleanVars) {
                        MpExpr lhs = MpExpr.sum(MpExpr.prod(-1, set), MpExpr.prod(1, var));
                        problem.add(lhs, ">=", (Number)0);
                    }
                    MpExpr lhs = MpExpr.sum(new Object[0]);
                    for (Object var : booleanVars) {
                        lhs.add(MpExpr.prod(-1, var));
                    }
                    lhs.add(MpExpr.prod(1, set));
                    lhs.add(MpExpr.prod(booleanVars.size() - 1));
                    problem.add(lhs, ">=", (Number)0);
                }
            }
            result.add(newTerm);
        }
        return result;
    }

    public static class BooleanProduct
    extends HashSet<Object> {
        private static final long serialVersionUID = 1L;

        @Override
        public String toString() {
            String s = super.toString();
            return "<" + s.substring(1, s.length() - 1) + ">";
        }
    }
}

