/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jmpi.solver;

import java.util.HashMap;
import java.util.Map;
import net.sf.jmpi.main.MpConstraint;
import net.sf.jmpi.main.MpDirection;
import net.sf.jmpi.main.MpProblem;
import net.sf.jmpi.main.MpSolver;
import net.sf.jmpi.main.MpVariable;
import net.sf.jmpi.main.expression.MpExpr;
import net.sf.jmpi.main.expression.MpExprTerm;
import net.sf.jmpi.main.expression.MpVars;

public abstract class AbstractMpSolver<V, C>
implements MpSolver {
    protected final Map<Object, V> objectToVar = new HashMap<Object, V>();
    protected final Map<V, MpVariable> variables = new HashMap<V, MpVariable>();
    protected final Map<C, MpConstraint> constraints = new HashMap<C, MpConstraint>();
    protected MpExpr objectiveFunction = MpExpr.sum(new Object[0]);
    protected MpDirection optType = MpDirection.MIN;

    protected V getVar(Object object) {
        if (object instanceof MpVariable) {
            throw new IllegalArgumentException("" + object + " is a Variable class");
        }
        V var = this.objectToVar.get(object);
        if (var == null) {
            System.out.println(this.objectToVar.get("x0") + " " + object.getClass());
            throw new IllegalArgumentException("Variable " + object + " is undefined.");
        }
        return var;
    }

    @Override
    public void add(MpProblem problem) {
        for (MpVariable variable : problem.getVariables()) {
            V nativeVariable = this.addVariable(variable);
            this.registerVariable(variable, nativeVariable);
        }
        for (MpConstraint constraint : problem.getConstraints()) {
            C nativeConstraint = this.addConstraint(constraint);
            this.registerConstraint(constraint, nativeConstraint);
        }
        if (problem.getObjective() != null && problem.getOptType() != MpDirection.UNDEFINED) {
            this.objectiveFunction = problem.getObjective();
            this.optType = problem.getOptType();
            this.setObjective(this.objectiveFunction, this.optType);
        }
    }

    protected void registerVariable(MpVariable variable, V nativeVar) {
        this.objectToVar.put(variable.getVar(), nativeVar);
        this.variables.put((MpVariable)nativeVar, variable);
    }

    protected void registerConstraint(MpConstraint constraint, C nativeConstraint) {
        this.constraints.put(nativeConstraint, constraint);
    }

    protected abstract void setObjective(MpExpr var1, MpDirection var2);

    protected abstract C addConstraint(MpConstraint var1);

    protected abstract V addVariable(MpVariable var1);

    protected MpConstraint normalize(MpConstraint c) {
        MpExpr lhs = c.getLhs();
        MpExpr rhs = c.getRhs();
        double rhsValue = 0.0;
        HashMap<MpVars, Double> terms = new HashMap<MpVars, Double>();
        for (MpExprTerm mpExprTerm : lhs) {
            rhsValue += this.add(mpExprTerm.getVars(), mpExprTerm.getCoeff().doubleValue(), terms);
        }
        for (MpExprTerm mpExprTerm : rhs) {
            rhsValue += this.add(mpExprTerm.getVars(), -mpExprTerm.getCoeff().doubleValue(), terms);
        }
        lhs = MpExpr.sum(new Object[0]);
        for (Map.Entry entry : terms.entrySet()) {
            MpExprTerm term = new MpExprTerm((Number)entry.getValue(), ((MpVars)entry.getKey()).getVars());
            lhs.addTerm(term);
        }
        rhs = MpExpr.sum(rhsValue);
        return new MpConstraint(lhs, c.getOperator(), rhs);
    }

    protected double add(Object[] vars, double coeff, Map<MpVars, Double> terms) {
        if (vars.length == 0) {
            return -coeff;
        }
        MpVars key = new MpVars(vars);
        Double value = terms.get(key);
        if (value == null) {
            value = 0.0;
        }
        terms.put(key, value + coeff);
        return 0.0;
    }

    protected double normalizedRhsValue(MpConstraint c) {
        return c.getRhs().iterator().next().getCoeff().doubleValue();
    }
}

