/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.writer;

import java.io.IOException;
import java.io.Writer;

public class TeeWriter
extends Writer {
    private long size = 0L;
    private final long[] writeTime;
    protected boolean closeCalled = false;
    protected final Writer[] destinations;

    public TeeWriter(Writer ... destinations) {
        this.checkDestinations(destinations);
        this.writeTime = new long[destinations.length];
        this.destinations = destinations;
    }

    public void close() throws IOException {
        if (!this.closeCalled) {
            this.closeCalled = true;
            int i = 0;
            while (i < this.destinations.length) {
                Writer stream = this.destinations[i];
                long start = System.currentTimeMillis();
                stream.close();
                int n = i++;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
        }
    }

    public void flush() throws IOException {
        if (!this.closeCalled) {
            int i = 0;
            while (i < this.destinations.length) {
                Writer stream = this.destinations[i];
                long start = System.currentTimeMillis();
                stream.flush();
                int n = i++;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
        }
    }

    public final long getSize() {
        return this.size;
    }

    public long[] getWriteTime() {
        return this.writeTime;
    }

    public void write(char[] b) throws IOException {
        if (b == null) {
            throw new NullPointerException("Array of bytes can't be null");
        }
        if (!this.closeCalled) {
            int i = 0;
            while (i < this.destinations.length) {
                Writer stream = this.destinations[i];
                long start = System.currentTimeMillis();
                stream.write(b);
                int n = i++;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
            this.size += (long)b.length;
        }
    }

    public void write(char[] b, int off, int len) throws IOException {
        if (b == null) {
            throw new NullPointerException("Array of bytes can't be null");
        }
        if (!this.closeCalled) {
            int i = 0;
            while (i < this.destinations.length) {
                Writer stream = this.destinations[i];
                long start = System.currentTimeMillis();
                stream.write(b, off, len);
                int n = i++;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
            this.size += (long)len;
        }
    }

    public void write(int b) throws IOException {
        if (!this.closeCalled) {
            int i = 0;
            while (i < this.destinations.length) {
                Writer stream = this.destinations[i];
                long start = System.currentTimeMillis();
                stream.write(b);
                ++this.size;
                int n = i++;
                this.writeTime[n] = this.writeTime[n] + (System.currentTimeMillis() - start);
            }
            ++this.size;
        }
    }

    private void checkDestinations(Writer ... destinations) {
        if (destinations == null) {
            throw new IllegalArgumentException("Destinations Writer can't be null");
        }
        if (destinations.length == 0) {
            throw new IllegalArgumentException("At least one destination Writer must be specified");
        }
        for (Writer destination : destinations) {
            if (destination != null) continue;
            throw new IllegalArgumentException("One of the Writers in the array is null");
        }
    }
}

