/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.os.inspection;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OutputStreamDumper<T extends OutputStream>
extends FilterOutputStream {
    public static final long INDEFINITE_SIZE = -1L;
    private final ByteArrayOutputStream dataDumpStream = new ByteArrayOutputStream();
    private boolean dumpEnabled = true;
    private final long maxDumpSize;

    public OutputStreamDumper(T sink) {
        this(sink, -1L);
    }

    public OutputStreamDumper(T out, long maxDumpSize) {
        super((OutputStream)out);
        this.maxDumpSize = maxDumpSize;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public void enableDump(boolean enable) {
        this.dumpEnabled = enable;
    }

    public final byte[] getData() {
        return this.dataDumpStream.toByteArray();
    }

    public final T getWrappedStream() {
        return (T)this.out;
    }

    private boolean maxSizeNotReached() {
        long currentSize;
        boolean result = this.maxDumpSize == -1L ? true : (currentSize = (long)this.dataDumpStream.size()) < this.maxDumpSize;
        return result;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        if (this.dumpEnabled && this.maxSizeNotReached()) {
            int lenght;
            if (this.maxDumpSize == -1L) {
                lenght = len;
            } else {
                long currentPosition = this.dataDumpStream.size();
                lenght = (int)Math.min((long)len, this.maxDumpSize - currentPosition);
            }
            this.dataDumpStream.write(b, off, lenght);
        }
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        if (this.dumpEnabled && this.maxSizeNotReached()) {
            this.dataDumpStream.write(b);
        }
    }
}

