/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.writer.inspection;

import java.io.FilterWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WriterDumper<T extends Writer>
extends FilterWriter {
    public static final long INDEFINITE_SIZE = -1L;
    private long currentSize = 0L;
    private final StringWriter dataDumpStream = new StringWriter();
    private boolean dumpEnabled = true;
    private final long maxDumpSize;

    public WriterDumper(T sink) {
        this(sink, -1L);
    }

    public WriterDumper(T out, long maxDumpSize) {
        super((Writer)out);
        this.maxDumpSize = maxDumpSize;
    }

    @Override
    public void close() throws IOException {
        super.close();
    }

    public void enableDump(boolean enable) {
        this.dumpEnabled = enable;
    }

    public final String getData() {
        return this.dataDumpStream.toString();
    }

    public final T getWrappedStream() {
        return (T)this.out;
    }

    private boolean maxSizeNotReached() {
        boolean result = this.maxDumpSize == -1L ? true : this.currentSize < this.maxDumpSize;
        return result;
    }

    @Override
    public void write(char[] b, int off, int len) throws IOException {
        this.out.write(b, off, len);
        if (this.dumpEnabled && this.maxSizeNotReached()) {
            int lenght = this.maxDumpSize == -1L ? len : (int)Math.min((long)len, this.maxDumpSize - this.currentSize);
            this.currentSize += (long)lenght;
            this.dataDumpStream.write(b, off, lenght);
        }
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        if (this.dumpEnabled && this.maxSizeNotReached()) {
            this.dataDumpStream.write(b);
            ++this.currentSize;
        }
    }
}

