/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt;

import com.gc.iotools.fmt.GuessInputStreamImpl;
import com.gc.iotools.fmt.GuessInputStreamWrapper;
import com.gc.iotools.fmt.base.Decoder;
import com.gc.iotools.fmt.base.Detector;
import com.gc.iotools.fmt.base.FormatEnum;
import com.gc.iotools.fmt.decoders.Base64Decoder;
import com.gc.iotools.fmt.detectors.Base64Detector;
import com.gc.iotools.fmt.detectors.GifDetector;
import com.gc.iotools.fmt.detectors.M7MDetector;
import com.gc.iotools.fmt.detectors.PdfDetector;
import com.gc.iotools.fmt.detectors.PemDetector;
import com.gc.iotools.fmt.detectors.RTFDetectorModule;
import com.gc.iotools.fmt.detectors.XmlDetector;
import com.gc.iotools.fmt.detectors.ZipDetectorModule;
import com.gc.iotools.fmt.detectors.pksc7.PKCS7Detector;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;

public abstract class GuessInputStream
extends InputStream {
    private static final Map DECODERS = Collections.synchronizedMap(new HashMap());
    private static final Map DETECTORS = Collections.synchronizedMap(new HashMap());
    private final Collection enabledFormats;

    public static void addDecoder(Decoder decoder) {
        if (decoder == null) {
            throw new IllegalArgumentException("decoder is null");
        }
        DECODERS.put(decoder.getFormat(), decoder);
    }

    public static void addDecoders(Decoder[] decoders) {
        if (decoders == null) {
            throw new IllegalArgumentException("decoders array is null");
        }
        for (int i = 0; i < decoders.length; ++i) {
            Decoder decoder = decoders[i];
            if (decoder == null) continue;
            DECODERS.put(decoder.getFormat(), decoder);
        }
    }

    public static void addDetector(Detector detector) {
        if (detector == null) {
            throw new IllegalArgumentException("detector is null");
        }
        DETECTORS.put(detector.getDetectedFormat(), detector);
    }

    public static void addDetectors(Detector[] detectors) {
        if (detectors == null) {
            throw new IllegalArgumentException("detectors are null");
        }
        for (int i = 0; i < detectors.length; ++i) {
            Detector detector = detectors[i];
            if (detector == null) continue;
            DETECTORS.put(detector.getDetectedFormat(), detector);
        }
    }

    public static Map getDetectorsMap() {
        return DETECTORS;
    }

    public static GuessInputStream getInstance(InputStream istream) throws IOException {
        return GuessInputStream.getInstance(istream, DETECTORS.keySet().toArray(new FormatEnum[DETECTORS.keySet().size()]));
    }

    public static GuessInputStream getInstance(InputStream istream, FormatEnum[] enabledFormats) throws IOException {
        GuessInputStream gis;
        Decoder[] decoders = GuessInputStream.getDecoders(enabledFormats, null);
        Detector[] detectors = GuessInputStream.getDetectorModules(enabledFormats, null);
        GuessInputStream result = istream instanceof GuessInputStream ? ((gis = (GuessInputStream)istream).canDetectAll(enabledFormats) ? new GuessInputStreamWrapper(gis, enabledFormats) : new GuessInputStreamImpl(detectors, decoders, istream)) : new GuessInputStreamImpl(detectors, decoders, istream);
        return result;
    }

    private static Decoder[] getDecoders(FormatEnum[] enabledFormats, Decoder[] extraDecoders) {
        HashSet<Decoder> modules = new HashSet<Decoder>();
        for (int i = 0; i < enabledFormats.length; ++i) {
            FormatEnum formatEnum = enabledFormats[i];
            Decoder decoder = (Decoder)DECODERS.get((Object)formatEnum);
            if (decoder == null) continue;
            modules.add(decoder);
        }
        if (extraDecoders != null) {
            modules.addAll(Arrays.asList(extraDecoders));
        }
        return modules.toArray(new Decoder[modules.size()]);
    }

    private static Detector[] getDetectorModules(FormatEnum[] enabledFormats, Detector[] extraDetectors) {
        HashSet<Detector> modules = new HashSet<Detector>();
        for (int i = 0; i < enabledFormats.length; ++i) {
            FormatEnum formatEnum = enabledFormats[i];
            Detector detectModule = (Detector)DETECTORS.get((Object)formatEnum);
            if (detectModule == null) {
                throw new IllegalArgumentException("Detector for [" + (Object)((Object)formatEnum) + "] not registred");
            }
            modules.add(detectModule);
        }
        if (extraDetectors != null) {
            modules.addAll(Arrays.asList(extraDetectors));
        }
        return modules.toArray(new Detector[modules.size()]);
    }

    protected GuessInputStream(FormatEnum[] enabledFormats) {
        this.enabledFormats = Collections.unmodifiableCollection(Arrays.asList(enabledFormats));
    }

    public final boolean canDetect(FormatEnum tenum) {
        return this.enabledFormats.contains((Object)tenum);
    }

    public final boolean canDetectAll(FormatEnum[] formatEnums) {
        FormatEnum formatEnum;
        if (formatEnums == null) {
            throw new IllegalArgumentException("Parameter formatEnum is null");
        }
        boolean result = true;
        for (int i = 0; i < formatEnums.length && result; result &= this.canDetect(formatEnum), ++i) {
            formatEnum = formatEnums[i];
        }
        return result;
    }

    public abstract FormatEnum getFormat();

    public abstract FormatEnum[] getFormats();

    static {
        DETECTORS.put(FormatEnum.BASE64, new Base64Detector());
        DETECTORS.put(FormatEnum.GIF, new GifDetector());
        DETECTORS.put(FormatEnum.M7M, new M7MDetector());
        DETECTORS.put(FormatEnum.PDF, new PdfDetector());
        DETECTORS.put(FormatEnum.PEM, new PemDetector());
        DETECTORS.put(FormatEnum.PKCS7, new PKCS7Detector());
        DETECTORS.put(FormatEnum.RTF, new RTFDetectorModule());
        DETECTORS.put(FormatEnum.XML, new XmlDetector());
        DETECTORS.put(FormatEnum.ZIP, new ZipDetectorModule());
        DECODERS.put(FormatEnum.BASE64, new Base64Decoder());
    }
}

