/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt;

import com.gc.iotools.fmt.GuessInputStream;
import com.gc.iotools.fmt.base.Decoder;
import com.gc.iotools.fmt.base.Detector;
import com.gc.iotools.fmt.base.FormatEnum;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

final class GuessInputStreamImpl
extends GuessInputStream {
    private static final int MAX_LEVELS = 2;
    private final FormatEnum[] formats;
    private final BufferedInputStream bis;

    private static FormatEnum detectFormat(byte[] bytes, Detector[] detectors) {
        FormatEnum detected = FormatEnum.UNKNOWN;
        for (int i = 0; i < detectors.length; ++i) {
            Detector detector = detectors[i];
            int bytesToCopy = Math.min(detector.getDetectLenght(), bytes.length);
            byte[] splittedBytes = new byte[bytesToCopy];
            System.arraycopy(bytes, 0, splittedBytes, 0, bytesToCopy);
            if (!detector.detect(splittedBytes)) continue;
            detected = detector.getDetectedFormat();
            break;
        }
        return detected;
    }

    private static FormatEnum[] detectFormats(byte[] bytes, Detector[] detectors, Decoder[] decoders) {
        Map decodersMap = GuessInputStreamImpl.getDecodersMap(decoders);
        ArrayList<FormatEnum> formats = new ArrayList<FormatEnum>();
        FormatEnum currentFormat = null;
        byte[] currentBytes = bytes;
        for (int i = 0; i < 2 && (currentFormat == null || decodersMap.containsKey((Object)currentFormat)); ++i) {
            currentFormat = GuessInputStreamImpl.detectFormat(currentBytes, detectors);
            formats.add(currentFormat);
            if (!decodersMap.containsKey((Object)currentFormat)) continue;
            currentBytes = ((Decoder)decodersMap.get((Object)currentFormat)).decode(currentBytes);
        }
        return formats.toArray(new FormatEnum[formats.size()]);
    }

    private static int getBufferSize(Detector[] detectors, Decoder[] decoders) {
        int detectSize = 1;
        for (int i = 0; i < detectors.length; ++i) {
            Detector detector = detectors[i];
            detectSize = Math.max(detectSize, detector.getDetectLenght());
        }
        int decodeOffset = 1;
        for (int i = 0; i < decoders.length; ++i) {
            Decoder decoder = decoders[i];
            decodeOffset = Math.max(decodeOffset, decoder.getEncodingOffset());
        }
        float decodeRatio = 1.0f;
        for (int i = 0; i < decoders.length; ++i) {
            Decoder decoder = decoders[i];
            decodeRatio = Math.max(decodeRatio, decoder.getRatio());
        }
        return (int)((float)detectSize * decodeRatio) + decodeOffset + 1;
    }

    private static Map getDecodersMap(Decoder[] decoders) {
        HashMap<FormatEnum, Decoder> formatsMap = new HashMap<FormatEnum, Decoder>();
        for (int i = 0; i < decoders.length; ++i) {
            Decoder decoder = decoders[i];
            formatsMap.put(decoder.getFormat(), decoder);
        }
        return formatsMap;
    }

    private static FormatEnum[] getEnabledFormats(Detector[] detectors) {
        ArrayList<FormatEnum> formatsColl = new ArrayList<FormatEnum>();
        for (int i = 0; i < detectors.length; ++i) {
            Detector detector = detectors[i];
            formatsColl.add(detector.getDetectedFormat());
        }
        return formatsColl.toArray(new FormatEnum[formatsColl.size()]);
    }

    private static byte[] readBytesAndReset(BufferedInputStream input, int size) throws IOException {
        byte[] result;
        int pos;
        int size1 = size - 1;
        byte[] buffer = new byte[size1];
        input.mark(size);
        int n = 0;
        for (pos = 0; pos < size1 && -1 != (n = input.read(buffer, pos, size1 - pos)); pos += n) {
        }
        input.reset();
        if (pos == size1) {
            result = buffer;
        } else {
            result = new byte[pos];
            System.arraycopy(buffer, 0, result, 0, pos);
        }
        return result;
    }

    public GuessInputStreamImpl(Detector[] detectors, Decoder[] decoders, InputStream istream) throws IOException {
        super(GuessInputStreamImpl.getEnabledFormats(detectors));
        int bufferSize = GuessInputStreamImpl.getBufferSize(detectors, decoders);
        this.bis = new BufferedInputStream(istream, bufferSize);
        byte[] bytes = GuessInputStreamImpl.readBytesAndReset(this.bis, bufferSize);
        this.formats = GuessInputStreamImpl.detectFormats(bytes, detectors, decoders);
    }

    public int available() throws IOException {
        return this.bis.available();
    }

    public void close() throws IOException {
        this.bis.close();
    }

    public final FormatEnum getFormat() {
        return this.formats[0];
    }

    public final FormatEnum[] getFormats() {
        return this.formats;
    }

    public void mark(int readlimit) {
        this.bis.mark(readlimit);
    }

    public boolean markSupported() {
        return this.bis.markSupported();
    }

    public int read() throws IOException {
        return this.bis.read();
    }

    public int read(byte[] b) throws IOException {
        return this.bis.read(b);
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.bis.read(b, off, len);
    }

    public void reset() throws IOException {
        this.bis.reset();
    }

    public long skip(long n) throws IOException {
        return this.bis.skip(n);
    }
}

