/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt.detectors;

import com.bea.xml.stream.MXParserFactory;
import com.gc.iotools.fmt.base.AbstractFormatDetector;
import com.gc.iotools.fmt.base.FormatEnum;
import java.io.ByteArrayInputStream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class XmlDetector
extends AbstractFormatDetector {
    private static final int XML_GUESS_SIZE = 8192;
    static final Log LOGGER = LogFactory.getLog(XmlDetector.class);

    public XmlDetector() {
        super(8192, FormatEnum.XML);
    }

    public boolean detect(byte[] readedBytes) {
        XMLInputFactory factory = XMLInputFactory.newInstance(MXParserFactory.class.getName(), XmlDetector.class.getClassLoader());
        factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        factory.setXMLReporter(new MyReporter());
        ByteArrayInputStream in = new ByteArrayInputStream(readedBytes);
        boolean xmlDetected = false;
        long currentEvent = -1L;
        try {
            XMLEventReader parser = factory.createXMLEventReader(in);
            while (parser.hasNext()) {
                ++currentEvent;
                XMLEvent event = parser.nextEvent();
                LOGGER.debug((Object)("Found XML event [" + event.getEventType() + "]"));
            }
            xmlDetected = true;
            LOGGER.debug((Object)"XML detected (EOF reach)");
        }
        catch (XMLStreamException e) {
            if (e.getMessage() != null && e.getMessage().indexOf("end of stream") >= 0 && readedBytes.length == 8192) {
                xmlDetected = this.evaluateException(currentEvent);
            }
            LOGGER.debug((Object)("XML not detected " + e));
        }
        return xmlDetected;
    }

    private boolean evaluateException(long currentElem) {
        boolean tenum = false;
        if (currentElem != -1L) {
            tenum = true;
            LOGGER.debug((Object)("XML (partial parsing) [" + currentElem + "]"));
        } else {
            LOGGER.debug((Object)"No xml found in first [8192] bytes");
        }
        return tenum;
    }

    private final class MyReporter
    implements XMLReporter {
        MyReporter() {
        }

        public void report(String message, String errorType, Object relatedInformation, Location location) throws XMLStreamException {
            LOGGER.debug((Object)location);
        }
    }
}

