/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt.detectors.pksc7;

import com.gc.iotools.fmt.base.AbstractFormatDetector;
import com.gc.iotools.fmt.base.FormatEnum;
import com.gc.iotools.fmt.detectors.pksc7.ASN1Reader;
import com.gc.iotools.fmt.detectors.pksc7.FormatException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;

public class PKCS7Detector
extends AbstractFormatDetector {
    private static final Log LOGGER = LogFactory.getLog(PKCS7Detector.class);

    public PKCS7Detector() {
        super(90, FormatEnum.PKCS7);
    }

    public boolean detect(byte[] readedBytes) {
        ByteArrayInputStream buffer = new ByteArrayInputStream(readedBytes);
        boolean result = false;
        try {
            ASN1Reader pkcsHdrRead = new ASN1Reader(buffer);
            pkcsHdrRead.check(PKCSObjectIdentifiers.signedData);
            result = true;
        }
        catch (FormatException e) {
            LOGGER.debug((Object)("PKCS7 not recognizedException (normal) [" + e.getMessage() + "]"));
        }
        catch (IOException e) {
            LOGGER.warn((Object)"PKCS7 not recognized for an I/O exception", (Throwable)e);
        }
        catch (Throwable e) {
            LOGGER.warn((Object)"PKCS7 not recognized for unexpected exception.", e);
        }
        return result;
    }
}

