/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt;

import com.gc.iotools.fmt.DetectionStrategy;
import com.gc.iotools.fmt.InputStreamStatusEnum;
import com.gc.iotools.fmt.ResettableStreamRASAdapter;
import com.gc.iotools.fmt.base.Decoder;
import com.gc.iotools.fmt.base.DetectionLibrary;
import com.gc.iotools.fmt.base.FormatEnum;
import com.gc.iotools.fmt.base.FormatId;
import com.gc.iotools.fmt.decoders.Base64Decoder;
import com.gc.iotools.fmt.decoders.Bzip2Decoder;
import com.gc.iotools.fmt.decoders.GzipDecoder;
import com.gc.iotools.fmt.decoders.Pkcs7Decoder;
import com.gc.iotools.fmt.decoders.TSDDecoder;
import com.gc.iotools.fmt.detect.droid.DroidDetectorImpl;
import com.gc.iotools.fmt.detect.wzf.StreamDetectorImpl;
import com.gc.iotools.stream.is.RandomAccessInputStream;
import com.gc.iotools.stream.utils.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuessInputStream
extends InputStream {
    public static final Map<FormatEnum, Decoder> DEFAULT_DECODERS = new HashMap<FormatEnum, Decoder>();
    private static final Logger LOGGER = LoggerFactory.getLogger(GuessInputStream.class);
    private final ResettableStreamRASAdapter baseStream;
    private boolean decode = false;
    private final DetectionStrategy detectionStrategy;
    private final Collection<FormatEnum> enabledFormats;
    private final String instantiationPath;
    private InputStreamStatusEnum status = InputStreamStatusEnum.NOT_INITIALIZED;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addDefaultDecoder(Decoder decoder) {
        if (decoder == null) {
            throw new IllegalArgumentException("decoder is null");
        }
        Map<FormatEnum, Decoder> map = DEFAULT_DECODERS;
        synchronized (map) {
            DEFAULT_DECODERS.put(decoder.getFormat(), decoder);
        }
    }

    public static void addDefaultDecoders(Decoder[] decoders) {
        if (decoders == null) {
            throw new IllegalArgumentException("decoders array is null");
        }
        for (Decoder decoder : decoders) {
            GuessInputStream.addDefaultDecoder(decoder);
        }
    }

    private static FormatEnum[] getEffectiveFormats(FormatEnum[] enabledFormats, DetectionLibrary[] detectors) {
        ArrayList<FormatEnum> formats = new ArrayList<FormatEnum>();
        for (DetectionLibrary detectionLibrary : detectors) {
            formats.addAll(Arrays.asList(detectionLibrary.getDetectedFormats()));
        }
        FormatEnum[] allFormats = formats.toArray(new FormatEnum[0]);
        FormatEnum[] effectiveFormats = enabledFormats == null ? allFormats : enabledFormats;
        return effectiveFormats;
    }

    public static GuessInputStream getInstance(InputStream source) {
        return GuessInputStream.getInstance(source, FormatEnum.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GuessInputStream getInstance(InputStream istream, Class<? extends FormatEnum> clazz, String droidSignatureFile, String streamConfigFile) {
        Decoder[] decoders;
        DetectionLibrary stream;
        if (droidSignatureFile == null && streamConfigFile == null) {
            throw new IllegalArgumentException("both configuration files are null.");
        }
        HashSet<StreamDetectorImpl> detectionLibraries = new HashSet<StreamDetectorImpl>();
        if (streamConfigFile != null) {
            stream = new StreamDetectorImpl(streamConfigFile, clazz);
            detectionLibraries.add((StreamDetectorImpl)stream);
        }
        if (droidSignatureFile != null) {
            stream = new DroidDetectorImpl(clazz, droidSignatureFile, null);
            detectionLibraries.add((StreamDetectorImpl)stream);
        }
        DetectionLibrary[] detectionLibrariesArray = detectionLibraries.toArray(new DetectionLibrary[detectionLibraries.size()]);
        Map<FormatEnum, Decoder> map = DEFAULT_DECODERS;
        synchronized (map) {
            decoders = DEFAULT_DECODERS.values().toArray(new Decoder[0]);
        }
        return GuessInputStream.getInstance(istream, null, detectionLibrariesArray, decoders);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GuessInputStream getInstance(InputStream source, FormatEnum[] enabledFormats) {
        Decoder[] decoders;
        ArrayList<DetectionLibrary> detectionLibraries = new ArrayList<DetectionLibrary>();
        detectionLibraries.add(new StreamDetectorImpl());
        detectionLibraries.add(new DroidDetectorImpl());
        Map<FormatEnum, Decoder> map = DEFAULT_DECODERS;
        synchronized (map) {
            decoders = DEFAULT_DECODERS.values().toArray(new Decoder[0]);
        }
        return GuessInputStream.getInstance(source, enabledFormats, detectionLibraries.toArray(new DetectionLibrary[0]), decoders);
    }

    public static GuessInputStream getInstance(InputStream stream, FormatEnum[] enabledFormats, DetectionLibrary[] detectors, Decoder[] decoders) {
        ResettableStreamRASAdapter ris;
        if (stream == null) {
            throw new IllegalArgumentException("Parameter stream==null");
        }
        FormatEnum[] effectiveFormats = GuessInputStream.getEffectiveFormats(enabledFormats, detectors);
        if (stream instanceof GuessInputStream) {
            GuessInputStream gis = (GuessInputStream)stream;
            ris = gis.baseStream;
        } else {
            ris = new ResettableStreamRASAdapter((InputStream)new RandomAccessInputStream(stream));
        }
        DetectionStrategy ds = new DetectionStrategy(detectors, decoders, effectiveFormats, ris);
        GuessInputStream result = new GuessInputStream(effectiveFormats, ris, ds);
        return result;
    }

    protected GuessInputStream(FormatEnum[] enabledFormats, ResettableStreamRASAdapter baseStream, DetectionStrategy decodedStream) {
        this.enabledFormats = Collections.unmodifiableCollection(Arrays.asList(enabledFormats));
        this.baseStream = baseStream;
        this.detectionStrategy = decodedStream;
        this.instantiationPath = LogUtils.getCaller(GuessInputStream.class, (int)3);
    }

    @Override
    public int available() throws IOException {
        return this.getStream().available();
    }

    public final boolean canDetect(FormatEnum formatEnum) {
        if (formatEnum == null) {
            throw new IllegalArgumentException("Parameter formatEnum is null");
        }
        return this.enabledFormats.contains((Object)formatEnum);
    }

    public final boolean canDetectAll(FormatEnum[] formatsEnum) {
        FormatEnum formatEnum;
        if (formatsEnum == null) {
            throw new IllegalArgumentException("Parameter formatEnums is null");
        }
        boolean result = true;
        for (int i = 0; i < formatsEnum.length && result; result &= this.enabledFormats.contains((Object)formatEnum), ++i) {
            formatEnum = formatsEnum[i];
        }
        return result;
    }

    @Override
    public void close() throws IOException {
        this.status = InputStreamStatusEnum.READING_DATA;
        this.baseStream.close();
    }

    public void decode(boolean decode) {
        if (this.status.equals((Object)InputStreamStatusEnum.READING_DATA) && decode != this.decode) {
            throw new IllegalStateException("Some byte has been  read already from the underlying stream. It is not possible to change the decoding behaviour now. Decoding behaviour set [" + this.decode + "] decoding wanted[" + decode + "]");
        }
        this.decode = decode;
    }

    protected void finalize() throws Throwable {
        if (!this.baseStream.isCloseCalled()) {
            LOGGER.warn(this.getClass().getSimpleName() + " is being finalized but close() method has " + "not been called. Please ensure the " + "stream is correctly " + "closed before finalization. Instantiation path [" + this.instantiationPath + "]");
            this.baseStream.close();
        }
    }

    public FormatId[] getDetectedFormatsId() throws IOException {
        return this.detectionStrategy.getFormats();
    }

    public final FormatEnum getFormat() throws IOException {
        return this.getFormatId().format;
    }

    public final FormatId getFormatId() throws IOException {
        return this.getDetectedFormatsId()[0];
    }

    public final FormatEnum[] getFormats() throws IOException {
        FormatId[] formats = this.getDetectedFormatsId();
        ArrayList<FormatEnum> result = new ArrayList<FormatEnum>();
        for (FormatId formatId : formats) {
            result.add(formatId.format);
        }
        return result.toArray(new FormatEnum[0]);
    }

    private InputStream getStream() throws IOException {
        return this.decode ? this.detectionStrategy.getStream() : this.baseStream;
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    @Override
    public int read() throws IOException {
        this.status = InputStreamStatusEnum.READING_DATA;
        return this.getStream().read();
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.status = InputStreamStatusEnum.READING_DATA;
        return this.getStream().read(b);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.status = InputStreamStatusEnum.READING_DATA;
        return this.getStream().read(b, off, len);
    }

    public void setIdentificationDepth(int level) {
        if (InputStreamStatusEnum.READING_DATA.equals((Object)this.status)) {
            throw new IllegalStateException("The number of recursion can be set only before any read() operation has been called.");
        }
        if (level < 1) {
            throw new IllegalArgumentException("Identification depth must be >=1 but was ][" + level + "]");
        }
        this.detectionStrategy.setMaxRecursion(level - 1);
    }

    @Override
    public long skip(long n) throws IOException {
        this.status = InputStreamStatusEnum.READING_DATA;
        return this.getStream().skip(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static {
        Map<FormatEnum, Decoder> map = DEFAULT_DECODERS;
        synchronized (map) {
            DEFAULT_DECODERS.put(FormatEnum.BASE64, new Base64Decoder());
            DEFAULT_DECODERS.put(FormatEnum.BZIP2, new Bzip2Decoder());
            DEFAULT_DECODERS.put(FormatEnum.GZ, new GzipDecoder());
            DEFAULT_DECODERS.put(FormatEnum.PKCS7, new Pkcs7Decoder());
            DEFAULT_DECODERS.put(FormatEnum.TSD, new TSDDecoder());
        }
    }
}

