/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt.detect.wzf.custom;

import com.bea.xml.stream.MXParserFactory;
import com.gc.iotools.fmt.base.FormatEnum;
import com.gc.iotools.fmt.base.FormatId;
import com.gc.iotools.fmt.detect.wzf.DefiniteLengthModule;
import java.io.ByteArrayInputStream;
import javax.xml.stream.Location;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLReporter;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class XmlModule
implements DefiniteLengthModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(XmlModule.class);
    private static final int XML_GUESS_SIZE = 8192;

    @Override
    public boolean detect(byte[] readBytes) {
        XMLInputFactory factory = XMLInputFactory.newInstance(MXParserFactory.class.getName(), XmlModule.class.getClassLoader());
        factory.setProperty("javax.xml.stream.isValidating", Boolean.FALSE);
        factory.setXMLReporter(new MyReporter());
        ByteArrayInputStream in = new ByteArrayInputStream(readBytes);
        boolean xmlDetected = false;
        long currentEvent = -1L;
        try {
            XMLEventReader parser = factory.createXMLEventReader(in);
            while (parser.hasNext()) {
                ++currentEvent;
                XMLEvent event = parser.nextEvent();
                LOGGER.debug("Found XML event [" + event.getEventType() + "]");
            }
            xmlDetected = true;
            LOGGER.debug("XML detected (EOF reach)");
        }
        catch (XMLStreamException e) {
            if (e.getMessage() != null && e.getMessage().indexOf("end of stream") >= 0 && readBytes.length == 8192) {
                xmlDetected = this.evaluateException(currentEvent);
            }
            LOGGER.debug("XML not detected " + e);
        }
        return xmlDetected;
    }

    @Override
    public FormatId getDetectedFormat() {
        return new FormatId(FormatEnum.XML, null);
    }

    @Override
    public int getDetectLength() {
        return 8192;
    }

    @Override
    public void init(FormatId fenum, String param) {
    }

    private boolean evaluateException(long currentElem) {
        boolean tenum = false;
        if (currentElem != -1L) {
            tenum = true;
            LOGGER.debug("XML (partial parsing) [" + currentElem + "]");
        } else {
            LOGGER.debug("No xml found in first [8192] bytes");
        }
        return tenum;
    }

    private final class MyReporter
    implements XMLReporter {
        MyReporter() {
        }

        @Override
        public void report(String message, String errorType, Object relatedInformation, Location location) throws XMLStreamException {
            LOGGER.debug(location.toString());
        }
    }
}

