/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.binFileReader;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import uk.gov.nationalarchives.droid.binFileReader.AbstractByteReader;
import uk.gov.nationalarchives.droid.binFileReader.IdentificationFile;

public class FileByteReader
extends AbstractByteReader {
    private int randomFileBufferSize = 100000000;
    private boolean isRandomAccess = false;
    private byte[] fileBytes;
    private long myNumBytes;
    private long fileMarker;
    private RandomAccessFile myRandomAccessFile;
    private long myRAFoffset = 0L;
    private static final int MIN_RAF_BUFFER_SIZE = 65536;
    private static final int RAF_BUFFER_REDUCTION_FACTOR = 4;
    private final File file;

    protected FileByteReader(IdentificationFile theIDFile, boolean readFile) {
        this(theIDFile, readFile, theIDFile.getFilePath());
    }

    FileByteReader(IdentificationFile theIDFile, boolean readFile, String filePath) {
        super(theIDFile);
        this.file = new File(filePath);
        if (readFile) {
            this.readFile();
        }
    }

    @Override
    public byte[] getbuffer() {
        return this.fileBytes;
    }

    @Override
    public byte getByte(long fileIndex) {
        byte theByte = 0;
        if (this.isRandomAccess) {
            long theArrayIndex = fileIndex - this.myRAFoffset;
            if (fileIndex >= this.myRAFoffset && theArrayIndex < (long)this.randomFileBufferSize) {
                theByte = this.fileBytes[(int)theArrayIndex];
            } else {
                try {
                    this.myRAFoffset = fileIndex < (long)this.randomFileBufferSize ? 0L : (fileIndex < this.myRAFoffset ? fileIndex - (long)this.randomFileBufferSize + 1L : fileIndex);
                    this.myRandomAccessFile.seek(this.myRAFoffset);
                    this.myRandomAccessFile.read(this.fileBytes);
                    theByte = this.fileBytes[(int)(fileIndex - this.myRAFoffset)];
                }
                catch (Exception e) {
                    throw new RuntimeException("Problem reading byte [" + fileIndex + "]", e);
                }
            }
        } else {
            theByte = this.fileBytes[(int)fileIndex];
        }
        return theByte;
    }

    @Override
    public long getFileMarker() {
        return this.fileMarker;
    }

    public RandomAccessFile getMyRandomAccessFile() {
        return this.myRandomAccessFile;
    }

    @Override
    public long getNumBytes() {
        return this.myNumBytes;
    }

    public int getRandomFileBufferSize() {
        return this.randomFileBufferSize;
    }

    public boolean isRandomAccess() {
        return this.isRandomAccess;
    }

    @Override
    public void setFileMarker(long markerPosition) {
        if (markerPosition < -1L || markerPosition > this.getNumBytes()) {
            throw new IllegalArgumentException("  Unable to place a fileMarker at byte " + Long.toString(markerPosition) + " in file " + this.myIDFile.getFilePath() + " (size = " + Long.toString(this.getNumBytes()) + " bytes)");
        }
        this.fileMarker = markerPosition;
    }

    private void readFile() {
        FileInputStream binStream;
        if (!this.file.exists()) {
            this.setErrorIdent();
            this.setIdentificationWarning("File does not exist");
            return;
        }
        if (!this.file.canRead()) {
            this.setErrorIdent();
            this.setIdentificationWarning("File cannot be read");
            return;
        }
        if (this.file.isDirectory()) {
            this.setErrorIdent();
            this.setIdentificationWarning("This is a directory, not a file");
            return;
        }
        try {
            binStream = new FileInputStream(this.file);
        }
        catch (FileNotFoundException ex) {
            this.setErrorIdent();
            this.setIdentificationWarning("File disappeared or cannot be read");
            return;
        }
        try {
            int numBytes = binStream.available();
            if (numBytes > 0) {
                BufferedInputStream buffStream = new BufferedInputStream(binStream);
                this.fileBytes = new byte[numBytes];
                int len = buffStream.read(this.fileBytes, 0, numBytes);
                if (len != numBytes) {
                    this.setErrorIdent();
                    this.setIdentificationWarning("Error reading file: " + Integer.toString(len) + " bytes read from file when " + Integer.toString(numBytes) + " were expected");
                } else if (buffStream.read() != -1) {
                    this.setErrorIdent();
                    this.setIdentificationWarning("Error reading file: Unable to read to the end");
                } else {
                    this.myNumBytes = numBytes;
                }
                buffStream.close();
            } else {
                this.myNumBytes = 0L;
                this.setIdentificationWarning("Zero-length file");
            }
            binStream.close();
            this.isRandomAccess = false;
        }
        catch (IOException e) {
            this.setErrorIdent();
            this.setIdentificationWarning("Error reading file: " + e.toString());
        }
        catch (OutOfMemoryError e) {
            try {
                this.myRandomAccessFile = new RandomAccessFile(this.file, "r");
                this.isRandomAccess = true;
                this.myNumBytes = this.myRandomAccessFile.length();
                this.myRandomAccessFile.seek(0L);
                boolean tryAgain = true;
                while (tryAgain) {
                    try {
                        this.fileBytes = new byte[this.randomFileBufferSize];
                        this.myRandomAccessFile.read(this.fileBytes);
                        tryAgain = false;
                    }
                    catch (OutOfMemoryError e4) {
                        this.randomFileBufferSize /= 4;
                        if (this.randomFileBufferSize >= 65536) continue;
                        throw e4;
                    }
                }
                this.myRAFoffset = 0L;
            }
            catch (FileNotFoundException e2) {
                this.setErrorIdent();
                this.setIdentificationWarning("File disappeared or cannot be read");
            }
            catch (Exception e2) {
                try {
                    this.myRandomAccessFile.close();
                }
                catch (IOException e3) {
                    // empty catch block
                }
                this.setErrorIdent();
                this.setIdentificationWarning("Error reading file: " + e2.toString());
            }
        }
    }
}

