package com.gc.iotools.fmt.decoders;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;

import com.gc.iotools.fmt.base.Decoder;
import com.gc.iotools.fmt.base.FormatEnum;

/**
 * Decoder for TSD (TimeStampedData) documents.
 * 
 * @author Giacomo Boccardo (gboccard@gmail.com)
 *
 * @see Decoder
 */
public class TSDDecoder implements Decoder {

	@Override
	public InputStream decode(final InputStream tsdIS) throws IOException {
		TimeStampedDataParser tsdParser;
		try {
			tsdParser = new TimeStampedDataParser(tsdIS);
		} catch (final IOException e) {
			throw new IOException("Error parsing TSD content", e);
		}

		return new BufferedInputStream(tsdParser.getContentAsIS());
	}


	@Override
	public FormatEnum getFormat() {
		return FormatEnum.TSD;
	}

}
