/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt;

import com.gc.iotools.fmt.base.ResettableInputStream;
import com.gc.iotools.stream.is.RandomAccessInputStream;
import com.gc.iotools.stream.store.OnOffStore;
import com.gc.iotools.stream.store.SeekableStore;
import com.gc.iotools.stream.store.Store;
import com.gc.iotools.stream.store.ThresholdStore;
import java.io.IOException;
import java.io.InputStream;

public class ResettableStreamRASAdapter
extends ResettableInputStream {
    private final RandomAccessInputStream ras;

    public ResettableStreamRASAdapter(InputStream source) {
        ThresholdStore ts = new ThresholdStore(131072);
        OnOffStore os = new OnOffStore((SeekableStore)ts);
        this.ras = new RandomAccessInputStream(source, (SeekableStore)os);
    }

    public int available() throws IOException {
        return this.ras.available();
    }

    public void close() throws IOException {
        this.ras.close();
    }

    public void enable(boolean enable) {
        OnOffStore store = (OnOffStore)this.ras.getStore();
        store.enable(enable);
    }

    public Store getStore() {
        return this.ras.getStore();
    }

    public void mark(int readLimit) {
        this.ras.mark(readLimit);
    }

    public boolean markSupported() {
        return this.ras.markSupported();
    }

    public int read() throws IOException {
        return this.ras.read();
    }

    public int read(byte[] b) throws IOException {
        return this.ras.read(b);
    }

    public final int read(byte[] b, int off, int len) throws IOException {
        return this.ras.read(b, off, len);
    }

    public void reset() throws IOException {
        this.ras.reset();
    }

    public void resetToBeginning() throws IOException {
        this.ras.seek(0L);
    }

    public long skip(long n) throws IOException {
        return this.ras.skip(n);
    }
}

