/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt.base;

import com.gc.iotools.stream.is.SizeLimitInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import org.apache.commons.io.IOUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TestUtils {
    public static Map<String, byte[]> getBytesForFiles(String[] included, int nbytes, boolean includes) throws IOException {
        String[] goodFiles = includes ? TestUtils.listFilesIncludingExtension(included) : TestUtils.listFilesExcludingExtension(included);
        HashMap<String, byte[]> result = new HashMap<String, byte[]>();
        for (String fileName : goodFiles) {
            FileInputStream is = new FileInputStream(fileName);
            byte[] bytes = IOUtils.toByteArray((InputStream)new SizeLimitInputStream((InputStream)is, (long)nbytes));
            result.put(fileName, bytes);
        }
        return result;
    }

    public static String[] listFilesExcludingExtension(String[] forbidden) throws IOException {
        URL fileURL = TestUtils.class.getResource("/testFiles");
        String filePath = URLDecoder.decode(fileURL.getPath(), "UTF-8");
        File dir = new File(filePath);
        String[] files = dir.list();
        Vector<String> goodFiles = new Vector<String>();
        if (!filePath.endsWith(File.separator)) {
            filePath = filePath + File.separator;
        }
        for (String file : files) {
            boolean insert = true;
            for (String extForbidden : forbidden) {
                insert &= !file.endsWith(extForbidden);
            }
            if (!insert) continue;
            goodFiles.add(filePath + file);
        }
        return goodFiles.toArray(new String[goodFiles.size()]);
    }

    @Deprecated
    public static String[] listFilesIncludingExtension(String[] allowed) throws IOException {
        URL fileURL = TestUtils.class.getResource("/testFiles");
        String filePath = URLDecoder.decode(fileURL.getPath(), "UTF-8");
        File dir = new File(filePath);
        String[] files = dir.list();
        Vector<String> goodFiles = new Vector<String>();
        if (!filePath.endsWith(File.separator)) {
            filePath = filePath + File.separator;
        }
        for (String file : files) {
            for (String element : allowed) {
                if (!file.endsWith(element)) continue;
                goodFiles.add(filePath + file);
            }
        }
        return goodFiles.toArray(new String[goodFiles.size()]);
    }
}

