/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt.detect.wzf;

import com.gc.iotools.fmt.base.FormatEnum;
import com.gc.iotools.fmt.base.FormatId;
import com.gc.iotools.fmt.detect.wzf.DefiniteLengthModule;
import com.gc.iotools.fmt.detect.wzf.DetectMode;
import com.gc.iotools.fmt.detect.wzf.RegexpDetectorModule;
import com.gc.iotools.fmt.detect.wzf.StringDetectorModule;
import com.gc.iotools.fmt.detect.wzf.StringncDetectorModule;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefiniteModuleFactory {
    private static final String DEF_CONF = "deflen.properties";
    private final Class<?> enumClazz;
    private final DefiniteLengthModule[] modules;

    DefiniteModuleFactory() {
        this(DEF_CONF, FormatEnum.class);
    }

    DefiniteModuleFactory(String confFile, Class<?> enumClass) {
        this.enumClazz = enumClass == null ? FormatEnum.class : enumClass;
        String confFile1 = StringUtils.isBlank((String)confFile) ? DEF_CONF : confFile;
        InputStream istream = DefiniteModuleFactory.class.getResourceAsStream(confFile1);
        if (istream == null) {
            throw new IllegalArgumentException("Configuration file [" + confFile1 + "] not found");
        }
        LineNumberReader lnread = new LineNumberReader(new InputStreamReader(istream));
        ArrayList<DefiniteLengthModule> modulesColl = new ArrayList<DefiniteLengthModule>();
        int lineNumber = 0;
        try {
            String curLine;
            while ((curLine = lnread.readLine()) != null) {
                DefiniteLengthModule dm;
                if (curLine.startsWith("#") || !StringUtils.isNotBlank((String)curLine) || !curLine.contains("=") || (dm = this.getInstance(curLine, lineNumber = lnread.getLineNumber())) == null) continue;
                modulesColl.add(dm);
            }
            istream.close();
        }
        catch (IOException e) {
            throw new IllegalStateException("Problem reading configuration file[" + confFile + "] line[" + lineNumber + "]", e);
        }
        this.modules = modulesColl.toArray(new DefiniteLengthModule[0]);
    }

    private FormatId getFormatId(String enumName) {
        String version;
        FormatEnum fenum;
        if (enumName.contains(":")) {
            String[] parts = enumName.split(":");
            fenum = FormatEnum.getEnum(this.enumClazz, parts[0]);
            version = parts[1];
        } else {
            fenum = FormatEnum.getEnum(this.enumClazz, enumName);
            version = null;
        }
        FormatId result = fenum == null ? new FormatId(FormatEnum.UNLISTED, enumName) : new FormatId(fenum, version);
        return result;
    }

    private DefiniteLengthModule getInstance(String curLine, int lineNo) {
        DefiniteLengthModule result;
        String enumName = curLine.split("=")[0];
        FormatId fenum = this.getFormatId(enumName);
        String paramLine = curLine.substring(enumName.length() + 1, curLine.length());
        String method = paramLine.substring(0, paramLine.indexOf(58));
        DetectMode selectedMode = DetectMode.valueOf(method.toUpperCase());
        String params = curLine.substring(enumName.length() + method.length() + 2);
        switch (selectedMode) {
            case REGEXP: {
                result = new RegexpDetectorModule();
                break;
            }
            case STRING: {
                result = new StringDetectorModule();
                break;
            }
            case STRINGNC: {
                result = new StringncDetectorModule();
                break;
            }
            case CLASS: {
                result = this.instantiateClass(lineNo, params);
                break;
            }
            default: {
                throw new UnsupportedOperationException("mode [" + (Object)((Object)selectedMode) + "] not supported");
            }
        }
        result.init(fenum, params);
        return result;
    }

    private DefiniteLengthModule instantiateClass(int lineNo, String params) {
        DefiniteLengthModule result;
        try {
            Class<?> module = Class.forName(params);
            result = (DefiniteLengthModule)module.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Problem instantiating class [" + params + "] line[" + lineNo + "]", e);
        }
        return result;
    }

    DefiniteLengthModule[] getConfiguredModules() {
        return this.modules;
    }
}

