/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt.detect.wzf.custom;

import com.gc.iotools.fmt.base.FormatEnum;
import com.gc.iotools.fmt.base.FormatId;
import com.gc.iotools.fmt.detect.wzf.DefiniteLengthModule;
import com.gc.iotools.fmt.detect.wzf.custom.ASN1Reader;
import com.gc.iotools.fmt.detect.wzf.custom.FormatException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PKCS7Detector
implements DefiniteLengthModule {
    private static final Logger LOGGER = LoggerFactory.getLogger(PKCS7Detector.class);

    public boolean detect(byte[] readedBytes) {
        ByteArrayInputStream buffer = new ByteArrayInputStream(readedBytes);
        boolean result = false;
        try {
            ASN1Reader pkcsHdrRead = new ASN1Reader(buffer);
            pkcsHdrRead.check(PKCSObjectIdentifiers.signedData);
            result = true;
        }
        catch (FormatException e) {
            LOGGER.debug("PKCS7 not recognizedException (normal) [" + e.getMessage() + "]");
        }
        catch (IOException e) {
            LOGGER.warn("PKCS7 not recognized for an I/O exception", (Throwable)e);
        }
        catch (Throwable e) {
            LOGGER.warn("PKCS7 not recognized for unexpected exception.", e);
        }
        return result;
    }

    public FormatId getDetectedFormat() {
        return new FormatId(FormatEnum.PKCS7, null);
    }

    public int getDetectLength() {
        return 4096;
    }

    public void init(FormatId fenum, String param) {
    }
}

