/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.signatureFile;

import java.util.ArrayList;
import java.util.List;
import uk.gov.nationalarchives.droid.base.MessageDisplay;
import uk.gov.nationalarchives.droid.base.SimpleElement;

public class FileFormat
extends SimpleElement {
    int identifier;
    String name;
    String version;
    String PUID;
    List<Integer> internalSigIDs = new ArrayList<Integer>();
    List<String> extensions = new ArrayList<String>();
    List<Integer> hasPriorityOver = new ArrayList<Integer>();
    String mimeType;

    public String getExtension(int theIndex) {
        return this.extensions.get(theIndex);
    }

    public int getHasPriorityOver(int theIndex) {
        return this.hasPriorityOver.get(theIndex);
    }

    public int getID() {
        return this.identifier;
    }

    public int getInternalSignatureID(int theIndex) {
        return this.internalSigIDs.get(theIndex);
    }

    public String getMimeType() {
        return this.mimeType == null ? "" : this.mimeType;
    }

    public String getName() {
        return this.name;
    }

    public int getNumExtensions() {
        return this.extensions.size();
    }

    public int getNumHasPriorityOver() {
        return this.hasPriorityOver.size();
    }

    public int getNumInternalSignatures() {
        return this.internalSigIDs.size();
    }

    public String getPUID() {
        return this.PUID;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean hasMatchingExtension(String theExtension) {
        boolean matchingExtension = false;
        for (int iExtension = 0; iExtension < this.getNumExtensions(); ++iExtension) {
            if (!theExtension.equalsIgnoreCase(this.getExtension(iExtension))) continue;
            matchingExtension = true;
        }
        return matchingExtension;
    }

    public void setAttributeValue(String theName, String theValue) {
        if (theName.equals("ID")) {
            this.identifier = Integer.parseInt(theValue);
        } else if (theName.equals("Name")) {
            this.name = theValue;
        } else if (theName.equals("Version")) {
            this.version = theValue;
        } else if (theName.equals("PUID")) {
            this.PUID = theValue;
        } else if (theName.equals("MIMEType")) {
            this.mimeType = theValue;
        } else {
            MessageDisplay.unknownAttributeWarning(this.name, this.getElementName());
        }
    }

    public void setExtension(String theExtension) {
        this.extensions.add(theExtension);
    }

    public void setHasPriorityOverFileFormatID(String theID) {
        this.hasPriorityOver.add(Integer.parseInt(theID));
    }

    public void setInternalSignatureID(String theID) {
        this.internalSigIDs.add(Integer.parseInt(theID));
    }

    public void setMimeType(String mimeType) {
        this.mimeType = mimeType;
    }
}

