/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.signatureFile;

import java.util.ArrayList;
import java.util.List;
import uk.gov.nationalarchives.droid.base.MessageDisplay;
import uk.gov.nationalarchives.droid.base.SimpleElement;
import uk.gov.nationalarchives.droid.binFileReader.ByteReader;
import uk.gov.nationalarchives.droid.signatureFile.ByteSequence;
import uk.gov.nationalarchives.droid.signatureFile.FileFormat;
import uk.gov.nationalarchives.droid.signatureFile.SubSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InternalSignature
extends SimpleElement {
    private List<ByteSequence> byteSequences = new ArrayList<ByteSequence>();
    int intSigID;
    String specificity;
    List<FileFormat> fileFormatList = new ArrayList<FileFormat>();

    public void addByteSequence(ByteSequence byteSequence) {
        byteSequence.setParentSignature(this.intSigID);
        for (int i = 0; i < byteSequence.getNumSubSequences(); ++i) {
            SubSequence subSequence = byteSequence.getSubSequence(i);
            subSequence.setParentSignature(this.intSigID);
            subSequence.setReference(byteSequence.getReference());
            subSequence.setBigEndian(byteSequence.isBigEndian());
            subSequence.setByteSequence(byteSequence);
        }
        this.byteSequences.add(byteSequence);
    }

    public void addFileFormat(FileFormat theFileFormat) {
        this.fileFormatList.add(theFileFormat);
    }

    public ByteSequence getByteSequence(int theByteSeq) {
        return (ByteSequence)this.getByteSequences().get(theByteSeq);
    }

    public List getByteSequences() {
        return this.byteSequences;
    }

    public FileFormat getFileFormat(int theIndex) {
        return this.fileFormatList.get(theIndex);
    }

    public int getID() {
        return this.intSigID;
    }

    public int getNumByteSequences() {
        return this.byteSequences.size();
    }

    public int getNumFileFormats() {
        return this.fileFormatList.size();
    }

    public String getSpecificity() {
        return this.specificity;
    }

    public boolean isFileCompliant(ByteReader targetFile) {
        boolean isCompliant = true;
        for (int i = 0; i < this.byteSequences.size() && isCompliant; ++i) {
            isCompliant = this.getByteSequence(i).isFileCompliant(targetFile);
        }
        return isCompliant;
    }

    public boolean isSpecific() {
        return this.specificity.equalsIgnoreCase("specific");
    }

    public void resetByteSequences(List<ByteSequence> byteSequences) {
        this.byteSequences = byteSequences;
    }

    @Override
    public void setAttributeValue(String name, String value) {
        if (name.equals("ID")) {
            this.setID(value);
        } else if (name.equals("Specificity")) {
            this.setSpecificity(value);
        } else {
            MessageDisplay.unknownAttributeWarning(name, this.getElementName());
        }
    }

    public void setID(String theIntSigID) {
        this.intSigID = Integer.parseInt(theIntSigID);
    }

    public void setSpecificity(String Specificity) {
        this.specificity = Specificity;
    }

    public String toString() {
        return this.intSigID + "(" + this.specificity + ")" + this.byteSequences;
    }
}

