/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.xmlReader;

import java.lang.reflect.Method;
import java.util.Stack;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;
import uk.gov.nationalarchives.droid.base.MessageDisplay;
import uk.gov.nationalarchives.droid.base.SimpleElement;

public class SAXModelBuilder
extends DefaultHandler {
    Stack stack = new Stack();
    SimpleElement element;
    String myObjectPackage = "uk.gov.nationalarchives.droid.signatureFile";
    StringBuffer textBuffer;
    String namespace = "";
    boolean useNamespace = false;
    boolean allowGlobalNamespace = true;

    public void characters(char[] ch, int start, int len) {
        if (!this.stack.empty()) {
            String text = new String(ch, start, len);
            ((SimpleElement)this.stack.peek()).setText(text);
        }
    }

    public void endElement(String namespace, String localname, String qname) throws SAXException {
        String elementName = this.handleNameNS(namespace, localname, qname);
        if (elementName == null) {
            return;
        }
        this.element = (SimpleElement)this.stack.pop();
        this.element.completeElementContent();
        if (!this.stack.empty()) {
            try {
                this.setProperty(elementName, this.stack.peek(), this.element);
            }
            catch (SAXException e) {
                throw new SAXException(e);
            }
        }
    }

    public SimpleElement getModel() {
        return this.element;
    }

    public void setObjectPackage(String theObjectPackage) {
        this.myObjectPackage = theObjectPackage;
    }

    public void setupNamespace(String namespace, boolean allowGlobalNamespace) {
        if (namespace == null) {
            throw new IllegalArgumentException("Namespace cannot be null");
        }
        this.namespace = namespace;
        this.useNamespace = true;
        this.allowGlobalNamespace = allowGlobalNamespace;
    }

    public void startElement(String namespace, String localname, String qname, Attributes atts) throws SAXException {
        String elementName = this.handleNameNS(namespace, localname, qname);
        if (elementName == null) {
            return;
        }
        SimpleElement element = null;
        String className = this.myObjectPackage + "." + elementName;
        try {
            element = (SimpleElement)Class.forName(className).newInstance();
        }
        catch (Exception e) {
            // empty catch block
        }
        if (element == null) {
            element = new SimpleElement();
        }
        for (int i = 0; i < atts.getLength(); ++i) {
            String attributeName = this.handleNameNS(atts.getURI(i), atts.getLocalName(i), atts.getQName(i));
            if (attributeName == null) continue;
            element.setAttributeValue(attributeName, atts.getValue(i));
        }
        this.stack.push(element);
    }

    private String handleNameNS(String namespace, String localname, String qname) {
        if (this.useNamespace && this.namespace.equals(namespace)) {
            return localname;
        }
        if (this.allowGlobalNamespace && "".equals(namespace)) {
            return qname;
        }
        return null;
    }

    void setProperty(String name, Object target, Object value) throws SAXException {
        Method method = null;
        try {
            method = target.getClass().getMethod("add" + name, value.getClass());
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        if (method == null) {
            try {
                method = target.getClass().getMethod("set" + name, value.getClass());
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        if (method == null) {
            try {
                value = ((SimpleElement)value).getText();
                method = target.getClass().getMethod("add" + name, String.class);
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        try {
            if (method == null) {
                method = target.getClass().getMethod("set" + name, String.class);
            }
            method.invoke(target, value);
        }
        catch (NoSuchMethodException e) {
            MessageDisplay.unknownElementWarning(name, ((SimpleElement)target).getElementName());
        }
        catch (Exception e) {
            throw new SAXException(e);
        }
    }
}

