/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt;

import com.gc.iotools.fmt.ResettableStreamRASAdapter;
import com.gc.iotools.fmt.ResettableStreamWrapper;
import com.gc.iotools.fmt.base.Decoder;
import com.gc.iotools.fmt.base.DetectionLibrary;
import com.gc.iotools.fmt.base.FormatEnum;
import com.gc.iotools.fmt.base.FormatId;
import com.gc.iotools.fmt.base.ResettableInputStream;
import com.gc.iotools.fmt.detect.droid.DroidDetectorImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class DetectionStrategy {
    private static final Logger LOG = LoggerFactory.getLogger(DroidDetectorImpl.class);
    private final Decoder[] decoders;
    private FormatEnum[] enabledFormats;
    private final ResettableStreamRASAdapter internalStream;
    private final DetectionLibrary[] detectionLibraries;
    private int maxRecursion = 0;
    private IdentificationResult result;

    private static FormatId detectFormatStream(ResettableInputStream stream, DetectionLibrary[] detectors, FormatEnum[] enabledFormats) throws IOException {
        FormatId detected = new FormatId(FormatEnum.UNKNOWN, null);
        ArrayList<FormatEnum> toDetect = new ArrayList<FormatEnum>(Arrays.asList(enabledFormats));
        if (detectors != null) {
            for (int i = 0; i < detectors.length && FormatEnum.UNKNOWN.equals((Object)detected.format) && toDetect.size() > 0; ++i) {
                DetectionLibrary detectionLibrary = detectors[i];
                try {
                    if (DetectionStrategy.isDetectorNeeded(detectionLibrary, toDetect)) {
                        detected = detectionLibrary.detect(toDetect.toArray(new FormatEnum[0]), stream);
                        toDetect.removeAll(Arrays.asList(detectionLibrary.getDetectedFormats()));
                    }
                }
                catch (Exception e) {
                    LOG.warn("deterctor [" + detectionLibrary + "] threw exception", (Throwable)e);
                }
                stream.resetToBeginning();
            }
        }
        return detected;
    }

    private static Map<FormatEnum, Decoder> getDecodersMap(Decoder[] decoders) {
        HashMap<FormatEnum, Decoder> formatsMap = new HashMap<FormatEnum, Decoder>();
        if (decoders != null) {
            for (Decoder decoder : decoders) {
                formatsMap.put(decoder.getFormat(), decoder);
            }
        }
        return formatsMap;
    }

    private static boolean isDetectorNeeded(DetectionLibrary detect, Collection<FormatEnum> toDetect) {
        FormatEnum[] formats = detect.getDetectedFormats();
        boolean result = false;
        for (int i = 0; i < formats.length && !result; result |= toDetect.contains((Object)formats[i]), ++i) {
        }
        return result;
    }

    public DetectionStrategy(DetectionLibrary[] detectors, Decoder[] decoders, FormatEnum[] enabledFormats, ResettableStreamRASAdapter istream) {
        this.internalStream = istream;
        this.detectionLibraries = detectors;
        this.decoders = decoders;
        this.enabledFormats = enabledFormats;
    }

    public FormatId[] getFormats() throws IOException {
        this.checkInitialized();
        return this.result.formats;
    }

    public ResettableInputStream getStream() throws IOException {
        this.checkInitialized();
        return this.result.resettableIs;
    }

    public void setEnabledFormats(FormatEnum[] enabledFormats) {
        this.enabledFormats = enabledFormats;
        this.result = null;
    }

    public void setMaxRecursion(int maxRecursion) {
        if (this.maxRecursion != maxRecursion) {
            this.result = null;
        }
        this.maxRecursion = maxRecursion;
    }

    private void checkInitialized() throws IOException {
        if (this.result == null) {
            this.result = this.identify();
        }
    }

    private IdentificationResult identify() throws IOException {
        FormatId curFormat;
        ArrayList<FormatId> formats = new ArrayList<FormatId>();
        Map<FormatEnum, Decoder> decMap = DetectionStrategy.getDecodersMap(this.decoders);
        this.internalStream.enable(true);
        ResettableInputStream currentStream = this.internalStream;
        int recursionLevel = 0;
        do {
            curFormat = DetectionStrategy.detectFormatStream(currentStream, this.detectionLibraries, this.enabledFormats);
            if (!FormatEnum.UNKNOWN.equals((Object)curFormat.format) && decMap.containsKey((Object)curFormat.format)) {
                Decoder decoder = decMap.get((Object)curFormat.format);
                currentStream = new ResettableStreamWrapper(currentStream, decoder);
            }
            if (recursionLevel != 0 && FormatEnum.UNKNOWN.equals(curFormat)) continue;
            formats.add(curFormat);
        } while (decMap.containsKey((Object)curFormat.format) && ++recursionLevel <= this.maxRecursion);
        this.internalStream.enable(false);
        return new IdentificationResult(currentStream, formats.toArray(new FormatId[formats.size()]));
    }

    private class IdentificationResult {
        final ResettableInputStream resettableIs;
        final FormatId[] formats;

        IdentificationResult(ResettableInputStream resettableIs, FormatId[] formats) {
            this.resettableIs = resettableIs;
            this.formats = formats;
        }
    }
}

