/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt.detect.wzf;

import com.gc.iotools.fmt.base.DetectionLibrary;
import com.gc.iotools.fmt.base.FormatEnum;
import com.gc.iotools.fmt.base.FormatId;
import com.gc.iotools.fmt.base.ResettableInputStream;
import com.gc.iotools.fmt.detect.wzf.DefiniteLengthModule;
import com.gc.iotools.fmt.detect.wzf.DefiniteModuleFactory;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StreamDetectorImpl
implements DetectionLibrary {
    private final DefiniteLengthModule[] configuredModules;

    private static byte[] readBytesAndReset(InputStream input, int size) throws IOException {
        byte[] result;
        int pos;
        byte[] buffer = new byte[size];
        int n = 0;
        for (pos = 0; pos < size && -1 != (n = input.read(buffer, pos, size - pos)); pos += n) {
        }
        if (pos == size) {
            result = buffer;
        } else {
            result = new byte[pos];
            System.arraycopy(buffer, 0, result, 0, pos);
        }
        return result;
    }

    public StreamDetectorImpl() {
        this("deflen.properties", FormatEnum.class);
    }

    public StreamDetectorImpl(String confFile, Class<?> enumclass) {
        DefiniteModuleFactory dfmf = new DefiniteModuleFactory(confFile, enumclass);
        this.configuredModules = dfmf.getConfiguredModules();
    }

    public StreamDetectorImpl(DefiniteLengthModule[] configuredModules) {
        this.configuredModules = configuredModules;
    }

    @Override
    public FormatId detect(FormatEnum[] enabledFormats, ResettableInputStream stream) throws IOException {
        DefiniteLengthModule[] modules = this.getModulesForFormats(enabledFormats);
        int len = this.getDetectLength(enabledFormats);
        byte[] bytes = StreamDetectorImpl.readBytesAndReset(stream, len);
        return this.detectFormat(bytes, modules);
    }

    @Override
    public FormatEnum[] getDetectedFormats() {
        HashSet<FormatEnum> formats = new HashSet<FormatEnum>();
        for (DefiniteLengthModule module : this.configuredModules) {
            FormatId detectedFormat = module.getDetectedFormat();
            formats.add(detectedFormat.format);
        }
        return formats.toArray(new FormatEnum[formats.size()]);
    }

    public int getDetectLength(FormatEnum[] enabledFormats) {
        DefiniteLengthModule[] modules = this.getModulesForFormats(enabledFormats);
        int detectLen = -1;
        for (DefiniteLengthModule module : modules) {
            detectLen = Math.max(detectLen, module.getDetectLength());
        }
        return detectLen;
    }

    private FormatId detectFormat(byte[] bytes, DefiniteLengthModule[] modules) {
        FormatId detected = new FormatId(FormatEnum.UNKNOWN, null);
        if (bytes.length > 0) {
            for (int i = 0; i < modules.length && FormatEnum.UNKNOWN.equals((Object)detected.format); ++i) {
                DefiniteLengthModule module = modules[i];
                int detectLenght = module.getDetectLength();
                if (detectLenght <= 0) {
                    throw new IllegalStateException("Module [" + module.getDetectedFormat() + "] request a detect size of [" + detectLenght + "]");
                }
                int bytesToCopy = Math.min(detectLenght, bytes.length);
                byte[] splittedBytes = new byte[bytesToCopy];
                System.arraycopy(bytes, 0, splittedBytes, 0, bytesToCopy);
                boolean success = module.detect(splittedBytes);
                detected = success ? module.getDetectedFormat() : detected;
            }
        }
        return detected;
    }

    private DefiniteLengthModule[] getModulesForFormats(FormatEnum[] requestedFormats) {
        ArrayList<DefiniteLengthModule> modules = new ArrayList<DefiniteLengthModule>();
        List<FormatEnum> reqFormatList = Arrays.asList(requestedFormats);
        for (DefiniteLengthModule module : this.configuredModules) {
            if (!reqFormatList.contains((Object)module.getDetectedFormat().format)) continue;
            modules.add(module);
        }
        return modules.toArray(new DefiniteLengthModule[modules.size()]);
    }
}

