/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.fmt.detect.wzf;

import com.gc.iotools.fmt.base.FormatId;
import com.gc.iotools.fmt.detect.wzf.DefiniteLengthModule;
import com.gc.iotools.stream.utils.ArrayTools;
import java.util.Arrays;

public class StringDetectorModule
implements DefiniteLengthModule {
    private byte[] byteSequence = null;
    private int detectLength = -1;
    private FormatId detectedFormat;

    public boolean detect(byte[] readBytes) {
        boolean result = this.detectLength == this.byteSequence.length ? Arrays.equals(readBytes, this.byteSequence) : ArrayTools.indexOf((byte[])readBytes, (byte[])this.byteSequence) >= 0;
        return result;
    }

    public FormatId getDetectedFormat() {
        if (this.detectedFormat == null) {
            throw new IllegalStateException("getDetectFormat called before init");
        }
        return this.detectedFormat;
    }

    public int getDetectLength() {
        if (this.byteSequence == null) {
            throw new IllegalStateException("getDetectLength called before init");
        }
        return this.detectLength;
    }

    public void init(FormatId fenum, String param) {
        int sepPos = param.indexOf(58);
        this.byteSequence = param.substring(sepPos + 1).getBytes();
        if (sepPos > 0) {
            String detectLString = param.substring(0, sepPos);
            this.detectLength = Integer.parseInt(detectLString);
        }
        if (this.detectLength <= 0) {
            this.detectLength = this.byteSequence.length;
        }
        this.detectedFormat = fenum;
    }

    public String toString() {
        return "StringModule [" + this.detectedFormat + "] len[" + this.detectLength + "] str [" + new String(this.byteSequence) + "]";
    }
}

