/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.base;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MessageDisplay {
    public static String FILEEXTENSIONWARNING = "Possible file extension mismatch";
    public static String POSITIVEIDENTIFICATIONSTATUS = "Positively identified";
    public static String TENTATIVEIDENTIFICATIONSTATUS = "Tentatively identified";
    public static String UNIDENTIFIEDSTATUS = "Unable to identify";
    private static final Logger LOG = LoggerFactory.getLogger(MessageDisplay.class);

    public static void fatalError(String theWarning) {
        LOG.error(theWarning);
    }

    public static void generalError(String theWarning) throws Exception {
        String theMessage = "Error: " + theWarning;
        LOG.error(theMessage);
        throw new Exception(theWarning);
    }

    public static void generalInformation(String theMessage) {
        LOG.debug(theMessage);
    }

    public static void generalInformation(String theGUIMessage, String theCMDMessage) {
        LOG.debug(theCMDMessage);
    }

    public static void generalWarning(String theWarning) {
        String theMessage = "WARNING: " + theWarning.replaceFirst("java.lang.Exception: ", "");
        LOG.warn(theMessage);
    }

    public static void setStatusText(String theMessage) {
        LOG.info(theMessage);
    }

    public static void setStatusText(String theGUIMessage, String theCMDMessage) {
        LOG.info(theCMDMessage);
    }

    public static void unknownAttributeWarning(String unknownAttribute, String containerElement) {
        String theCMDMessage = "WARNING: Unknown XML attribute " + unknownAttribute + " found for " + containerElement + " ";
        LOG.warn(theCMDMessage);
    }

    public static void unknownElementWarning(String unknownElement, String containerElement) {
        String theCMDMessage = "WARNING: Unknown XML element " + unknownElement + " found under " + containerElement + " ";
        LOG.warn(theCMDMessage);
    }
}

