/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.binFileReader;

import com.gc.iotools.fmt.base.ResettableInputStream;
import java.io.IOException;
import java.io.InputStream;
import uk.gov.nationalarchives.droid.binFileReader.AbstractByteReader;
import uk.gov.nationalarchives.droid.binFileReader.IdentificationFile;

public final class RandomAccessByteReader
extends AbstractByteReader {
    private final ResettableInputStream ras;
    private long position = 0L;
    private final long len;
    private long fileMarker = 0L;

    private static long getSize(InputStream stream) throws IOException {
        long curPos = 0L;
        int readLen = 0;
        byte[] buf = new byte[8192];
        while (readLen >= 0) {
            readLen = stream.read(buf, 0, buf.length);
            if (readLen <= 0) continue;
            curPos += (long)readLen;
        }
        return curPos;
    }

    public RandomAccessByteReader(IdentificationFile theIDFile, ResettableInputStream stream) throws IOException {
        super(theIDFile);
        this.ras = stream;
        this.len = RandomAccessByteReader.getSize(stream);
        this.ras.resetToBeginning();
    }

    public void close() throws IOException {
        this.ras.close();
    }

    public byte[] getbuffer() {
        return null;
    }

    public byte getByte(long fileIndex) {
        byte result;
        if (fileIndex > this.len) {
            throw new ArrayIndexOutOfBoundsException("Read position[" + fileIndex + "] is above EOF");
        }
        try {
            this.seek(fileIndex);
            int res = this.ras.read();
            if (res < 0) {
                throw new ArrayIndexOutOfBoundsException("Read position[" + fileIndex + "] is above EOF");
            }
            result = (byte)res;
            ++this.position;
        }
        catch (IOException e) {
            throw new IllegalStateException("Read position[" + fileIndex + "] had exception.", e);
        }
        return result;
    }

    public long getFileMarker() {
        return this.fileMarker;
    }

    public long getNumBytes() {
        return this.len;
    }

    public void setFileMarker(long markerPosition) {
        this.fileMarker = markerPosition;
    }

    private void seek(long fileIndex) throws IOException {
        if (fileIndex > this.position) {
            this.ras.skip(fileIndex - this.position);
        } else if (fileIndex < this.position) {
            this.ras.resetToBeginning();
            if (fileIndex > 0L) {
                this.ras.skip(fileIndex);
            }
        }
        this.position = fileIndex;
    }
}

