/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.signatureFile;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import uk.gov.nationalarchives.droid.base.FileFormatHit;
import uk.gov.nationalarchives.droid.base.MessageDisplay;
import uk.gov.nationalarchives.droid.base.SimpleElement;
import uk.gov.nationalarchives.droid.binFileReader.ByteReader;
import uk.gov.nationalarchives.droid.signatureFile.ByteSequence;
import uk.gov.nationalarchives.droid.signatureFile.FileFormat;
import uk.gov.nationalarchives.droid.signatureFile.FileFormatCollection;
import uk.gov.nationalarchives.droid.signatureFile.InternalSignature;
import uk.gov.nationalarchives.droid.signatureFile.InternalSignatureCollection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FFSignatureFile
extends SimpleElement {
    private String version = "";
    private String dateCreated = "";
    private FileFormatCollection fFcollection;
    private InternalSignatureCollection intSigs;

    public FFSignatureFile() {
    }

    public FFSignatureFile(Collection<FileFormat> fcollection, Collection<InternalSignature> intSigs) {
        this.fFcollection = new FileFormatCollection();
        this.fFcollection.formats.addAll(fcollection);
        this.intSigs = new InternalSignatureCollection();
        this.intSigs.intSigs.addAll(intSigs);
    }

    public String getDateCreated() {
        return this.dateCreated;
    }

    public FileFormat getFileFormat(int theIndex) {
        return (FileFormat)this.fFcollection.getFileFormats().get(theIndex);
    }

    public InternalSignature getInternalSignature(int theIndex) {
        return this.intSigs.getInternalSignatures().get(theIndex);
    }

    public int getNumFileFormats() {
        return this.fFcollection.getFileFormats().size();
    }

    public int getNumInternalSignatures() {
        return this.intSigs.getInternalSignatures().size();
    }

    public List<InternalSignature> getSignatures() {
        return this.intSigs.getInternalSignatures();
    }

    public String getVersion() {
        return this.version;
    }

    public void prepareForUse() {
        this.setAllSignatureFileFormats();
        this.reorderAllSequenceFragments();
        this.reorderByteSequences();
    }

    public synchronized void runFileIdentification(ByteReader targetFile) {
        List<InternalSignature> signatureList = this.getSignatures();
        for (InternalSignature internalSig : signatureList) {
            if (!internalSig.isFileCompliant(targetFile)) continue;
            targetFile.setPositiveIdent();
            for (int i = 0; i < internalSig.getNumFileFormats(); ++i) {
                FileFormatHit fileHit = new FileFormatHit(internalSig.getFileFormat(i), 15, internalSig.isSpecific(), "");
                targetFile.addHit(fileHit);
            }
        }
        if (targetFile.getNumHits() > 1) {
            this.removeLowerPriorityHits(targetFile);
        }
        if (targetFile.getNumHits() == 0) {
            targetFile.setNoIdent();
        }
    }

    @Override
    public void setAttributeValue(String name, String value) {
        if (name.equals("Version")) {
            this.setVersion(value.trim());
        } else if (name.equals("DateCreated")) {
            this.setDateCreated(value);
        } else {
            MessageDisplay.unknownAttributeWarning(name, this.getElementName());
        }
    }

    public void setFileFormatCollection(FileFormatCollection coll) {
        this.fFcollection = coll;
    }

    public void setInternalSignatureCollection(InternalSignatureCollection col3) {
        this.intSigs = col3;
    }

    private void removeLowerPriorityHits(ByteReader targetFile) {
        int i;
        ArrayList<Integer> hitsToRemove = new ArrayList<Integer>();
        for (int i2 = 0; i2 < targetFile.getNumHits(); ++i2) {
            block1: for (int j = 0; j < targetFile.getHit(i2).getFileFormat().getNumHasPriorityOver(); ++j) {
                int formatID = targetFile.getHit(i2).getFileFormat().getHasPriorityOver(j);
                for (int k = 0; k < targetFile.getNumHits(); ++k) {
                    if (targetFile.getHit(k).getFileFormat().getID() != formatID) continue;
                    hitsToRemove.add(k);
                    continue block1;
                }
            }
        }
        int[] indexesOfHits = new int[hitsToRemove.size()];
        int numHitsToRemove = 0;
        for (i = 0; i < hitsToRemove.size(); ++i) {
            int indexOfHit = (Integer)hitsToRemove.get(i);
            for (int j = numHitsToRemove; j > 0 && indexesOfHits[j - 1] > indexOfHit; --j) {
                indexesOfHits[j] = indexesOfHits[j - 1];
            }
            indexesOfHits[j] = indexOfHit;
            ++numHitsToRemove;
        }
        for (i = indexesOfHits.length - 1; i >= 0; --i) {
            if (i == indexesOfHits.length - 1) {
                targetFile.removeHit(indexesOfHits[i]);
                continue;
            }
            if (indexesOfHits[i] == indexesOfHits[i + 1]) continue;
            targetFile.removeHit(indexesOfHits[i]);
        }
    }

    private void reorderAllSequenceFragments() {
        for (int iSig = 0; iSig < this.getNumInternalSignatures(); ++iSig) {
            for (int iBS = 0; iBS < this.getInternalSignature(iSig).getNumByteSequences(); ++iBS) {
                for (int iSS = 0; iSS < this.getInternalSignature(iSig).getByteSequence(iBS).getNumSubSequences(); ++iSS) {
                    this.getInternalSignature(iSig).getByteSequence(iBS).getSubSequence(iSS).prepareSeqFragments();
                }
            }
        }
    }

    private void reorderByteSequences() {
        for (int iSig = 0; iSig < this.getNumInternalSignatures(); ++iSig) {
            InternalSignature sig = this.getInternalSignature(iSig);
            ArrayList<ByteSequence> BOFoffsetByteSequences = new ArrayList<ByteSequence>();
            ArrayList<ByteSequence> EOFoffsetByteSequences = new ArrayList<ByteSequence>();
            ArrayList<ByteSequence> variableByteSequences = new ArrayList<ByteSequence>();
            for (int iBS = 0; iBS < sig.getNumByteSequences(); ++iBS) {
                ByteSequence seq = sig.getByteSequence(iBS);
                if (seq.getReference().startsWith("BOF")) {
                    BOFoffsetByteSequences.add(seq);
                }
                if (seq.getReference().startsWith("EOF")) {
                    EOFoffsetByteSequences.add(seq);
                    continue;
                }
                variableByteSequences.add(seq);
            }
            ArrayList<ByteSequence> byteSequences = new ArrayList<ByteSequence>();
            byteSequences.addAll(BOFoffsetByteSequences);
            byteSequences.addAll(EOFoffsetByteSequences);
            byteSequences.addAll(variableByteSequences);
            sig.resetByteSequences(byteSequences);
        }
    }

    private void setAllSignatureFileFormats() {
        for (int iFormat = 0; iFormat < this.getNumFileFormats(); ++iFormat) {
            block1: for (int iFileSig = 0; iFileSig < this.getFileFormat(iFormat).getNumInternalSignatures(); ++iFileSig) {
                int iFileSigID = this.getFileFormat(iFormat).getInternalSignatureID(iFileSig);
                for (int iIntSig = 0; iIntSig < this.getNumInternalSignatures(); ++iIntSig) {
                    if (this.getInternalSignature(iIntSig).getID() != iFileSigID) continue;
                    this.getInternalSignature(iIntSig).addFileFormat(this.getFileFormat(iFormat));
                    continue block1;
                }
            }
        }
    }

    private void setDateCreated(String dc) {
        this.dateCreated = dc;
    }

    private void setVersion(String vers) {
        this.version = vers;
    }
}

