/*
 * The National Archives 2005-2006.  All rights reserved.
 * See Licence.txt for full licence details.
 *
 * Developed by:
 * Tessella Support Services plc
 * 3 Vineyard Chambers
 * Abingdon, OX14 3PX
 * United Kingdom
 * http://www.tessella.com
 *
 * Tessella/NPD/4305
 * PRONOM 4
 *
 * $Id: AnalysisController.java,v 1.15 2006/03/13 15:15:25 linb Exp $
 *
 * $Logger: AnalysisController.java,v $
 * Revision 1.15  2006/03/13 15:15:25  linb
 * Changed copyright holder from Crown Copyright to The National Archives.
 * Added reference to licence.txt
 * Changed dates to 2005-2006
 *
 * Revision 1.14  2006/02/13 11:27:01  linb
 * - Correct spelling in error message
 * - Fix </Version> tag
 *
 * Revision 1.13  2006/02/09 15:31:23  linb
 * Updates to javadoc and code following the code review
 *
 * Revision 1.12  2006/02/09 13:15:46  linb
 * Removed un-used class fileReader
 *
 * Revision 1.11  2006/02/09 12:14:05  linb
 * Updated version number to 1.1
 * Changed some javadoc to allow it to be created cleanly
 *
 * Revision 1.10  2006/02/08 14:09:24  linb
 * - Updated namespaces to all point to nationalarchives.gov.uk
 *
 * Revision 1.9  2006/02/08 11:44:50  linb
 * - make saveConfiguration throw an IOException
 *
 * Revision 1.8  2006/02/07 17:16:22  linb
 * - Change fileReader to ByteReader in formal parameters of methods
 * - use new static constructors
 * - Add detection of if a filePath is a URL or not
 *
 * Revision 1.7  2006/02/07 10:52:34  linb
 * - Altered FileCollection input to be able to use elements (instead of attributes) for most of the data
 * - Altered output routine to do the same
 *
 * Revision 1.6  2006/01/31 16:47:29  linb
 * Added log messages that were missing due to the log keyword being added too late
 *
 * Revision 1.5  2006/01/31 16:21:20  linb
 * Removed the dollars from the log lines generated by the previous message, so as not to cause problems with subsequent commits
 *
 * Revision 1.4  2006/01/31 16:19:07  linb
 * Added Logger: and Id: tags to these files
 *
 * Revision 1.3  2006/01/31 16:11:37  linb
 * Add support for XML namespaces to:
 * 1) The reading of the config file, spec file and file-list file
 * 2) The writing of the config file and file-list file
 * - The namespaces still need to be set to their proper URIs (currently set to example.com...)
 * - Can still read in files without namespaces
 *
 * Revision 1.2  2006/01/31 12:00:37  linb
 * - Added new text field to option dialog for proxy setting
 * - Added new get/set methods to AnalysisController for proxy settings (from ConfigFile) *
 *
 * $History: AnalysisController.java $
 * 
 * *****************  Version 53  *****************
 * User: Walm         Date: 20/10/05   Time: 15:17
 * Updated in $/PRONOM4/FFIT_SOURCE
 * allow connection to web service through a proxy.  
 * Pass on proxy connection details to web service.
 * When web service connection fails, give an appropriate warning to the
 * user.
 * 
 * *****************  Version 52  *****************
 * User: Walm         Date: 7/06/05    Time: 12:29
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Control the writing to file list explicitly so that it is not done in
 * full in memory prior to writing out to file.
 *
 * *****************  Version 51  *****************
 * User: Walm         Date: 6/06/05    Time: 11:46
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Ensure XML files are saved in UTF8
 * Resolve JIRA bug PRON-15
 *
 * *****************  Version 50  *****************
 * User: Walm         Date: 17/05/05   Time: 12:50
 * Updated in $/PRONOM4/FFIT_SOURCE
 * update to version 1.0.7
 *
 * *****************  Version 49  *****************
 * User: Mals         Date: 12/05/05   Time: 12:39
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Updated Version number to V1.0.6
 *
 * *****************  Version 48  *****************
 * User: Walm         Date: 12/05/05   Time: 10:15
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Version number changed to 1.0.5
 *
 * *****************  Version 47  *****************
 * User: Walm         Date: 10/05/05   Time: 19:42
 * Updated in $/PRONOM4/FFIT_SOURCE
 * update release version
 *
 * *****************  Version 46  *****************
 * User: Walm         Date: 10/05/05   Time: 19:23
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Update default configuration values
 *
 * *****************  Version 45  *****************
 * User: Walm         Date: 10/05/05   Time: 19:20
 * Updated in $/PRONOM4/FFIT_SOURCE
 * show warning if web service fails to get signature file version
 *
 * *****************  Version 44  *****************
 * User: Mals         Date: 9/05/05    Time: 14:47
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Changed version number to V1.0.2
 *
 * *****************  Version 43  *****************
 * User: Walm         Date: 5/05/05    Time: 10:28
 * Updated in $/PRONOM4/FFIT_SOURCE
 * save to file at end of run is now incorporated into
 * setAnalysisComplete()
 *
 * *****************  Version 42  *****************
 * User: Mals         Date: 4/05/05    Time: 10:12
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Changed version number to V1.0.1
 *
 * *****************  Version 41  *****************
 * User: Walm         Date: 26/04/05   Time: 17:29
 * Updated in $/PRONOM4/FFIT_SOURCE
 * show different messages in GUI and on command line
 *
 * *****************  Version 40  *****************
 * User: Walm         Date: 25/04/05   Time: 16:33
 * Updated in $/PRONOM4/FFIT_SOURCE
 * added updateDateLastDownload to allow the configuration file to be
 * updated with a new DateLastDownload whenever the user checks for a
 * newer signature file (even if none is found)
 *
 * *****************  Version 39  *****************
 * User: Mals         Date: 20/04/05   Time: 12:16
 * Updated in $/PRONOM4/FFIT_SOURCE
 * +Saves date in XML in format yyyy-MM-ddTHH:mm:ss
 * +Displays all dates in format  dd-MMM-yyyy
 *
 * *****************  Version 38  *****************
 * User: Walm         Date: 19/04/05   Time: 18:25
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Update default configuration values to reflect name change from uk to
 * DROID. + Make code cope better with badly formed XML
 *
 * *****************  Version 37  *****************
 * User: Walm         Date: 19/04/05   Time: 15:35
 * Updated in $/PRONOM4/FFIT_SOURCE
 * bug correction: unable to save list to file if PUID is null
 *
 * *****************  Version 36  *****************
 * User: Mals         Date: 19/04/05   Time: 9:41
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Tessella Ref: NPD/4305/PR/IM/2005APR18/09:51:03
 * Issues
 * ----------
 * 36. wording of the Status and Warning texts should be amended in line
 * with that given in a previous email
 * (NPD/4305/CL/CSC/2005FEB17/16:34:13)
 *
 * +Any  to FFITVersion changed to DROIDVersion when writing XML file
 *
 *
 * *****************  Version 35  *****************
 * User: Mals         Date: 13/04/05   Time: 10:24
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Ref:Email from A.Brown NPD/4305/CL/CSC/2005APR12/13:11  File ID GUI
 * Export to CSV writes DROID Version instead of uk
 *
 * *****************  Version 34  *****************
 * User: Mals         Date: 7/04/05    Time: 16:39
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Add application version, signature file version and date to csv export
 *
 * *****************  Version 33  *****************
 * User: Walm         Date: 7/04/05    Time: 14:43
 * Updated in $/PRONOM4/FFIT_SOURCE
 * review headers
 *
 * *****************  Version 32  *****************
 * User: Walm         Date: 5/04/05    Time: 18:08
 * Updated in $/PRONOM4/FFIT_SOURCE
 * move signature file parser to FFSignatureFile
 *
 * *****************  Version 31  *****************
 * User: Walm         Date: 5/04/05    Time: 14:54
 * Updated in $/PRONOM4/FFIT_SOURCE
 * increase size of random access reader buffer
 *
 * *****************  Version 30  *****************
 * User: Walm         Date: 4/04/05    Time: 17:44
 * Updated in $/PRONOM4/FFIT_SOURCE
 * move saveConfig code to ConfigFile class
 *
 * *****************  Version 29  *****************
 * User: Mals         Date: 1/04/05    Time: 10:26
 * Updated in $/PRONOM4/FFIT_SOURCE
 * +When saving a file list(without results) make sure warnings are blank
 *
 * *****************  Version 28  *****************
 * User: Walm         Date: 31/03/05   Time: 15:25
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Add some constants for default configuration settings
 * + add option to not read in signature file when downloading it (used in
 * command line mode)
 * + add option to not save configuration settings when (used in command
 * line mode since this does not use a configuration file)
 *
 * *****************  Version 27  *****************
 * User: Mals         Date: 30/03/05   Time: 17:12
 * Updated in $/PRONOM4/FFIT_SOURCE
 * +Doesn't save identification status when saving a file list
 *
 * *****************  Version 26  *****************
 * User: Mals         Date: 30/03/05   Time: 16:41
 * Updated in $/PRONOM4/FFIT_SOURCE
 * +File list can be saved without saving the results
 *
 * *****************  Version 25  *****************
 * User: Mals         Date: 30/03/05   Time: 15:42
 * Updated in $/PRONOM4/FFIT_SOURCE
 * +Export to CSV
 * +return methods for config settings
 *
 * *****************  Version 24  *****************
 * User: Walm         Date: 30/03/05   Time: 9:34
 * Updated in $/PRONOM4/FFIT_SOURCE
 * download signature file and save config file
 *
 * *****************  Version 23  *****************
 * User: Walm         Date: 29/03/05   Time: 16:55
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Deal with errors in XML file definitions when reading them in
 *
 * *****************  Version 22  *****************
 * User: Walm         Date: 29/03/05   Time: 12:04
 * Updated in $/PRONOM4/FFIT_SOURCE
 * check that signature file in loaded file is identical to the current
 * one for the application
 *
 * *****************  Version 21  *****************
 * User: Walm         Date: 29/03/05   Time: 11:04
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Update the XML definition for the file hit collection file
 *
 * *****************  Version 20  *****************
 * User: Walm         Date: 24/03/05   Time: 11:18
 * Updated in $/PRONOM4/FFIT_SOURCE
 * reformat fileCollection file
 * + functionality to check the latest signature file version on PRONOM
 * web service
 *
 * *****************  Version 19  *****************
 * User: Mals         Date: 24/03/05   Time: 9:35
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Saving collection as XML adds hit file format information
 *
 * *****************  Version 18  *****************
 * User: Walm         Date: 18/03/05   Time: 12:41
 * Updated in $/PRONOM4/FFIT_SOURCE
 * make sure all if statements use curly brackets
 *
 * *****************  Version 17  *****************
 * User: Walm         Date: 17/03/05   Time: 17:41
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Add a constant for buffer size for reading random access files
 *
 * *****************  Version 16  *****************
 * User: Mals         Date: 16/03/05   Time: 16:31
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Added SaveFileList
 *
 * *****************  Version 15  *****************
 * User: Walm         Date: 16/03/05   Time: 10:29
 * Updated in $/PRONOM4/FFIT_SOURCE
 * AnalysisThread class now has access to AnalysisController and so can
 * call non-static methods
 *
 * *****************  Version 14  *****************
 * User: Walm         Date: 16/03/05   Time: 9:52
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Make static/non static methods more consistent.
 * The main method now either launches GUI or command line controller
 *
 * *****************  Version 13  *****************
 * User: Mals         Date: 15/03/05   Time: 15:14
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Added remove file by index method
 *
 * *****************  Version 12  *****************
 * User: Walm         Date: 15/03/05   Time: 10:54
 * Updated in $/PRONOM4/FFIT_SOURCE
 * reorder file classification constants (to help ordering by file status
 * in GUI)
 *
 * *****************  Version 11  *****************
 * User: Walm         Date: 14/03/05   Time: 17:31
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Ability to cancel an analysis part way through, and to query progress
 * more efficiently
 *
 * *****************  Version 10  *****************
 * User: Walm         Date: 14/03/05   Time: 15:58
 * Updated in $/PRONOM4/FFIT_SOURCE
 * undo some temporary debugging code
 *
 * *****************  Version 9  *****************
 * User: Walm         Date: 14/03/05   Time: 15:56
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Implements analysis in a separate thread
 *
 * *****************  Version 8  *****************
 * User: Mals         Date: 14/03/05   Time: 14:31
 * Updated in $/PRONOM4/FFIT_SOURCE
 * runFileIdentification accepts IdentificationFile parameter
 *
 * *****************  Version 7  *****************
 * User: Mals         Date: 14/03/05   Time: 14:01
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Launches GUI on startup
 *
 * *****************  Version 6  *****************
 * User: Mals         Date: 14/03/05   Time: 9:47
 * Updated in $/PRONOM4/FFIT_SOURCE
 * Launches GUI from main method
 */
package uk.gov.nationalarchives.droid.base;

/**
 * Controls the file format identification analysis On startup, it launches
 * either the command line or the GUI package. It then exposes the necessary
 * methods for running the file identification analysis.
 * 
 * @author Martin Waller
 * @version 1.1.0
 */
public class DroidConstants {
	// Application version
	public static final String DROID_VERSION = "3.0";

	// File classification constants
	public static final int FILE_CLASSIFICATION_POSITIVE = 1;
	public static final int FILE_CLASSIFICATION_TENTATIVE = 2;
	public static final int FILE_CLASSIFICATION_NOHIT = 3;
	public static final int FILE_CLASSIFICATION_ERROR = 4;
	public static final int FILE_CLASSIFICATION_NOTCLASSIFIED = 5;
	public static final String FILE_CLASSIFICATION_POSITIVE_TEXT = "Positive";
	public static final String FILE_CLASSIFICATION_TENTATIVE_TEXT = "Tentative";
	public static final String FILE_CLASSIFICATION_NOHIT_TEXT = "Not identified";
	public static final String FILE_CLASSIFICATION_ERROR_TEXT = "Error";
	public static final String FILE_CLASSIFICATION_NOTCLASSIFIED_TEXT = "Not yet run";

	// hit type constants
	public static final int HIT_TYPE_POSITIVE_SPECIFIC = 10;
	public static final int HIT_TYPE_POSITIVE_GENERIC = 11;
	public static final int HIT_TYPE_TENTATIVE = 12;
	public static final int HIT_TYPE_POSITIVE_GENERIC_OR_SPECIFIC = 15;
	public static final String HIT_TYPE_POSITIVE_SPECIFIC_TEXT = "Positive (Specific Format)";
	public static final String HIT_TYPE_POSITIVE_GENERIC_TEXT = "Positive (Generic Format)";
	public static final String HIT_TYPE_TENTATIVE_TEXT = "Tentative";
	public static final String HIT_TYPE_POSITIVE_GENERIC_OR_SPECIFIC_TEXT = "Positive";

	// Buffer size for reading random access files
	public static final int FILE_BUFFER_SIZE = 100000000;

	// default values
	public static final int CONFIG_DOWNLOAD_FREQ = 30;
	public static final String CONFIG_FILE_NAME = "DROID_config.xml";
	public static final String FILE_LIST_FILE_NAME = "DROID_filecollection.xml";
	public static final String PRONOM_WEB_SERVICE_URL = "http://www.nationalarchives.gov.uk/pronom/service.asmx";
	public static final String SIGNATURE_FILE_NAME = "DROID_SignatureFile.xml";
	public static final String PUID_RESOLUTION_URL = "http://www.nationalarchives.gov.uk/pronom/";
	public static final String BROWSER_PATH = "/usr/bin/firefox";
	public static final String LABEL_APPLICATION_VERSION = "DROIDVersion";
	public static final String LABEL_DATE_CREATED = "DateCreated";

	/**
	 * Date format to read/write dates to XML
	 */
	private static final String XML_DATE_FORMAT = "yyyy'-'MM'-'dd'T'HH:mm:ss";

	/**
	 * Date format to display dates in application
	 */
	private static final String DISPLAY_DATE_FORMAT = "dd'-'MMM'-'yyyy";

	/**
	 * Namespace for the xml file collection file
	 */
	public static final String FILE_COLLECTION_NS = "http://www.nationalarchives.gov.uk/pronom/FileCollection";
	/**
	 * Namespace for the xml configuration file
	 */
	public static final String CONFIG_FILE_NS = "http://www.nationalarchives.gov.uk/pronom/ConfigFile";
	/**
	 * Namespace for the xml file format signatures file
	 */
	public static final String SIGNATURE_FILE_NS = "http://www.nationalarchives.gov.uk/pronom/SignatureFile";

	// class variables:

}
