/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jsptest.compiler.api;

import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Properties;
import net.sf.jsptest.compiler.api.JspCompiler;
import org.apache.log4j.Logger;

public class JspCompilerFactory {
    private static final Logger log = Logger.getLogger((Class)JspCompilerFactory.class);
    private static final String RESOURCE_PATH = "jsptest.properties";
    private static final String CONFIGURATION_KEY = "jsptest.compiler.implementation";

    public static JspCompiler newInstance() {
        RuntimeException exception = new RuntimeException("No JSP compiler implementation configured: (configuration file jsptest.properties not found from class path.");
        try {
            JspCompilerFactory.printConfigurationFiles();
            Enumeration<URL> resources = JspCompilerFactory.getClassLoader().getResources(RESOURCE_PATH);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                if (resources.hasMoreElements() && resource.toString().indexOf("test-classes") != -1) {
                    log.debug((Object)("Ignoring " + resource + " because it's from 'test-classes' " + "and there's another matching resource available"));
                    continue;
                }
                try {
                    return JspCompilerFactory.loadCompilerFrom(resource);
                }
                catch (RuntimeException invalidConfig) {
                    exception = invalidConfig;
                }
                catch (Exception invalidConfig) {
                    exception = new RuntimeException(invalidConfig);
                }
            }
            throw exception;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static void printConfigurationFiles() throws Exception {
        Enumeration<URL> enumeration = JspCompilerFactory.getClassLoader().getResources(RESOURCE_PATH);
        ArrayList<URL> resources = new ArrayList<URL>();
        while (enumeration.hasMoreElements()) {
            resources.add(enumeration.nextElement());
        }
        log.debug((Object)("Found " + resources.size() + " resources matching '" + RESOURCE_PATH + "':"));
        Iterator i = resources.iterator();
        while (i.hasNext()) {
            log.debug((Object)("  " + (URL)i.next()));
        }
    }

    private static JspCompiler loadCompilerFrom(URL resource) throws Exception {
        Properties properties = new Properties();
        properties.load(resource.openStream());
        if (!properties.containsKey(CONFIGURATION_KEY)) {
            throw new RuntimeException("Property jsptest.compiler.implementation not found from " + resource);
        }
        String klass = properties.getProperty(CONFIGURATION_KEY);
        return (JspCompiler)Class.forName(klass).newInstance();
    }

    private static ClassLoader getClassLoader() {
        return Thread.currentThread().getContextClassLoader();
    }
}

