/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jstuff.xml.xjc;

import com.sun.codemodel.JFieldVar;
import com.sun.tools.xjc.Options;
import com.sun.tools.xjc.outline.ClassOutline;
import com.sun.tools.xjc.outline.Outline;
import net.sf.jstuff.core.logging.Logger;
import net.sf.jstuff.xml.xjc.AbstractPlugin;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

public class PrivateFieldsPlugin
extends AbstractPlugin {
    private static final Logger LOG = Logger.create();
    public static final String OPTION_NAME = "Xprivate-fields";

    public String getOptionName() {
        return OPTION_NAME;
    }

    public String getUsage() {
        return "  -Xprivate-fields    : Changes the field visibility from protected to private";
    }

    public boolean run(Outline model, Options options, ErrorHandler errorHandler) throws SAXException {
        for (ClassOutline classDef : model.getClasses()) {
            for (JFieldVar fieldDef : classDef.implClass.fields().values()) {
                if ((fieldDef.mods().getValue() & 0x10) != 0 || (fieldDef.mods().getValue() & 4) != 0) continue;
                LOG.info("Declaring [%s#%s] private.", (Object)classDef.implClass.name(), (Object)fieldDef.name());
                fieldDef.mods().setPrivate();
            }
        }
        return true;
    }
}

