/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400DataType;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400FileImpl;
import com.ibm.as400.access.AS400FileRecordDescriptionImplRemote;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.BinaryConverter;
import com.ibm.as400.access.ConverterImplRemote;
import com.ibm.as400.access.DDMRecordCache;
import com.ibm.as400.access.DDMS38OpenFeedback;
import com.ibm.as400.access.ExtendedIllegalArgumentException;
import com.ibm.as400.access.ExtendedIllegalStateException;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.KeyedFile;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.VariableLengthFieldDescription;
import java.io.IOException;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.text.Collator;
import java.util.Vector;

abstract class AS400FileImplBase
implements AS400FileImpl,
Cloneable {
    private static final String copyright = "Copyright (C) 1997-2004 International Business Machines Corporation and others.";
    boolean isNative_ = false;
    boolean discardReplys_ = false;
    ConverterImplRemote converter_;
    static final byte DATA_DTA_DTARCD = 0;
    static final byte DATA_NODTA_DTARCD = 1;
    static final byte OPER_GET = 1;
    static final byte OPER_GETD = 2;
    static final byte OPER_GETK = 3;
    static final byte OPER_PUTDR = 4;
    static final byte OPER_PUT = 5;
    static final byte OPER_UPDATE = 7;
    static final byte OPER_DELETE = 8;
    static final byte OPER_FEOD = 9;
    static final byte SHR_READ_NORM = 0;
    static final byte SHR_READ_NORM_RLS = 2;
    static final byte SHR_UPD_NORM = 3;
    static final byte SHR_READ_NOPOS = 16;
    static final byte SHR_READ_NOPOS_RLS = 18;
    static final byte SHR_UPD_NOPOS = 19;
    static final byte SHR_UPD_NORM_NW = 35;
    static final byte SHR_UPD_NOPOS_NW = 51;
    static final byte TYPE_GET_FIRST = 1;
    static final byte TYPE_GET_LAST = 2;
    static final byte TYPE_GET_NEXT = 3;
    static final byte TYPE_GET_PREV = 4;
    static final byte TYPE_GET_SAME = 33;
    static final byte TYPE_GETD_ABSRRN = 8;
    private static final int WDMHLIB = 72;
    private static final int WDMHMBR = 73;
    DDMS38OpenFeedback openFeedback_;
    static final String STR16 = "                ";
    static final String STR18 = "                  ";
    static final String STR44 = "                                            ";
    Vector explicitLocksObtained_ = new Vector(6);
    static Vector commitmentControlSystems_ = new Vector();
    static boolean nativeCommitmentControlStarted_ = false;
    AS400ImplRemote system_ = null;
    String name_ = null;
    RecordFormat recordFormat_ = null;
    String library_ = null;
    String file_ = null;
    String member_ = null;
    DDMRecordCache cache_ = new DDMRecordCache();
    boolean cacheRecords_ = false;
    RecordFormat[] rfCache_ = null;
    int commitLockLevel_ = -1;
    int blockingFactor_;
    boolean readNoUpdate_ = false;
    boolean ssp_ = false;
    int openType_ = -1;
    byte[] recordFormatCTLLName_ = null;
    private String recordFormatName_ = "";
    private boolean isKeyed_ = false;
    private static final int EQUAL = 1;
    private static final int LESS_THAN = 2;
    private static final int GREATER_THAN = 3;
    private static final int UNKNOWN = 4;
    private Collator collator_ = Collator.getInstance();

    AS400FileImplBase() {
    }

    public void doIt(String string, Class[] classArray, Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        try {
            AS400FileImplBase.invoke(this, string, classArray, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw AS400FileImplBase.rethrow(invocationTargetException);
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, exception.toString(), (Throwable)exception);
            }
            throw new InternalErrorException(4);
        }
    }

    public static InternalErrorException rethrow(InvocationTargetException invocationTargetException) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Throwable throwable = invocationTargetException.getTargetException();
        if (throwable instanceof AS400Exception) {
            throw (AS400Exception)throwable;
        }
        if (throwable instanceof InterruptedException) {
            throw (InterruptedException)throwable;
        }
        if (throwable instanceof AS400SecurityException) {
            throw (AS400SecurityException)throwable;
        }
        if (throwable instanceof IOException) {
            throw (IOException)throwable;
        }
        if (throwable instanceof RuntimeException) {
            throw (RuntimeException)throwable;
        }
        if (throwable instanceof Error) {
            throw (Error)throwable;
        }
        return new InternalErrorException(10);
    }

    public void doItNoExceptions(String string, Class[] classArray, Object[] objectArray) {
        try {
            AS400FileImplBase.invoke(this, string, classArray, objectArray);
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, exception.toString(), (Throwable)exception);
            }
            throw new InternalErrorException(4);
        }
    }

    public Record doItRecord(String string, Class[] classArray, Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        try {
            return (Record)AS400FileImplBase.invoke(this, string, classArray, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw AS400FileImplBase.rethrow(invocationTargetException);
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, exception.toString(), (Throwable)exception);
            }
            throw new InternalErrorException(4);
        }
    }

    public Record[] doItRecordArray(String string, Class[] classArray, Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        try {
            return (Record[])AS400FileImplBase.invoke(this, string, classArray, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw AS400FileImplBase.rethrow(invocationTargetException);
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, exception.toString(), (Throwable)exception);
            }
            throw new InternalErrorException(4);
        }
    }

    public RecordFormat doItRecordFormat(String string, Class[] classArray, Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        try {
            return (RecordFormat)AS400FileImplBase.invoke(this, string, classArray, objectArray);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw AS400FileImplBase.rethrow(invocationTargetException);
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, exception.toString(), (Throwable)exception);
            }
            throw new InternalErrorException(4);
        }
    }

    public int doItInt(String string) {
        try {
            return (Integer)AS400FileImplBase.invoke(this, string, new Class[0], new Object[0]);
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, exception.toString(), (Throwable)exception);
            }
            throw new InternalErrorException(4);
        }
    }

    public boolean doItBoolean(String string) {
        try {
            return (Boolean)AS400FileImplBase.invoke(this, string, new Class[0], new Object[0]);
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, exception.toString(), (Throwable)exception);
            }
            throw new InternalErrorException(4);
        }
    }

    public boolean doItBoolean(String string, Class[] classArray, Object[] objectArray) {
        try {
            return (Boolean)AS400FileImplBase.invoke(this, string, classArray, objectArray);
        }
        catch (Exception exception) {
            if (Trace.isTraceErrorOn()) {
                Trace.log(2, exception.toString(), (Throwable)exception);
            }
            throw new InternalErrorException(4);
        }
    }

    static Object invoke(Object object, String string, Class[] classArray, Object[] objectArray) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Method method = null;
        Class<?> clazz = object.getClass();
        NoSuchMethodException noSuchMethodException = null;
        while (clazz != null && method == null) {
            try {
                method = clazz.getMethod(string, classArray);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                try {
                    method = clazz.getDeclaredMethod(string, classArray);
                }
                catch (NoSuchMethodException noSuchMethodException3) {
                    noSuchMethodException = noSuchMethodException3;
                    clazz = clazz.getSuperclass();
                }
            }
        }
        if (method == null) {
            throw noSuchMethodException;
        }
        return method.invoke(object, objectArray);
    }

    public void setIsKeyed(boolean bl) {
        this.isKeyed_ = bl;
    }

    public boolean isReadNoUpdate() {
        return this.readNoUpdate_;
    }

    public void addPhysicalFileMember(String string, String string2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        StringBuffer stringBuffer = new StringBuffer("QSYS/ADDPFM FILE(");
        stringBuffer.append(this.library_);
        stringBuffer.append("/");
        stringBuffer.append(this.file_);
        stringBuffer.append(") MBR(");
        stringBuffer.append(string);
        stringBuffer.append(")  TEXT(");
        if (string2 == null) {
            stringBuffer.append("*BLANK");
            stringBuffer.append(")");
        } else if (string2.length() == 0 || string2.equalsIgnoreCase("*BLANK")) {
            stringBuffer.append("*BLANK");
            stringBuffer.append(")");
        } else {
            stringBuffer.append("'");
            stringBuffer.append(string2);
            stringBuffer.append("')");
        }
        AS400Message[] aS400MessageArray = this.execute(stringBuffer.toString());
        if (aS400MessageArray.length <= 0 || !aS400MessageArray[0].getID().equals("CPC7305")) {
            throw new AS400Exception(aS400MessageArray);
        }
    }

    private int compareKeys(Object[] objectArray, Object[] objectArray2) {
        if (objectArray.length > objectArray2.length) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(4, "compareKeys: Search key has too many fields.");
            }
            return 4;
        }
        int n = 1;
        for (int i = 0; i < objectArray.length && n == 1; ++i) {
            int n2;
            Object object;
            Object object2;
            if (objectArray[i] instanceof byte[] && objectArray2[i] instanceof byte[]) {
                object2 = (byte[])objectArray[i];
                object = (byte[])objectArray2[i];
                if (((byte[])object2).length < ((byte[])object).length) {
                    n = 2;
                    continue;
                }
                if (((Object)object2).length > ((Object)object).length) {
                    n = 3;
                    continue;
                }
                for (n2 = 0; n2 < ((Object)object2).length && n == 1; ++n2) {
                    if (object2[n2] < object[n2]) {
                        n = 2;
                        continue;
                    }
                    if (object2[n2] <= object[n2]) continue;
                    n = 3;
                }
                continue;
            }
            if (this.recordFormat_.getKeyFieldDescription(i) instanceof VariableLengthFieldDescription) {
                int n3;
                object2 = (String)objectArray[i];
                object = (String)objectArray2[i];
                n2 = object2.length();
                if (n2 < (n3 = object.length())) {
                    StringBuffer stringBuffer = new StringBuffer((String)object2);
                    for (int j = n2; j < n3; ++j) {
                        stringBuffer.append(" ");
                    }
                    object2 = stringBuffer.toString();
                } else if (n2 > n3) {
                    object2 = object2.substring(0, n3);
                }
                int n4 = this.collator_.compare((String)object2, (String)object);
                if (n4 > 0) {
                    n = 3;
                    continue;
                }
                if (n4 >= 0) continue;
                n = 2;
                continue;
            }
            if (objectArray[i] instanceof BigDecimal && objectArray2[i] instanceof BigDecimal) {
                object2 = (BigDecimal)objectArray[i];
                object = (BigDecimal)objectArray2[i];
                n2 = object2.compareTo((BigDecimal)object);
                if (n2 > 0) {
                    n = 3;
                    continue;
                }
                if (n2 >= 0) continue;
                n = 2;
                continue;
            }
            if (objectArray[i].equals(objectArray2[i])) continue;
            n = 4;
        }
        return n;
    }

    private int compareKeys(byte[] byArray, byte[] byArray2, int n) {
        int n2;
        if (byArray.length > byArray2.length) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(4, "compareKeys: Search key is too long.");
            }
            return 4;
        }
        if (n < 1 || n > this.recordFormat_.getNumberOfKeyFields()) {
            throw new ExtendedIllegalArgumentException("numberOfKeyFields", 2);
        }
        int n3 = 0;
        FieldDescription[] fieldDescriptionArray = this.recordFormat_.getKeyFieldDescriptions();
        for (n2 = 0; n2 < n; ++n2) {
            n3 += fieldDescriptionArray[n2].getDataType().getByteLength();
            if (!(fieldDescriptionArray[n2] instanceof VariableLengthFieldDescription) || !((VariableLengthFieldDescription)((Object)fieldDescriptionArray[n2])).isVariableLength()) continue;
            n3 += 2;
        }
        if (byArray.length != n3) {
            if (Trace.isTraceOn() && Trace.isTraceErrorOn()) {
                Trace.log(4, "compareKeys: Search key byte length is not valid.");
            }
            return 4;
        }
        for (n2 = 0; n2 < byArray.length; ++n2) {
            if (byArray[n2] < byArray2[n2]) {
                return 2;
            }
            if (byArray[n2] <= byArray2[n2]) continue;
            return 3;
        }
        return 1;
    }

    public int getBlockingFactor() {
        return this.blockingFactor_;
    }

    public int[] getExplicitLocks() {
        int[] nArray = new int[this.explicitLocksObtained_.size()];
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = (Integer)this.explicitLocksObtained_.elementAt(i);
        }
        return nArray;
    }

    public int getOpenType() {
        return this.openType_;
    }

    public void close() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.cacheRecords_ = false;
        this.cache_.setIsEmpty();
        this.blockingFactor_ = 0;
        this.openType_ = -1;
        this.commitLockLevel_ = this.isCommitmentControlStarted() ? 3 : -1;
    }

    public void setAll(AS400Impl aS400Impl, String string, RecordFormat recordFormat, boolean bl, boolean bl2, boolean bl3) throws IOException {
        this.setSystem(aS400Impl);
        this.setPath(string);
        this.setRecordFormat(recordFormat);
        this.setReadNoUpdate(bl);
        this.setIsKeyed(bl2);
        this.setSSPFile(bl3);
        this.setConverter();
    }

    public abstract void commit() throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public void commit(AS400Impl aS400Impl) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.isCommitmentControlStarted(aS400Impl)) {
            this.setSystem(aS400Impl);
            this.setConverter();
            this.commit();
        }
    }

    public void setConverter() throws IOException {
        this.converter_ = ConverterImplRemote.getConverter(this.system_.getCcsid(), this.system_);
    }

    public void setPath(String string) {
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        if (!qSYSObjectPathName.getObjectType().equals("FILE") && !qSYSObjectPathName.getObjectType().equals("MBR")) {
            throw new IllegalPathNameException(string, 1);
        }
        this.library_ = qSYSObjectPathName.getLibraryName();
        this.file_ = qSYSObjectPathName.getObjectName();
        this.member_ = qSYSObjectPathName.getObjectType().equals("FILE") ? "*FIRST" : (qSYSObjectPathName.getMemberName().equalsIgnoreCase("*FILE") ? this.file_ : qSYSObjectPathName.getMemberName());
        this.name_ = string;
        this.rfCache_ = null;
    }

    public void setReadNoUpdate(boolean bl) {
        this.readNoUpdate_ = bl;
    }

    public RecordFormat setRecordFormat(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.rfCache_ == null) {
            AS400FileRecordDescriptionImplRemote aS400FileRecordDescriptionImplRemote = new AS400FileRecordDescriptionImplRemote();
            aS400FileRecordDescriptionImplRemote.setPath(this.name_);
            aS400FileRecordDescriptionImplRemote.setSystem(this.system_);
            this.rfCache_ = aS400FileRecordDescriptionImplRemote.retrieveRecordFormat();
        }
        if (this.rfCache_.length <= n) {
            throw new ExtendedIllegalArgumentException("recordFormat (" + String.valueOf(n) + ") too large", 4);
        }
        return this.rfCache_[n];
    }

    public RecordFormat setRecordFormat(String string) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Serializable serializable;
        if (this.rfCache_ == null) {
            serializable = new AS400FileRecordDescriptionImplRemote();
            serializable.setPath(this.name_);
            serializable.setSystem(this.system_);
            this.rfCache_ = serializable.retrieveRecordFormat();
        }
        serializable = null;
        for (int i = 0; i < this.rfCache_.length; ++i) {
            if (!this.rfCache_[i].getName().equals(string)) continue;
            serializable = this.rfCache_[i];
        }
        if (serializable == null) {
            throw new ExtendedIllegalArgumentException("recordFormat (" + string + ") not found", 5);
        }
        return serializable;
    }

    public void setRecordFormat(RecordFormat recordFormat) throws IOException {
        if (recordFormat != null) {
            this.recordFormat_ = recordFormat;
            if (this.converter_ != null) {
                this.setConverter();
            }
            for (int i = 0; i < this.recordFormat_.getNumberOfFields(); ++i) {
                AS400DataType aS400DataType = this.recordFormat_.getFieldDescription((int)i).dataType_;
                if (aS400DataType.getInstanceType() != 9) continue;
                int n = ((AS400Text)aS400DataType).getCcsid();
                if (n != 65535) {
                    ((AS400Text)aS400DataType).setConverter(ConverterImplRemote.getConverter(n, this.system_));
                    continue;
                }
                ((AS400Text)aS400DataType).setConverter(this.converter_);
            }
        }
    }

    public void setSSPFile(boolean bl) {
        this.ssp_ = bl;
    }

    public void setSystem(AS400Impl aS400Impl) {
        this.system_ = (AS400ImplRemote)aS400Impl;
        this.rfCache_ = null;
    }

    public byte[] createUFCB(int n, int n2, String string, boolean bl) throws IOException {
        int n3;
        int n4;
        if (this.converter_ == null) {
            this.setConverter();
        }
        byte[] byArray = null;
        boolean bl2 = this.isCommitmentControlStarted();
        boolean bl3 = this.ssp_;
        byArray = bl3 ? (string.equalsIgnoreCase("SEQ") && n == 2 ? new byte[bl2 ? 93 : 90] : new byte[bl2 ? 96 : 93]) : (string.equalsIgnoreCase("SEQ") && n == 2 ? new byte[bl2 ? 109 : 106] : new byte[bl2 ? 112 : 109]);
        int n5 = n4 = bl ? 4099 : 4098;
        int n6 = n == 0 ? 0x20 | n4 : (n == 1 ? (bl3 ? 0x2C | n4 : 0x3C | n4) : (bl3 ? 0x18 | n4 : 0x10 | n4));
        this.converter_.stringToByteArray(this.file_, byArray, 0);
        for (n3 = this.file_.length(); n3 < 10; ++n3) {
            byArray[n3] = 64;
        }
        BinaryConverter.unsignedShortToByteArray(72, byArray, 10);
        this.converter_.stringToByteArray(this.library_, byArray, 12);
        for (n3 = this.library_.length(); n3 < 10; ++n3) {
            byArray[n3 + 12] = 64;
        }
        BinaryConverter.unsignedShortToByteArray(73, byArray, 22);
        this.converter_.stringToByteArray(this.member_, byArray, 24);
        for (n3 = this.member_.length(); n3 < 10; ++n3) {
            byArray[n3 + 24] = 64;
        }
        BinaryConverter.unsignedShortToByteArray(n6, byArray, 46);
        byArray[48] = -16;
        byArray[49] = -15;
        byArray[50] = -16;
        byArray[51] = -16;
        byArray[56] = 32;
        byArray[60] = bl3 && n == 2 ? 0 : 2;
        n3 = 80;
        BinaryConverter.unsignedShortToByteArray(6, byArray, n3);
        byArray[n3 + 2] = 0;
        n3 += 3;
        if (!string.equalsIgnoreCase("SEQ") || n != 2) {
            BinaryConverter.unsignedShortToByteArray(60, byArray, n3);
            byArray[n3 + 2] = string.equalsIgnoreCase("SEQ") ? -128 : (n == 2 ? -128 : 0);
            n3 += 3;
        }
        if (bl2) {
            BinaryConverter.unsignedShortToByteArray(59, byArray, n3);
            switch (this.commitLockLevel_) {
                case 3: {
                    byArray[n3 + 2] = 0;
                    break;
                }
                case 4: {
                    byArray[n3 + 2] = -128;
                    break;
                }
                case 1: {
                    byArray[n3 + 2] = -126;
                    break;
                }
                case 2: {
                    byArray[n3 + 2] = -122;
                    break;
                }
                case 0: {
                    byArray[n3 + 2] = -121;
                }
            }
            n3 += 3;
        }
        BinaryConverter.unsignedShortToByteArray(58, byArray, n3);
        if ((string.equalsIgnoreCase("SEQ") || string.equalsIgnoreCase("KEY")) && n != 1) {
            byArray[n3 + 2] = -64;
            BinaryConverter.unsignedShortToByteArray(n2, byArray, n3 + 3);
        } else {
            byArray[n3 + 2] = 64;
            BinaryConverter.unsignedShortToByteArray(n2, byArray, n3 + 3);
        }
        n3 += 5;
        if (!bl3) {
            BinaryConverter.unsignedShortToByteArray(9, byArray, n3);
            BinaryConverter.unsignedShortToByteArray(1, byArray, n3 + 2);
            BinaryConverter.unsignedShortToByteArray(1, byArray, n3 + 4);
            String string2 = this.recordFormat_.getName();
            if (string2.length() > 10) {
                string2 = string2.substring(0, 10);
            }
            this.converter_.stringToByteArray(string2, byArray, n3 + 6);
            for (int i = string2.length(); i < 10; ++i) {
                byArray[i + n3 + 6] = 64;
            }
            n3 += 16;
        }
        BinaryConverter.unsignedShortToByteArray(Short.MAX_VALUE, byArray, n3);
        return byArray;
    }

    public abstract void deleteCurrentRecord() throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public void deleteMember() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        AS400Message[] aS400MessageArray = this.execute("QSYS/RMVM FILE(" + this.library_ + "/" + this.file_ + ") MBR(" + this.member_ + ")");
        if (aS400MessageArray.length > 0 && aS400MessageArray[0].getID() != null) {
            if (!aS400MessageArray[0].getID().equals("CPC7309")) {
                throw new AS400Exception(aS400MessageArray);
            }
        } else {
            throw new InternalErrorException("No messages from server", 6);
        }
    }

    public void discardReplies() {
        this.discardReplys_ = true;
    }

    public void endCommitmentControl() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.endCommitmentControl(this.system_);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endCommitmentControl(AS400Impl aS400Impl) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Vector vector = commitmentControlSystems_;
        synchronized (vector) {
            if (this.isNative_ && nativeCommitmentControlStarted_ || commitmentControlSystems_.contains(aS400Impl)) {
                this.setSystem(aS400Impl);
                this.setConverter();
                AS400Message[] aS400MessageArray = this.execute("QSYS/ENDCMTCTL");
                if (aS400MessageArray.length > 0 && aS400MessageArray[0].getID() != null && !aS400MessageArray[0].getID().equals("CPI8351")) {
                    throw new AS400Exception(aS400MessageArray);
                }
                if (this.isNative_) {
                    nativeCommitmentControlStarted_ = false;
                } else {
                    commitmentControlSystems_.removeElement(this.system_);
                }
            }
        }
    }

    public void startCommitmentControl(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.startCommitmentControl(this.system_, n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startCommitmentControl(AS400Impl aS400Impl, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Vector vector = commitmentControlSystems_;
        synchronized (vector) {
            if (this.isNative_ && nativeCommitmentControlStarted_ || commitmentControlSystems_.contains(aS400Impl)) {
                throw new ExtendedIllegalStateException(1);
            }
            this.setSystem(aS400Impl);
            this.setConverter();
            StringBuffer stringBuffer = new StringBuffer("QSYS/STRCMTCTL LCKLVL(*");
            switch (n) {
                case 1: {
                    stringBuffer.append("CHG)");
                    break;
                }
                case 2: {
                    stringBuffer.append("CS)");
                    break;
                }
                case 0: {
                    stringBuffer.append("ALL)");
                    break;
                }
                default: {
                    throw new ExtendedIllegalArgumentException("commitLockLevel", 2);
                }
            }
            AS400Message[] aS400MessageArray = this.execute(stringBuffer.toString());
            if (aS400MessageArray.length > 0 && aS400MessageArray[0].getID() != null && !aS400MessageArray[0].getID().equals("CPI8351")) {
                throw new AS400Exception(aS400MessageArray);
            }
            if (this.isNative_) {
                nativeCommitmentControlStarted_ = true;
            } else if (!commitmentControlSystems_.contains(this.system_)) {
                commitmentControlSystems_.addElement(this.system_);
            }
        }
    }

    public synchronized void resetState() {
        this.cacheRecords_ = false;
        this.cache_.setIsEmpty();
        this.blockingFactor_ = 0;
        this.openType_ = -1;
        this.commitLockLevel_ = -1;
    }

    public void releaseExplicitLocks() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.explicitLocksObtained_.size() > 0) {
            StringBuffer stringBuffer = new StringBuffer("QSYS/DLCOBJ OBJ(");
            AS400Message[] aS400MessageArray = this.explicitLocksObtained_.elements();
            while (aS400MessageArray.hasMoreElements()) {
                stringBuffer.append("(");
                stringBuffer.append(this.library_);
                stringBuffer.append("/");
                stringBuffer.append(this.file_);
                stringBuffer.append(" *FILE ");
                switch ((Integer)aS400MessageArray.nextElement()) {
                    case 1: {
                        stringBuffer.append("*SHRNUP ");
                        break;
                    }
                    case 0: {
                        stringBuffer.append("*SHRRD ");
                        break;
                    }
                    case 4: 
                    case 5: {
                        stringBuffer.append("*EXCL ");
                        break;
                    }
                    case 3: {
                        stringBuffer.append("*EXCLRD ");
                        break;
                    }
                    case 2: {
                        stringBuffer.append("*SHRUPD ");
                        break;
                    }
                    default: {
                        throw new InternalErrorException(6);
                    }
                }
                stringBuffer.append(this.member_);
                stringBuffer.append(") ");
            }
            stringBuffer.append(")");
            aS400MessageArray = this.execute(stringBuffer.toString());
            if (aS400MessageArray.length > 0 && aS400MessageArray[0].getID() != null) {
                throw new AS400Exception(aS400MessageArray);
            }
            this.explicitLocksObtained_.removeAllElements();
        }
    }

    public abstract AS400Message[] execute(String var1) throws AS400SecurityException, InterruptedException, IOException;

    public int getCommitLockLevel() {
        return this.isCommitmentControlStarted() ? this.commitLockLevel_ : -1;
    }

    public boolean isCommitmentControlStarted() {
        if (this.isNative_) {
            return nativeCommitmentControlStarted_;
        }
        return commitmentControlSystems_.contains(this.system_);
    }

    public boolean isCommitmentControlStarted(AS400Impl aS400Impl) {
        if (this.isNative_) {
            return nativeCommitmentControlStarted_;
        }
        return commitmentControlSystems_.contains(aS400Impl);
    }

    public void create(int n, String string, String string2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        StringBuffer stringBuffer = new StringBuffer("QSYS/CRTPF FILE(");
        stringBuffer.append(this.library_);
        stringBuffer.append("/");
        stringBuffer.append(this.file_);
        stringBuffer.append(") RCDLEN(");
        stringBuffer.append(n);
        stringBuffer.append(") MBR(");
        stringBuffer.append(this.member_);
        stringBuffer.append(") TEXT(");
        if (string2 == null) {
            stringBuffer.append("*BLANK");
        } else if (string2.length() == 0 || string2.equalsIgnoreCase("*BLANK")) {
            stringBuffer.append("*BLANK");
        } else {
            stringBuffer.append("'");
            stringBuffer.append(string2);
            stringBuffer.append("'");
        }
        stringBuffer.append(") FILETYPE(");
        stringBuffer.append(string);
        stringBuffer.append(")");
        AS400Message[] aS400MessageArray = this.execute(stringBuffer.toString());
        if (aS400MessageArray.length <= 0 || !aS400MessageArray[0].getID().equals("CPC7301")) {
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public void create(String string, String string2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        if (!qSYSObjectPathName.getObjectType().equals("FILE") && !qSYSObjectPathName.getObjectType().equals("MBR")) {
            throw new IllegalPathNameException(string, 1);
        }
        StringBuffer stringBuffer = new StringBuffer("QSYS/CRTPF FILE(");
        stringBuffer.append(this.library_);
        stringBuffer.append("/");
        stringBuffer.append(this.file_);
        stringBuffer.append(") SRCFILE(");
        stringBuffer.append(qSYSObjectPathName.getLibraryName());
        stringBuffer.append("/");
        stringBuffer.append(qSYSObjectPathName.getObjectName());
        stringBuffer.append(") SRCMBR(");
        stringBuffer.append(qSYSObjectPathName.getMemberName());
        stringBuffer.append(") MBR(");
        stringBuffer.append(this.member_);
        stringBuffer.append(") TEXT(");
        if (string2 == null) {
            stringBuffer.append("*BLANK");
            stringBuffer.append(")");
        } else if (string2.length() == 0 || string2.equalsIgnoreCase("*BLANK")) {
            stringBuffer.append("*BLANK");
            stringBuffer.append(")");
        } else if (string2.equalsIgnoreCase("*SRCMBRTXT")) {
            stringBuffer.append(string2);
            stringBuffer.append(")");
        } else {
            stringBuffer.append("'");
            stringBuffer.append(string2);
            stringBuffer.append("')");
        }
        AS400Message[] aS400MessageArray = this.execute(stringBuffer.toString());
        if (aS400MessageArray.length <= 0 || !aS400MessageArray[0].getID().equals("CPC7301")) {
            throw new AS400Exception(aS400MessageArray);
        }
    }

    public abstract void createDDSSourceFile(RecordFormat var1, String var2, String var3, String var4, String var5, boolean var6, String var7, String var8) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public void delete() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        AS400Message[] aS400MessageArray = this.execute("QSYS/DLTF FILE(" + this.library_ + "/" + this.file_ + ")");
        if (aS400MessageArray.length > 0) {
            if (aS400MessageArray[0].getID() != null && !aS400MessageArray[0].getID().equals("CPC2191")) {
                throw new AS400Exception(aS400MessageArray);
            }
        } else {
            throw new InternalErrorException("No messages from server", 6);
        }
    }

    public void lock(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Integer n2 = new Integer(n);
        if (!this.explicitLocksObtained_.contains(n2)) {
            StringBuffer stringBuffer = new StringBuffer("QSYS/ALCOBJ OBJ((");
            stringBuffer.append(this.library_);
            stringBuffer.append("/");
            stringBuffer.append(this.file_);
            stringBuffer.append(" *FILE ");
            switch (n) {
                case 1: {
                    stringBuffer.append("*SHRNUP ");
                    break;
                }
                case 0: {
                    stringBuffer.append("*SHRRD ");
                    break;
                }
                case 4: 
                case 5: {
                    stringBuffer.append("*EXCL ");
                    break;
                }
                case 3: {
                    stringBuffer.append("*EXCLRD ");
                    break;
                }
                case 2: {
                    stringBuffer.append("*SHRUPD ");
                    break;
                }
                default: {
                    throw new InternalErrorException(6);
                }
            }
            stringBuffer.append(this.member_);
            stringBuffer.append("))");
            AS400Message[] aS400MessageArray = this.execute(stringBuffer.toString());
            if (aS400MessageArray.length > 0 && aS400MessageArray[0].getID() != null) {
                throw new AS400Exception(aS400MessageArray);
            }
            this.explicitLocksObtained_.addElement(n2);
        }
    }

    public abstract DDMS38OpenFeedback openFile(int var1, int var2, String var3) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public String[] openFile2(int n, int n2, int n3, String string) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        return this.openFile2(n, n2, n3, string.equals("key"));
    }

    public String[] openFile2(int n, int n2, int n3, boolean bl) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Object object;
        Object object2;
        this.commitLockLevel_ = this.isCommitmentControlStarted() ? n3 : -1;
        this.blockingFactor_ = n2;
        boolean bl2 = this.cacheRecords_ = this.blockingFactor_ > 1;
        if (!this.recordFormatName_.equals(this.recordFormat_.getName())) {
            this.recordFormatName_ = this.recordFormat_.getName();
            object2 = new StringBuffer(this.recordFormat_.getName());
            while (((StringBuffer)object2).length() < 10) {
                ((StringBuffer)object2).append(' ');
            }
            object = ConverterImplRemote.getConverter(this.system_.getCcsid(), this.system_);
            this.recordFormatCTLLName_ = ((ConverterImplRemote)object).stringToByteArray(((StringBuffer)object2).toString());
        }
        object2 = this.openFile(n, this.blockingFactor_, bl ? "key" : "seq");
        this.openType_ = n;
        object = new String[2];
        if (this.library_.charAt(0) == '*') {
            this.library_ = ((DDMS38OpenFeedback)object2).getLibraryName().trim();
            object[0] = this.library_;
        }
        if (this.member_.equalsIgnoreCase("*FIRST") || this.member_.equalsIgnoreCase("*LAST")) {
            this.member_ = ((DDMS38OpenFeedback)object2).getMemberName().trim();
            object[1] = this.member_;
        }
        return object;
    }

    public void positionCursor(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (!this.cache_.setPosition(n)) {
                this.positionCursorToIndex(n);
            }
        } else {
            this.positionCursorToIndex(n);
        }
    }

    public void positionCursor(Object[] objectArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(objectArray, n);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
    }

    public void positionCursor(byte[] byArray, int n, int n2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(byArray, n, n2);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
    }

    public void positionCursorAfter(Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(objectArray, KeyedFile.TYPE_TABLE[0]);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        this.positionCursorToNext();
    }

    public void positionCursorAfter(byte[] byArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(byArray, KeyedFile.TYPE_TABLE[0], n);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        this.positionCursorToNext();
    }

    public abstract void positionCursorAfterLast() throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record[] positionCursorAt(int var1) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public void positionCursorBefore(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.setPosition(n)) {
                if (!this.cache_.isBeginningOfCache()) {
                    this.cache_.setPositionPrevious();
                } else {
                    this.positionCursorToIndex(n);
                    this.positionCursorToPrevious();
                }
            } else {
                this.positionCursorToIndex(n);
                this.positionCursorToPrevious();
            }
        } else {
            this.positionCursorToIndex(n);
            this.positionCursorToPrevious();
        }
    }

    public void positionCursorBefore(Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(objectArray, KeyedFile.TYPE_TABLE[0]);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        try {
            this.positionCursorToPrevious();
        }
        catch (AS400Exception aS400Exception) {
            if (Trace.traceOn_) {
                Trace.log(4, "KeyedFile - Possible attempt to position by key before first record. Manually positioning cursor.", (Throwable)aS400Exception);
            }
            if (aS400Exception.getAS400Message().getID().equalsIgnoreCase("CPF5001")) {
                this.positionCursorBeforeFirst();
            }
            throw aS400Exception;
        }
    }

    public void positionCursorBefore(byte[] byArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(byArray, KeyedFile.TYPE_TABLE[0], n);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        try {
            this.positionCursorToPrevious();
        }
        catch (AS400Exception aS400Exception) {
            if (Trace.traceOn_) {
                Trace.log(4, "KeyedFile - Possible attempt to position by key before first record. Manually positioning cursor.", (Throwable)aS400Exception);
            }
            if (aS400Exception.getAS400Message().getID().equalsIgnoreCase("CPF5001")) {
                this.positionCursorBeforeFirst();
            }
            throw aS400Exception;
        }
    }

    public abstract void positionCursorBeforeFirst() throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public void positionCursorToFirst() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_ && this.cache_.containsFirstRecord()) {
            this.cache_.setPositionFirst();
        } else {
            if (this.cacheRecords_) {
                this.cache_.setIsEmpty();
            }
            this.positionCursorAt(1);
        }
    }

    public abstract Record positionCursorToIndex(int var1) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record positionCursorToKey(Object[] var1, int var2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record positionCursorToKey(byte[] var1, int var2, int var3) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public void positionCursorToLast() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_ && this.cache_.containsLastRecord()) {
            this.cache_.setPositionLast();
        } else {
            if (this.cacheRecords_) {
                this.cache_.setIsEmpty();
            }
            this.positionCursorAt(2);
        }
    }

    public void positionCursorToNext() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.isEmpty() || this.cache_.isEndOfCache() && this.cache_.currentDirection_ == 0) {
                this.cache_.refresh(this.positionCursorAt(3), 0, false, false);
            } else if (this.cache_.isEndOfCache() && this.cache_.currentDirection_ != 0) {
                this.refreshCache(null, 0, false, false);
            } else {
                if (Trace.isTraceOn()) {
                    Trace.log(3, "positionCursorToNext: positioning in cache.");
                }
                this.cache_.setPositionNext();
            }
        } else {
            this.positionCursorAt(3);
        }
    }

    public void positionCursorToPrevious() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.isEmpty() || this.cache_.isBeginningOfCache() && this.cache_.currentDirection_ == 1) {
                this.cache_.refresh(this.positionCursorAt(4), 1, false, false);
            } else if (this.cache_.isBeginningOfCache() && this.cache_.currentDirection_ != 1) {
                this.refreshCache(null, 1, false, false);
            } else {
                if (Trace.isTraceOn()) {
                    Trace.log(3, "positionCursorToPrev: positioning in cache.");
                }
                this.cache_.setPositionPrevious();
            }
        } else {
            this.positionCursorAt(4);
        }
    }

    public Record read() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record record = null;
        if (this.cacheRecords_) {
            record = this.cache_.getCurrent();
        }
        if (record == null) {
            record = this.readRecord(33);
        }
        return record;
    }

    public Record read(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record record = this.cache_.getRecord(n);
        if (record == null) {
            try {
                record = this.positionCursorToIndex(n);
                this.refreshCache(null, 0, false, false);
                this.cache_.add(record, false);
                this.cache_.setPositionFirst();
            }
            catch (AS400Exception aS400Exception) {
                String string = aS400Exception.getAS400Message().getID();
                if (string.equals("CPF5001") || string.equals("CPF5006")) {
                    return null;
                }
                throw aS400Exception;
            }
        }
        return record;
    }

    public abstract Record read(Object[] var1, int var2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record read(byte[] var1, int var2, int var3) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public Record readAfter(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.setPosition(n)) {
                if (!this.cache_.isEndOfCache()) {
                    return this.cache_.getNext();
                }
                this.positionCursorToIndex(n);
                return this.readNext();
            }
            this.cache_.setIsEmpty();
            this.positionCursorToIndex(n);
            return this.readNext();
        }
        this.positionCursorToIndex(n);
        return this.readNext();
    }

    public Record readAfter(Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(objectArray, KeyedFile.TYPE_TABLE[0]);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return this.readNext();
    }

    public Record readAfter(byte[] byArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        this.positionCursorToKey(byArray, KeyedFile.TYPE_TABLE[0], n);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return this.readNext();
    }

    public abstract Record[] readAll(String var1, int var2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public Record readBefore(int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.setPosition(n)) {
                if (!this.cache_.isBeginningOfCache()) {
                    return this.cache_.getPrevious();
                }
                this.positionCursorToIndex(n);
                return this.readPrevious();
            }
            this.cache_.setIsEmpty();
            this.positionCursorToIndex(n);
            return this.readPrevious();
        }
        this.positionCursorToIndex(n);
        return this.readPrevious();
    }

    public Record readBefore(Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record record = this.positionCursorToKey(objectArray, KeyedFile.TYPE_TABLE[0]);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return this.readPrevious();
    }

    public Record readBefore(byte[] byArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record record = this.positionCursorToKey(byArray, KeyedFile.TYPE_TABLE[0], n);
        if (this.cacheRecords_) {
            this.cache_.setIsEmpty();
        }
        return this.readPrevious();
    }

    public Record readFirst() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.containsFirstRecord()) {
                return this.cache_.getFirst();
            }
            this.cache_.setIsEmpty();
        }
        return this.readRecord(1);
    }

    public Record readLast() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            if (this.cache_.containsLastRecord()) {
                return this.cache_.getLast();
            }
            this.cache_.setIsEmpty();
        }
        return this.readRecord(2);
    }

    public Record readNext() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record record = null;
        if (this.cacheRecords_) {
            record = this.cache_.getNext();
            if (record == null) {
                if (Trace.isTraceOn()) {
                    Trace.log(3, "AS400FileImplBase.readNext(): cache_.getNext() returned null.");
                }
                this.refreshCache(null, 0, false, false);
                return this.cache_.getCurrent();
            }
            return record;
        }
        return this.readRecord(3);
    }

    public Record readNextEqual() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_ && !this.cache_.isEmpty()) {
            Record record = null;
            Record record2 = this.cache_.getCurrent();
            if (record2 != null) {
                Object[] objectArray = record2.getKeyFields();
                try {
                    record = this.readNext();
                    int n = 4;
                    if (record != null) {
                        n = this.compareKeys(objectArray, record.getKeyFields());
                    }
                    while (record != null && (n == 3 || n == 4)) {
                        record = this.readNext();
                        if (record == null) continue;
                        n = this.compareKeys(objectArray, record.getKeyFields());
                    }
                    if (n != 1) {
                        record = null;
                    }
                }
                catch (AS400Exception aS400Exception) {
                    if (aS400Exception.getAS400Message().getID().equals("CPF5025")) {
                        return null;
                    }
                    throw aS400Exception;
                }
                return record;
            }
        }
        Object[] objectArray = this.recordFormat_.getNewRecord().getKeyFields();
        return this.read(objectArray, 14);
    }

    public Record readNextEqual(Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record record = null;
        try {
            record = this.readNext();
            int n = 4;
            if (record != null) {
                n = this.compareKeys(objectArray, record.getKeyFields());
            }
            while (record != null && (n == 3 || n == 4)) {
                record = this.readNext();
                if (record == null) continue;
                n = this.compareKeys(objectArray, record.getKeyFields());
            }
            if (n != 1) {
                record = null;
            }
        }
        catch (AS400Exception aS400Exception) {
            if (aS400Exception.getAS400Message().getID().equals("CPF5025")) {
                return null;
            }
            throw aS400Exception;
        }
        return record;
    }

    public Record readNextEqual(byte[] byArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record record = null;
        try {
            record = this.readNext();
            int n2 = 4;
            if (record != null) {
                n2 = this.compareKeys(byArray, record.getKeyFieldsAsBytes(), n);
            }
            while (record != null && (n2 == 3 || n2 == 4)) {
                record = this.readNext();
                if (record == null) continue;
                n2 = this.compareKeys(byArray, record.getKeyFieldsAsBytes(), n);
            }
            if (n2 != 1) {
                record = null;
            }
        }
        catch (AS400Exception aS400Exception) {
            if (aS400Exception.getAS400Message().getID().equals("CPF5025")) {
                return null;
            }
            throw aS400Exception;
        }
        return record;
    }

    public Record readPrevious() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record record = null;
        if (this.cacheRecords_) {
            record = this.cache_.getPrevious();
            if (record == null) {
                if (Trace.isTraceOn()) {
                    Trace.log(3, "AS400FileImplBase.readPrevious(): cache returned null.");
                }
                this.refreshCache(null, 1, false, false);
                return this.cache_.getCurrent();
            }
            return record;
        }
        return this.readRecord(4);
    }

    public Record readPreviousEqual() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record record;
        if (this.cacheRecords_ && !this.cache_.isEmpty() && (record = this.cache_.getCurrent()) != null) {
            Record record2;
            Object[] objectArray = record.getKeyFields();
            try {
                record2 = this.readPrevious();
                int n = 4;
                if (record2 != null) {
                    n = this.compareKeys(objectArray, record2.getKeyFields());
                }
                while (record2 != null && (n == 2 || n == 4)) {
                    record2 = this.readPrevious();
                    if (record2 == null) continue;
                    n = this.compareKeys(objectArray, record2.getKeyFields());
                }
                if (n != 1) {
                    record2 = null;
                }
            }
            catch (AS400Exception aS400Exception) {
                if (aS400Exception.getAS400Message().getID().equals("CPF5025")) {
                    return null;
                }
                throw aS400Exception;
            }
            return record2;
        }
        Object[] objectArray = this.recordFormat_.getNewRecord().getKeyFields();
        return this.read(objectArray, 15);
    }

    public Record readPreviousEqual(Object[] objectArray) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record record = null;
        try {
            record = this.readPrevious();
            int n = 4;
            if (record != null) {
                n = this.compareKeys(objectArray, record.getKeyFields());
            }
            while (record != null && (n == 2 || n == 4)) {
                record = this.readPrevious();
                if (record == null) continue;
                n = this.compareKeys(objectArray, record.getKeyFields());
            }
            if (n != 1) {
                record = null;
            }
        }
        catch (AS400Exception aS400Exception) {
            if (aS400Exception.getAS400Message().getID().equals("CPF5025")) {
                return null;
            }
            throw aS400Exception;
        }
        return record;
    }

    public Record readPreviousEqual(byte[] byArray, int n) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        Record record = null;
        try {
            record = this.readPrevious();
            int n2 = 4;
            if (record != null) {
                n2 = this.compareKeys(byArray, record.getKeyFieldsAsBytes(), n);
            }
            while (record != null && (n2 == 2 || n2 == 4)) {
                record = this.readPrevious();
                if (record == null) continue;
                n2 = this.compareKeys(byArray, record.getKeyFieldsAsBytes(), n);
            }
            if (n2 != 1) {
                record = null;
            }
        }
        catch (AS400Exception aS400Exception) {
            if (aS400Exception.getAS400Message().getID().equals("CPF5025")) {
                return null;
            }
            throw aS400Exception;
        }
        return record;
    }

    public abstract Record readRecord(int var1) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract Record[] readRecords(int var1) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public void refreshCache(Record[] recordArray, int n, boolean bl, boolean bl2) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (Trace.isTraceOn()) {
            Trace.log(3, "AS400FileImplBase.refreshCache: refreshing cache," + String.valueOf(n));
        }
        Object var5_5 = null;
        if (this.cache_.currentDirection_ == n || this.cache_.isEmpty()) {
            this.cache_.setIsEmpty();
            if (recordArray == null) {
                recordArray = this.readRecords(n);
            }
            if (Trace.isTraceOn()) {
                Trace.log(3, "AS400FileImplBase.refreshCache(): cursors in synch.");
            }
            this.cache_.refresh(recordArray, n, bl, bl2);
        } else {
            int n2;
            int n3 = n2 = this.cache_.getCurrent() == null ? this.cache_.getNext().getRecordNumber() : this.cache_.getCurrent().getRecordNumber();
            if (Trace.isTraceOn()) {
                Trace.log(3, "AS400FileImplBase.refreshCache(): cursors not in synch.");
            }
            this.cache_.setIsEmpty();
            this.positionCursor(n2);
            if (recordArray == null) {
                recordArray = this.readRecords(n);
            }
            this.cache_.refresh(recordArray, n, bl, bl2);
        }
    }

    public void refreshRecordCache() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.cacheRecords_) {
            this.positionCursorBeforeFirst();
            this.cache_.currentDirection_ = 0;
            this.refreshCache(null, 0, true, false);
        }
    }

    public abstract void rollback() throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public void rollback(AS400Impl aS400Impl) throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        if (this.isCommitmentControlStarted(aS400Impl)) {
            this.setSystem(aS400Impl);
            this.setConverter();
            this.rollback();
        }
    }

    public abstract void update(Record var1) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;

    public abstract void write(Record[] var1) throws AS400Exception, AS400SecurityException, InterruptedException, IOException;
}

