/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.as400.access;

import com.ibm.as400.access.AS400Bin2;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Bin8;
import com.ibm.as400.access.AS400ByteArray;
import com.ibm.as400.access.AS400Exception;
import com.ibm.as400.access.AS400FileImplBase;
import com.ibm.as400.access.AS400FileRecordDescriptionImpl;
import com.ibm.as400.access.AS400Float4;
import com.ibm.as400.access.AS400Float8;
import com.ibm.as400.access.AS400Impl;
import com.ibm.as400.access.AS400ImplRemote;
import com.ibm.as400.access.AS400Message;
import com.ibm.as400.access.AS400PackedDecimal;
import com.ibm.as400.access.AS400SecurityException;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.AS400ZonedDecimal;
import com.ibm.as400.access.BinaryFieldDescription;
import com.ibm.as400.access.CharacterFieldDescription;
import com.ibm.as400.access.DBCSEitherFieldDescription;
import com.ibm.as400.access.DBCSGraphicFieldDescription;
import com.ibm.as400.access.DBCSOnlyFieldDescription;
import com.ibm.as400.access.DBCSOpenFieldDescription;
import com.ibm.as400.access.DateFieldDescription;
import com.ibm.as400.access.FieldDescription;
import com.ibm.as400.access.FloatFieldDescription;
import com.ibm.as400.access.HexFieldDescription;
import com.ibm.as400.access.IllegalPathNameException;
import com.ibm.as400.access.InternalErrorException;
import com.ibm.as400.access.PackedDecimalFieldDescription;
import com.ibm.as400.access.QSYSObjectPathName;
import com.ibm.as400.access.QWHDRFFDFormat;
import com.ibm.as400.access.QWHFDACPFormat;
import com.ibm.as400.access.Record;
import com.ibm.as400.access.RecordFormat;
import com.ibm.as400.access.SaveFileAttrFormat;
import com.ibm.as400.access.TimeFieldDescription;
import com.ibm.as400.access.TimestampFieldDescription;
import com.ibm.as400.access.Trace;
import com.ibm.as400.access.ZonedDecimalFieldDescription;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.util.Date;

class AS400FileRecordDescriptionImplRemote
implements AS400FileRecordDescriptionImpl,
Serializable {
    static final long serialVersionUID = 4L;
    private String file_ = "";
    private String library_ = "";
    private String member_ = "";
    private String name_ = "";
    private AS400FileImplBase theFile_ = null;
    private AS400ImplRemote system_ = null;
    private static Object lockJT4FFD_ = new Object();
    private static Object lockJT4FD_ = new Object();

    AS400FileRecordDescriptionImplRemote() {
    }

    void addFieldDescription(RecordFormat recordFormat, Record record) throws UnsupportedEncodingException {
        char c = ((String)record.getField("WHFLDT")).charAt(0);
        FieldDescription fieldDescription = null;
        String string = ((String)record.getField("WHFLDE")).trim();
        switch (c) {
            case 'A': {
                int n = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (n == 65535) {
                    n = this.system_.getCcsid();
                }
                fieldDescription = new CharacterFieldDescription(new AS400Text(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue(), n, this.system_), string);
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        ((CharacterFieldDescription)fieldDescription).setVARLEN(((BigDecimal)record.getField("WHALLC")).intValue());
                    } else {
                        ((CharacterFieldDescription)fieldDescription).setVariableLength(true);
                    }
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string2 = (String)record.getField("WHDFT");
                if (string2.indexOf("*NULL") != -1) {
                    ((CharacterFieldDescription)fieldDescription).setDFTNull();
                    break;
                }
                if (string2.indexOf("'") == -1) break;
                String string3 = string2.substring(string2.indexOf("'") + 1, string2.lastIndexOf("'"));
                ((CharacterFieldDescription)fieldDescription).setDFT(string3);
                break;
            }
            case 'B': {
                int n = ((BigDecimal)record.getField("WHFLDO")).intValue();
                if (n < 5) {
                    fieldDescription = new BinaryFieldDescription(new AS400Bin2(), string, string, n);
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                    String string4 = ((String)record.getField("WHDFT")).trim();
                    if (string4.charAt(0) == '+') {
                        string4 = string4.substring(1);
                    }
                    if (string4.indexOf("*NULL") != -1) {
                        ((BinaryFieldDescription)fieldDescription).setDFTNull();
                        break;
                    }
                    ((BinaryFieldDescription)fieldDescription).setDFT(new Short(string4));
                    break;
                }
                if (n < 10) {
                    fieldDescription = new BinaryFieldDescription(new AS400Bin4(), string, string, n);
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                    String string5 = ((String)record.getField("WHDFT")).trim();
                    if (string5.charAt(0) == '+') {
                        string5 = string5.substring(1);
                    }
                    if (string5.indexOf("*NULL") != -1) {
                        ((BinaryFieldDescription)fieldDescription).setDFTNull();
                        break;
                    }
                    ((BinaryFieldDescription)fieldDescription).setDFT(new Integer(string5));
                    break;
                }
                fieldDescription = new BinaryFieldDescription(new AS400Bin8(), string, string, n);
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string6 = ((String)record.getField("WHDFT")).trim();
                if (string6.charAt(0) == '+') {
                    string6 = string6.substring(1);
                }
                if (string6.indexOf("*NULL") != -1) {
                    ((BinaryFieldDescription)fieldDescription).setDFTNull();
                    break;
                }
                ((BinaryFieldDescription)fieldDescription).setDFT(new Long(string6));
                break;
            }
            case 'E': {
                int n = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (n == 65535) {
                    n = this.system_.getCcsid();
                }
                fieldDescription = new DBCSEitherFieldDescription(new AS400Text(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue(), n, this.system_), string);
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        ((DBCSEitherFieldDescription)fieldDescription).setVARLEN(((BigDecimal)record.getField("WHALLC")).intValue());
                    } else {
                        ((DBCSEitherFieldDescription)fieldDescription).setVariableLength(true);
                    }
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string7 = (String)record.getField("WHDFT");
                if (string7.indexOf("*NULL") != -1) {
                    ((DBCSEitherFieldDescription)fieldDescription).setDFTNull();
                    break;
                }
                if (string7.indexOf("'") == -1) break;
                String string8 = string7.substring(string7.indexOf("'") + 1, string7.lastIndexOf("'"));
                ((DBCSEitherFieldDescription)fieldDescription).setDFT(string8);
                break;
            }
            case 'F': {
                int n = ((BigDecimal)record.getField("WHFLDO")).intValue();
                int n2 = ((BigDecimal)record.getField("WHFLDP")).intValue();
                int n3 = ((BigDecimal)record.getField("WHFLDB")).intValue();
                if (n3 == 4) {
                    fieldDescription = new FloatFieldDescription(new AS400Float4(), string, string, n, n2);
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                    String string9 = ((String)record.getField("WHDFT")).trim();
                    if (string9.charAt(0) == '+') {
                        string9 = string9.substring(1);
                    }
                    if (string9.indexOf("*NULL") != -1) {
                        ((FloatFieldDescription)fieldDescription).setDFTNull();
                        break;
                    }
                    ((FloatFieldDescription)fieldDescription).setDFT(new Float(string9));
                    break;
                }
                if (n3 == 8) {
                    fieldDescription = new FloatFieldDescription(new AS400Float8(), string, string, n, n2);
                    ((FloatFieldDescription)fieldDescription).setFLTPCN("*DOUBLE");
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                    String string10 = ((String)record.getField("WHDFT")).trim();
                    if (string10.charAt(0) == '+') {
                        string10 = string10.substring(1);
                    }
                    if (string10.indexOf("*NULL") != -1) {
                        ((FloatFieldDescription)fieldDescription).setDFTNull();
                        break;
                    }
                    ((FloatFieldDescription)fieldDescription).setDFT(new Double(string10));
                    break;
                }
                throw new InternalErrorException("FloatFieldDescription error in byte length", 6);
            }
            case 'G': {
                int n = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (n == 65535) {
                    n = this.system_.getCcsid();
                }
                fieldDescription = new DBCSGraphicFieldDescription(new AS400Text(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue(), n, this.system_), string);
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        ((DBCSGraphicFieldDescription)fieldDescription).setVARLEN(((BigDecimal)record.getField("WHALLC")).intValue());
                    } else {
                        ((DBCSGraphicFieldDescription)fieldDescription).setVariableLength(true);
                    }
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string11 = (String)record.getField("WHDFT");
                if (string11.indexOf("*NULL") != -1) {
                    ((DBCSGraphicFieldDescription)fieldDescription).setDFTNull();
                    break;
                }
                if (string11.indexOf("'") == -1) break;
                String string12 = string11.substring(string11.indexOf("'") + 1, string11.lastIndexOf("'"));
                ((DBCSGraphicFieldDescription)fieldDescription).setDFT(string12);
                break;
            }
            case 'H': {
                fieldDescription = new HexFieldDescription(new AS400ByteArray(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue()), string);
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        ((HexFieldDescription)fieldDescription).setVARLEN(((BigDecimal)record.getField("WHALLC")).intValue());
                    } else {
                        ((HexFieldDescription)fieldDescription).setVariableLength(true);
                    }
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string13 = (String)record.getField("WHDFT");
                if (string13.indexOf("*NULL") != -1) {
                    ((HexFieldDescription)fieldDescription).setDFTNull();
                    break;
                }
                if (string13.indexOf("'") == -1) break;
                String string14 = string13.substring(string13.indexOf("'") + 1, string13.lastIndexOf("'"));
                byte[] byArray = string14.getBytes();
                ((HexFieldDescription)fieldDescription).setDFT(byArray);
                break;
            }
            case 'J': {
                int n = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (n == 65535) {
                    n = this.system_.getCcsid();
                }
                fieldDescription = new DBCSOnlyFieldDescription(new AS400Text(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue(), n, this.system_), string);
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        ((DBCSOnlyFieldDescription)fieldDescription).setVARLEN(((BigDecimal)record.getField("WHALLC")).intValue());
                    } else {
                        ((DBCSOnlyFieldDescription)fieldDescription).setVariableLength(true);
                    }
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string15 = (String)record.getField("WHDFT");
                if (string15.indexOf("*NULL") != -1) {
                    ((DBCSOnlyFieldDescription)fieldDescription).setDFTNull();
                    break;
                }
                if (string15.indexOf("'") == -1) break;
                String string16 = string15.substring(string15.indexOf("'") + 1, string15.lastIndexOf("'"));
                ((DBCSOnlyFieldDescription)fieldDescription).setDFT(string16);
                break;
            }
            case 'L': {
                int n = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (n == 65535) {
                    n = this.system_.getCcsid();
                }
                fieldDescription = new DateFieldDescription(new AS400Text(((BigDecimal)record.getField("WHFLDB")).intValue(), n, this.system_), string);
                ((DateFieldDescription)fieldDescription).setDATFMT((String)record.getField("WHFMT"));
                if (!((String)record.getField("WHFMT")).equals(" ")) {
                    ((DateFieldDescription)fieldDescription).setDATSEP((String)record.getField("WHSEP"));
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string17 = (String)record.getField("WHDFT");
                if (string17.indexOf("*NULL") != -1) {
                    ((DateFieldDescription)fieldDescription).setDFTNull();
                    break;
                }
                if (string17.indexOf("CURRENT_DATE") != -1) {
                    ((DateFieldDescription)fieldDescription).setDFTCurrent();
                    break;
                }
                if (string17.indexOf("'") == -1) break;
                String string18 = string17.substring(string17.indexOf("'") + 1, string17.lastIndexOf("'"));
                ((DateFieldDescription)fieldDescription).setDFT(string18);
                break;
            }
            case 'O': {
                int n = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (n == 65535) {
                    n = this.system_.getCcsid();
                }
                fieldDescription = new DBCSOpenFieldDescription(new AS400Text(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue(), n, this.system_), string);
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        ((DBCSOpenFieldDescription)fieldDescription).setVARLEN(((BigDecimal)record.getField("WHALLC")).intValue());
                    } else {
                        ((DBCSOpenFieldDescription)fieldDescription).setVariableLength(true);
                    }
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string19 = (String)record.getField("WHDFT");
                if (string19.indexOf("*NULL") != -1) {
                    ((DBCSOpenFieldDescription)fieldDescription).setDFTNull();
                    break;
                }
                if (string19.indexOf("'") == -1) break;
                String string20 = string19.substring(string19.indexOf("'") + 1, string19.lastIndexOf("'"));
                ((DBCSOpenFieldDescription)fieldDescription).setDFT(string20);
                break;
            }
            case 'P': {
                int n = ((BigDecimal)record.getField("WHFLDO")).intValue();
                int n4 = ((BigDecimal)record.getField("WHFLDP")).intValue();
                fieldDescription = new PackedDecimalFieldDescription(new AS400PackedDecimal(n, n4), string);
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string21 = ((String)record.getField("WHDFT")).trim();
                if (string21.charAt(0) == '+') {
                    string21 = string21.substring(1);
                }
                if (string21.indexOf("*NULL") != -1) {
                    ((PackedDecimalFieldDescription)fieldDescription).setDFTNull();
                    break;
                }
                ((PackedDecimalFieldDescription)fieldDescription).setDFT(new BigDecimal(string21));
                break;
            }
            case 'S': {
                int n = ((BigDecimal)record.getField("WHFLDO")).intValue();
                int n5 = ((BigDecimal)record.getField("WHFLDP")).intValue();
                fieldDescription = new ZonedDecimalFieldDescription(new AS400ZonedDecimal(n, n5), string);
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string22 = ((String)record.getField("WHDFT")).trim();
                if (string22.charAt(0) == '+') {
                    string22 = string22.substring(1);
                }
                if (string22.indexOf("*NULL") != -1) {
                    ((ZonedDecimalFieldDescription)fieldDescription).setDFTNull();
                    break;
                }
                ((ZonedDecimalFieldDescription)fieldDescription).setDFT(new BigDecimal(string22));
                break;
            }
            case 'T': {
                int n = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (n == 65535) {
                    n = this.system_.getCcsid();
                }
                fieldDescription = new TimeFieldDescription(new AS400Text(((BigDecimal)record.getField("WHFLDB")).intValue(), n, this.system_), string);
                ((TimeFieldDescription)fieldDescription).setTIMFMT((String)record.getField("WHFMT"));
                if (!((String)record.getField("WHSEP")).equals(" ")) {
                    ((TimeFieldDescription)fieldDescription).setTIMSEP((String)record.getField("WHSEP"));
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string23 = (String)record.getField("WHDFT");
                if (string23.indexOf("*NULL") != -1) {
                    ((TimeFieldDescription)fieldDescription).setDFTNull();
                    break;
                }
                if (string23.indexOf("CURRENT_TIME") != -1) {
                    ((TimeFieldDescription)fieldDescription).setDFTCurrent();
                    break;
                }
                if (string23.indexOf("'") == -1) break;
                String string24 = string23.substring(string23.indexOf("'") + 1, string23.lastIndexOf("'"));
                ((TimeFieldDescription)fieldDescription).setDFT(string24);
                break;
            }
            case 'Z': {
                int n = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (n == 65535) {
                    n = this.system_.getCcsid();
                }
                fieldDescription = new TimestampFieldDescription(new AS400Text(((BigDecimal)record.getField("WHFLDB")).intValue(), n, this.system_), string);
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string25 = (String)record.getField("WHDFT");
                if (string25.indexOf("*NULL") != -1) {
                    ((TimestampFieldDescription)fieldDescription).setDFTNull();
                    break;
                }
                if (string25.indexOf("CURRENT_TIMESTAMP") != -1) {
                    ((TimestampFieldDescription)fieldDescription).setDFTCurrent();
                    break;
                }
                if (string25.indexOf("'") == -1) break;
                String string26 = string25.substring(string25.indexOf("'") + 1, string25.lastIndexOf("'"));
                ((TimestampFieldDescription)fieldDescription).setDFT(string26);
            }
        }
        if (((String)record.getField("WHNULL")).equals("Y")) {
            fieldDescription.setALWNULL(true);
        }
        recordFormat.addFieldDescription(fieldDescription);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] createRecordFormatSource(String string) throws AS400Exception, AS400SecurityException, IOException, InterruptedException {
        String string2 = "DSPFFD FILE(" + this.library_ + "/" + this.file_ + ") OUTPUT(*OUTFILE) OUTFILE(QTEMP/JT4FFD)";
        Record[] recordArray = null;
        Record[] recordArray2 = lockJT4FFD_;
        synchronized (lockJT4FFD_) {
            Object object = this.theFile_.execute(string2);
            if (((AS400Message[])object).length > 0) {
                if (!object[0].getID().equals("CPF9861") && !object[0].getID().equals("CPF3030")) {
                    throw new AS400Exception((AS400Message[])object);
                }
            } else {
                throw new InternalErrorException("DSPFFD failed to return success message", 6);
            }
            AS400Message[] aS400MessageArray = (AS400Message[])this.system_.loadImpl("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote");
            aS400MessageArray.setAll(this.system_, "/QSYS.LIB/QTEMP.LIB/JT4FFD.FILE", new QWHDRFFDFormat(this.system_.getCcsid()), false, false, false);
            recordArray = aS400MessageArray.readAll("seq", 100);
            aS400MessageArray.delete();
            // ** MonitorExit[var4_4] (shouldn't be in output)
            string2 = "DSPFD FILE(" + this.library_ + "/" + this.file_ + ") TYPE(*ACCPTH) OUTPUT(*OUTFILE) OUTFILE(QTEMP/JT4FD)";
            recordArray2 = null;
            object = lockJT4FD_;
            synchronized (object) {
                aS400MessageArray = this.theFile_.execute(string2);
                if (aS400MessageArray.length > 0) {
                    if (!aS400MessageArray[0].getID().equals("CPF9861") && !aS400MessageArray[0].getID().equals("CPF3030")) {
                        throw new AS400Exception(aS400MessageArray);
                    }
                } else {
                    throw new InternalErrorException("DSPFD failed to return success message", 6);
                }
                AS400FileImplBase aS400FileImplBase = (AS400FileImplBase)this.system_.loadImpl("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote");
                aS400FileImplBase.setAll(this.system_, "/QSYS.LIB/QTEMP.LIB/JT4FD.FILE", new QWHFDACPFormat(this.system_.getCcsid()), false, false, false);
                recordArray2 = aS400FileImplBase.readAll("key", 100);
                aS400FileImplBase.delete();
            }
            int n = ((BigDecimal)recordArray[0].getField("WHCNT")).intValue();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            String[] stringArray = new String[n * 2];
            for (int i = 0; i < n; ++i) {
                int n6;
                String string3 = (String)recordArray[n4].getField("WHNAME");
                String string4 = string3.replace('\"', ' ').trim();
                stringArray[i] = string4 + "Format.java";
                StringWriter stringWriter = new StringWriter();
                PrintWriter printWriter = new PrintWriter(stringWriter);
                printWriter.println("/*******************************************************************************");
                printWriter.println(" This source is an example of the Java source necessary ");
                printWriter.println(" to generate a RecordFormat subclass for file " + this.name_ + ".");
                printWriter.println(" IBM grants you a nonexclusive license to use this source.");
                printWriter.println(" You may change and use this souce as necessary.");
                printWriter.println();
                printWriter.println();
                printWriter.println("                            DISCLAIMER");
                printWriter.println("                            ----------");
                printWriter.println();
                printWriter.println(" This source code is provided by IBM for illustrative purposes only.");
                printWriter.println(" The source has not been thoroughly tested under all conditions.");
                printWriter.println(" IBM, therefore, cannot guarantee or imply reliability, serviceability,");
                printWriter.println(" or function of the source.  All source contained herein are provided to you \"AS IS\"");
                printWriter.println(" without any warranties of any kind.");
                printWriter.println(" ALL WARRANTIES, INCLUDING BUT NOT LIMITED TO THE IMPLIED");
                printWriter.println(" WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR");
                printWriter.println(" PURPOSE, ARE EXPRESSLY DISCLAIMED.");
                printWriter.println();
                printWriter.println();
                printWriter.println(" Your license to this source code provides you no right or licenses to");
                printWriter.println(" any IBM patents.  IBM has no obligation to defend or indemnify against");
                printWriter.println(" any claim of infringement, including but not limited to: patents,");
                printWriter.println(" copyright, trade secret, or intellectual property rights of any kind.");
                printWriter.println();
                printWriter.println();
                printWriter.println("             COPYRIGHT");
                printWriter.println("             ---------");
                printWriter.println("Copyright (C) 1997-1999 International Business Machines Corporation and others.");
                printWriter.println("All rights reserved.");
                printWriter.println("US Government Users Restricted Rights -");
                printWriter.println("Use, duplication or disclosure restricted");
                printWriter.println("by GSA ADP Schedule Contract with IBM Corp.");
                printWriter.println("Licensed Material - Property of IBM");
                printWriter.println("********************************************************************************/");
                printWriter.println();
                printWriter.println("// Created by AS400FileRecordDescription on " + new Date());
                printWriter.println();
                if (string != null) {
                    printWriter.println("package " + string + ";");
                }
                printWriter.println();
                printWriter.println("import java.math.BigDecimal;");
                printWriter.println("import com.ibm.as400.access.RecordFormat;");
                printWriter.println("import com.ibm.as400.access.AS400Bin2;");
                printWriter.println("import com.ibm.as400.access.AS400Bin4;");
                printWriter.println("import com.ibm.as400.access.AS400Bin8;");
                printWriter.println("import com.ibm.as400.access.AS400ByteArray;");
                printWriter.println("import com.ibm.as400.access.AS400Float4;");
                printWriter.println("import com.ibm.as400.access.AS400Float8;");
                printWriter.println("import com.ibm.as400.access.AS400PackedDecimal;");
                printWriter.println("import com.ibm.as400.access.AS400Text;");
                printWriter.println("import com.ibm.as400.access.AS400ZonedDecimal;");
                printWriter.println("import com.ibm.as400.access.BinaryFieldDescription;");
                printWriter.println("import com.ibm.as400.access.CharacterFieldDescription;");
                printWriter.println("import com.ibm.as400.access.DateFieldDescription;");
                printWriter.println("import com.ibm.as400.access.DBCSEitherFieldDescription;");
                printWriter.println("import com.ibm.as400.access.DBCSGraphicFieldDescription;");
                printWriter.println("import com.ibm.as400.access.DBCSOnlyFieldDescription;");
                printWriter.println("import com.ibm.as400.access.DBCSOpenFieldDescription;");
                printWriter.println("import com.ibm.as400.access.FieldDescription;");
                printWriter.println("import com.ibm.as400.access.FloatFieldDescription;");
                printWriter.println("import com.ibm.as400.access.HexFieldDescription;");
                printWriter.println("import com.ibm.as400.access.PackedDecimalFieldDescription;");
                printWriter.println("import com.ibm.as400.access.TimeFieldDescription;");
                printWriter.println("import com.ibm.as400.access.TimestampFieldDescription;");
                printWriter.println("import com.ibm.as400.access.ZonedDecimalFieldDescription;");
                printWriter.println();
                printWriter.println("public class " + string4 + "Format extends RecordFormat");
                printWriter.println("{");
                printWriter.println();
                printWriter.println("  public " + string4 + "Format()");
                printWriter.println("  {");
                printWriter.println("    super(\"" + string4 + "\");");
                n2 = ((BigDecimal)recordArray[n4].getField("WHNFLD")).intValue();
                if (n2 > 0) {
                    printWriter.println("    // Add field descriptions to this record format");
                    n6 = 0;
                    while (n6 < n2) {
                        this.writeFieldDescription(printWriter, recordArray[n4]);
                        ++n6;
                        ++n4;
                    }
                }
                if ((n3 = ((BigDecimal)recordArray2[n5].getField("APNKYF")).intValue()) > 0) {
                    printWriter.println("    // Add key field descriptions to this record format");
                    n6 = 0;
                    while (n6 < n3) {
                        printWriter.println("    addKeyFieldDescription(\"" + ((String)recordArray2[n5].getField("APKEYF")).trim() + "\");");
                        ++n6;
                        ++n5;
                    }
                }
                printWriter.println("  }");
                printWriter.println("}");
                if (printWriter.checkError()) {
                    printWriter.close();
                    throw new InternalErrorException("Error writing to sourceFile.", 6);
                }
                printWriter.close();
                stringArray[i + 1] = stringWriter.toString();
            }
            return stringArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Record getSavefileAttributes() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        String string = "DSPFD FILE(" + this.library_ + "/" + this.file_ + ") TYPE(*ATR) FILEATR(*SAVF) OUTPUT(*OUTFILE) OUTFILE(QTEMP/JT4FD)";
        Record[] recordArray = null;
        Object object = lockJT4FD_;
        synchronized (object) {
            AS400Message[] aS400MessageArray = this.theFile_.execute(string);
            if (aS400MessageArray.length > 0) {
                if (!aS400MessageArray[0].getID().equals("CPF9861") && !aS400MessageArray[0].getID().equals("CPF3030")) {
                    throw new AS400Exception(aS400MessageArray);
                }
            } else {
                throw new InternalErrorException("DSPFFD failed to return success message.", 6);
            }
            AS400FileImplBase aS400FileImplBase = (AS400FileImplBase)this.system_.loadImpl("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote");
            aS400FileImplBase.setAll(this.system_, "/QSYS.LIB/QTEMP.LIB/JT4FD.FILE", new SaveFileAttrFormat(this.system_.getCcsid()), false, false, false);
            recordArray = aS400FileImplBase.readAll("seq", 100);
            if (recordArray.length == 0) {
                Trace.log(2, "No records were returned from command " + string);
                throw new InternalErrorException(6);
            }
            aS400FileImplBase.delete();
        }
        return recordArray[0];
    }

    private void parseName(String string) {
        QSYSObjectPathName qSYSObjectPathName = new QSYSObjectPathName(string);
        if (!qSYSObjectPathName.getObjectType().equals("FILE") && !qSYSObjectPathName.getObjectType().equals("MBR")) {
            throw new IllegalPathNameException(string, 1);
        }
        this.library_ = qSYSObjectPathName.getLibraryName();
        this.file_ = qSYSObjectPathName.getObjectName();
        this.member_ = qSYSObjectPathName.getObjectType().equals("FILE") ? "*FIRST" : (qSYSObjectPathName.getMemberName().equalsIgnoreCase("*FILE") ? this.file_ : qSYSObjectPathName.getMemberName());
        this.name_ = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RecordFormat[] retrieveRecordFormat() throws AS400Exception, AS400SecurityException, InterruptedException, IOException {
        String string = "DSPFFD FILE(" + this.library_ + "/" + this.file_ + ") OUTPUT(*OUTFILE) OUTFILE(QTEMP/JT4FFD)";
        Record[] recordArray = null;
        Record[] recordArray2 = lockJT4FFD_;
        synchronized (lockJT4FFD_) {
            Object object = this.theFile_.execute(string);
            if (((AS400Message[])object).length > 0) {
                if (!object[0].getID().equals("CPF9861") && !object[0].getID().equals("CPF3030")) {
                    throw new AS400Exception((AS400Message[])object);
                }
            } else {
                throw new InternalErrorException("DSPFFD failed to return success message", 6);
            }
            AS400Message[] aS400MessageArray = (AS400Message[])this.system_.loadImpl("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote");
            aS400MessageArray.setAll(this.system_, "/QSYS.LIB/QTEMP.LIB/JT4FFD.FILE", new QWHDRFFDFormat(this.system_.getCcsid()), false, false, false);
            recordArray = aS400MessageArray.readAll("seq", 100);
            aS400MessageArray.delete();
            // ** MonitorExit[var3_3] (shouldn't be in output)
            string = "DSPFD FILE(" + this.library_ + "/" + this.file_ + ") TYPE(*ACCPTH) OUTPUT(*OUTFILE) OUTFILE(QTEMP/JT4FD)";
            recordArray2 = null;
            object = lockJT4FD_;
            synchronized (object) {
                aS400MessageArray = this.theFile_.execute(string);
                if (aS400MessageArray.length > 0) {
                    if (!aS400MessageArray[0].getID().equals("CPF9861") && !aS400MessageArray[0].getID().equals("CPF3030")) {
                        throw new AS400Exception(aS400MessageArray);
                    }
                } else {
                    throw new InternalErrorException("DSPFFD failed to return success message", 6);
                }
                AS400FileImplBase aS400FileImplBase = (AS400FileImplBase)this.system_.loadImpl("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote");
                aS400FileImplBase.setAll(this.system_, "/QSYS.LIB/QTEMP.LIB/JT4FD.FILE", new QWHFDACPFormat(this.system_.getCcsid()), false, false, false);
                recordArray2 = aS400FileImplBase.readAll("key", 100);
                aS400FileImplBase.delete();
            }
            int n = ((BigDecimal)recordArray[0].getField("WHCNT")).intValue();
            int n2 = 0;
            int n3 = 0;
            int n4 = 0;
            int n5 = 0;
            RecordFormat[] recordFormatArray = new RecordFormat[n];
            for (int i = 0; i < n; ++i) {
                int n6;
                String string2 = (String)recordArray[n4].getField("WHNAME");
                String string3 = string2.trim();
                recordFormatArray[i] = new RecordFormat(string3);
                n2 = ((BigDecimal)recordArray[n4].getField("WHNFLD")).intValue();
                if (n2 > 0) {
                    n6 = 0;
                    while (n6 < n2) {
                        this.addFieldDescription(recordFormatArray[i], recordArray[n4]);
                        ++n6;
                        ++n4;
                    }
                }
                if ((n3 = ((BigDecimal)recordArray2[n5].getField("APNKYF")).intValue()) <= 0) continue;
                n6 = 0;
                while (n6 < n3) {
                    recordFormatArray[i].addKeyFieldDescription(((String)recordArray2[n5].getField("APKEYF")).trim());
                    ++n6;
                    ++n5;
                }
            }
            return recordFormatArray;
        }
    }

    public void setPath(String string) {
        if (this.theFile_ != null) {
            this.theFile_.setPath(string);
        }
        this.parseName(string);
        this.name_ = string;
    }

    public void setSystem(AS400Impl aS400Impl) {
        if (this.theFile_ == null) {
            this.theFile_ = (AS400FileImplBase)((AS400ImplRemote)aS400Impl).loadImpl("com.ibm.as400.access.AS400FileImplNative", "com.ibm.as400.access.AS400FileImplRemote");
            if (!this.name_.equals("")) {
                this.theFile_.setPath(this.name_);
            }
        }
        this.theFile_.setSystem(aS400Impl);
        this.system_ = (AS400ImplRemote)aS400Impl;
    }

    public void writeFieldDescription(PrintWriter printWriter, Record record) throws UnsupportedEncodingException {
        char c = ((String)record.getField("WHFLDT")).charAt(0);
        Object var4_4 = null;
        String string = ((String)record.getField("WHFLDE")).trim();
        switch (c) {
            case 'A': {
                int n = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (n == 65535) {
                    n = this.system_.getCcsid();
                }
                printWriter.println("    addFieldDescription(new CharacterFieldDescription(new AS400Text(" + String.valueOf(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue()) + ", " + n + "), \"" + string + "\"));");
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        printWriter.println("    ((CharacterFieldDescription)getFieldDescription(\"" + string + "\")).setVARLEN(" + ((BigDecimal)record.getField("WHALLC")).intValue() + ");");
                    } else {
                        printWriter.println("    ((CharacterFieldDescription)getFieldDescription(\"" + string + "\")).setVariableLength(true);");
                    }
                }
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    printWriter.println("    getFieldDescription(\"" + string + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string2 = (String)record.getField("WHDFT");
                if (string2.indexOf("*NULL") != -1) {
                    printWriter.println("    ((CharacterFieldDescription)getFieldDescription(\"" + string + "\")).setDFTNull();");
                    break;
                }
                if (string2.indexOf("'") == -1) break;
                String string3 = string2.substring(string2.indexOf("'") + 1, string2.lastIndexOf("'"));
                printWriter.println("    ((CharacterFieldDescription)getFieldDescription(\"" + string + "\")).setDFT(\"" + string3 + "\");");
                break;
            }
            case 'B': {
                int n = ((BigDecimal)record.getField("WHFLDO")).intValue();
                if (n < 5) {
                    printWriter.println("    addFieldDescription(new BinaryFieldDescription(new AS400Bin2(), \"" + string + "\", \"" + string + "\", " + String.valueOf(n) + "));");
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() > 0) {
                        String string4 = ((String)record.getField("WHDFT")).trim();
                        if (string4.charAt(0) == '+') {
                            string4 = string4.substring(1);
                        }
                        if (string4.indexOf("*NULL") != -1) {
                            printWriter.println("    ((BinaryFieldDescription)getFieldDescription(\"" + string + "\")).setDFTNull();");
                        } else {
                            printWriter.println("    ((BinaryFieldDescription)getFieldDescription(\"" + string + "\")).setDFT(new Short(\"" + string4 + "\"));");
                        }
                    }
                } else if (n < 10) {
                    printWriter.println("    addFieldDescription(new BinaryFieldDescription(new AS400Bin4(), \"" + string + "\", \"" + string + "\", " + String.valueOf(n) + "));");
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() > 0) {
                        String string5 = ((String)record.getField("WHDFT")).trim();
                        if (string5.charAt(0) == '+') {
                            string5 = string5.substring(1);
                        }
                        if (string5.indexOf("*NULL") != -1) {
                            printWriter.println("    ((BinaryFieldDescription)getFieldDescription(\"" + string + "\")).setDFTNull();");
                        } else {
                            printWriter.println("    ((BinaryFieldDescription)getFieldDescription(\"" + string + "\")).setDFT(new Integer(\"" + string5 + "\"));");
                        }
                    }
                } else {
                    printWriter.println("    addFieldDescription(new BinaryFieldDescription(new AS400Bin8(), \"" + string + "\", \"" + string + "\", " + String.valueOf(n) + "));");
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() > 0) {
                        String string6 = ((String)record.getField("WHDFT")).trim();
                        if (string6.charAt(0) == '+') {
                            string6 = string6.substring(1);
                        }
                        if (string6.indexOf("*NULL") != -1) {
                            printWriter.println("    ((BinaryFieldDescription)getFieldDescription(\"" + string + "\")).setDFTNull();");
                        } else {
                            printWriter.println("    ((BinaryFieldDescription)getFieldDescription(\"" + string + "\")).setDFT(new Long(\"" + string6 + "\"));");
                        }
                    }
                }
                if (!((String)record.getField("WHNULL")).equals("Y")) break;
                printWriter.println("    getFieldDescription(\"" + string + "\").setALWNULL(true);");
                break;
            }
            case 'E': {
                int n = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (n == 65535) {
                    n = this.system_.getCcsid();
                }
                printWriter.println("    addFieldDescription(new DBCSEitherFieldDescription(new AS400Text(" + String.valueOf(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue()) + ", " + n + "), \"" + string + "\"));");
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        printWriter.println("    ((DBCSEitherFieldDescription)getFieldDescription(\"" + string + "\")).setVARLEN(" + ((BigDecimal)record.getField("WHALLC")).intValue() + ");");
                    } else {
                        printWriter.println("    ((DBCSEitherFieldDescription)getFieldDescription(\"" + string + "\")).setVariableLength(true);");
                    }
                }
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    printWriter.println("    getFieldDescription(\"" + string + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string7 = (String)record.getField("WHDFT");
                if (string7.indexOf("*NULL") != -1) {
                    printWriter.println("    ((DBCSEitherFieldDescription)getFieldDescription(\"" + string + "\")).setDFTNull();");
                    break;
                }
                if (string7.indexOf("'") == -1) break;
                String string8 = string7.substring(string7.indexOf("'") + 1, string7.lastIndexOf("'"));
                printWriter.println("    ((DBCSEitherFieldDescription)getFieldDescription(\"" + string + "\")).setDFT(\"" + string8 + "\");");
                break;
            }
            case 'F': {
                int n = ((BigDecimal)record.getField("WHFLDO")).intValue();
                int n2 = ((BigDecimal)record.getField("WHFLDP")).intValue();
                int n3 = ((BigDecimal)record.getField("WHFLDB")).intValue();
                if (n3 == 4) {
                    printWriter.println("    addFieldDescription(new FloatFieldDescription(new AS400Float4(), \"" + string + "\", \"" + string + "\", " + String.valueOf(n) + ", " + String.valueOf(n2) + "));");
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() > 0) {
                        String string9 = ((String)record.getField("WHDFT")).trim();
                        if (string9.charAt(0) == '+') {
                            string9 = string9.substring(1);
                        }
                        if (string9.indexOf("*NULL") != -1) {
                            printWriter.println("    ((FloatFieldDescription)getFieldDescription(\"" + string + "\")).setDFTNull();");
                        } else {
                            printWriter.println("    ((FloatFieldDescription)getFieldDescription(\"" + string + "\")).setDFT(new Float(\"" + string9 + "\"));");
                        }
                    }
                } else if (n3 == 8) {
                    printWriter.println("    addFieldDescription(new FloatFieldDescription(new AS400Float8(), \"" + string + "\", \"" + string + "\", " + String.valueOf(n) + ", " + String.valueOf(n2) + "));");
                    printWriter.println("    ((FloatFieldDescription)getFieldDescription(\"" + string + "\")).setFLTPCN(\"*DOUBLE\");");
                    if (((BigDecimal)record.getField("WHDFTL")).intValue() > 0) {
                        String string10 = ((String)record.getField("WHDFT")).trim();
                        if (string10.charAt(0) == '+') {
                            string10 = string10.substring(1);
                        }
                        if (string10.indexOf("*NULL") != -1) {
                            printWriter.println("    ((FloatFieldDescription)getFieldDescription(\"" + string + "\")).setDFTNull();");
                        } else {
                            printWriter.println("    ((FloatFieldDescription)getFieldDescription(\"" + string + "\")).setDFT(new Double(\"" + string10 + "\"));");
                        }
                    }
                } else {
                    throw new InternalErrorException("FloatFieldDescription error in byte length", 6);
                }
                if (!((String)record.getField("WHNULL")).equals("Y")) break;
                printWriter.println("    getFieldDescription(\"" + string + "\").setALWNULL(true);");
                break;
            }
            case 'G': {
                int n = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (n == 65535) {
                    n = this.system_.getCcsid();
                }
                printWriter.println("    addFieldDescription(new DBCSGraphicFieldDescription(new AS400Text(" + String.valueOf(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue()) + ", " + n + "), \"" + string + "\"));");
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        printWriter.println("    ((DBCSGraphicFieldDescription)getFieldDescription(\"" + string + "\")).setVARLEN(" + ((BigDecimal)record.getField("WHALLC")).intValue() + ");");
                    } else {
                        printWriter.println("    ((DBCSGraphicFieldDescription)getFieldDescription(\"" + string + "\")).setVariableLength(true);");
                    }
                }
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    printWriter.println("    getFieldDescription(\"" + string + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string11 = (String)record.getField("WHDFT");
                if (string11.indexOf("*NULL") != -1) {
                    printWriter.println("    ((DBCSGraphicFieldDescription)getFieldDescription(\"" + string + "\")).setDFTNull();");
                    break;
                }
                if (string11.indexOf("'") == -1) break;
                String string12 = string11.substring(string11.indexOf("'") + 1, string11.lastIndexOf("'"));
                printWriter.println("    ((DBCSGraphicFieldDescription)getFieldDescription(\"" + string + "\")).setDFT(\"" + string12 + "\");");
                break;
            }
            case 'H': {
                printWriter.println("    addFieldDescription(new HexFieldDescription(new AS400ByteArray(" + String.valueOf(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue()) + "), \"" + string + "\"));");
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        printWriter.println("    ((HexFieldDescription)getFieldDescription(\"" + string + "\")).setVARLEN(" + ((BigDecimal)record.getField("WHALLC")).intValue() + ");");
                    } else {
                        printWriter.println("    ((HexFieldDescription)getFieldDescription(\"" + string + "\")).setVariableLength(true);");
                    }
                }
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    printWriter.println("    getFieldDescription(\"" + string + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string13 = (String)record.getField("WHDFT");
                if (string13.indexOf("*NULL") != -1) {
                    printWriter.println("    ((HexFieldDescription)getFieldDescription(\"" + string + "\")).setDFTNull();");
                    break;
                }
                if (string13.indexOf("'") == -1) break;
                String string14 = string13.substring(string13.indexOf("'") + 1, string13.lastIndexOf("'"));
                byte[] byArray = string14.getBytes();
                printWriter.print("    ((HexFieldDescription)getFieldDescription(\"" + string + "\")).setDFT(new byte[] { ");
                printWriter.print(byArray[0]);
                for (int i = 1; i < byArray.length; ++i) {
                    printWriter.print(", ");
                    printWriter.print(byArray[i]);
                }
                printWriter.println(" });");
                break;
            }
            case 'J': {
                int n = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (n == 65535) {
                    n = this.system_.getCcsid();
                }
                printWriter.println("    addFieldDescription(new DBCSOnlyFieldDescription(new AS400Text(" + String.valueOf(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue()) + ", " + n + "), \"" + string + "\"));");
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        printWriter.println("    ((DBCSOnlyFieldDescription)getFieldDescription(\"" + string + "\")).setVARLEN(" + ((BigDecimal)record.getField("WHALLC")).intValue() + ");");
                    } else {
                        printWriter.println("    ((DBCSOnlyFieldDescription)getFieldDescription(\"" + string + "\")).setVariableLength(true);");
                    }
                }
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    printWriter.println("    getFieldDescription(\"" + string + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string15 = (String)record.getField("WHDFT");
                if (string15.indexOf("*NULL") != -1) {
                    printWriter.println("    ((DBCSOnlyFieldDescription)getFieldDescription(\"" + string + "\")).setDFTNull();");
                    break;
                }
                if (string15.indexOf("'") == -1) break;
                String string16 = string15.substring(string15.indexOf("'") + 1, string15.lastIndexOf("'"));
                printWriter.println("    ((DBCSOnlyFieldDescription)getFieldDescription(\"" + string + "\")).setDFT(\"" + string16 + "\");");
                break;
            }
            case 'L': {
                int n = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (n == 65535) {
                    n = this.system_.getCcsid();
                }
                printWriter.println("    addFieldDescription(new DateFieldDescription(new AS400Text(" + String.valueOf(((BigDecimal)record.getField("WHFLDB")).intValue()) + ", " + n + "), \"" + string + "\"));");
                printWriter.println("    ((DateFieldDescription)getFieldDescription(\"" + string + "\")).setDATFMT(\"" + (String)record.getField("WHFMT") + "\");");
                if (!((String)record.getField("WHSEP")).equals(" ")) {
                    printWriter.println("    ((DateFieldDescription)getFieldDescription(\"" + string + "\")).setDATSEP(\"" + (String)record.getField("WHSEP") + "\");");
                }
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    printWriter.println("    getFieldDescription(\"" + string + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string17 = (String)record.getField("WHDFT");
                if (string17.indexOf("*NULL") != -1) {
                    printWriter.println("    ((DateFieldDescription)getFieldDescription(\"" + string + "\")).setDFTNull();");
                    break;
                }
                if (string17.indexOf("CURRENT_DATE") != -1) {
                    printWriter.println("    ((DateFieldDescription)getFieldDescription(\"" + string + "\")).setDFTCurrent();");
                    break;
                }
                if (string17.indexOf("'") == -1) break;
                String string18 = string17.substring(string17.indexOf("'") + 1, string17.lastIndexOf("'"));
                printWriter.println("    ((DateFieldDescription)getFieldDescription(\"" + string + "\")).setDFT(\"" + string18 + "\");");
                break;
            }
            case 'O': {
                int n = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (n == 65535) {
                    n = this.system_.getCcsid();
                }
                printWriter.println("    addFieldDescription(new DBCSOpenFieldDescription(new AS400Text(" + String.valueOf(((String)record.getField("WHVARL")).equals("Y") ? ((BigDecimal)record.getField("WHFLDB")).intValue() - 2 : ((BigDecimal)record.getField("WHFLDB")).intValue()) + ", " + n + "), \"" + string + "\"));");
                if (((String)record.getField("WHVARL")).equals("Y")) {
                    if (((BigDecimal)record.getField("WHALLC")).intValue() > 0) {
                        printWriter.println("    ((DBCSOpenFieldDescription)getFieldDescription(\"" + string + "\")).setVARLEN(" + ((BigDecimal)record.getField("WHALLC")).intValue() + ");");
                    } else {
                        printWriter.println("    ((DBCSOpenFieldDescription)getFieldDescription(\"" + string + "\")).setVariableLength(true);");
                    }
                }
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    printWriter.println("    getFieldDescription(\"" + string + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string19 = (String)record.getField("WHDFT");
                if (string19.indexOf("*NULL") != -1) {
                    printWriter.println("    ((DBCSOpenFieldDescription)getFieldDescription(\"" + string + "\")).setDFTNull();");
                    break;
                }
                if (string19.indexOf("'") == -1) break;
                String string20 = string19.substring(string19.indexOf("'") + 1, string19.lastIndexOf("'"));
                printWriter.println("    ((DBCSOpenFieldDescription)getFieldDescription(\"" + string + "\")).setDFT(\"" + string20 + "\");");
                break;
            }
            case 'P': {
                int n = ((BigDecimal)record.getField("WHFLDO")).intValue();
                int n4 = ((BigDecimal)record.getField("WHFLDP")).intValue();
                printWriter.println("    addFieldDescription(new PackedDecimalFieldDescription(new AS400PackedDecimal(" + String.valueOf(n) + ", " + String.valueOf(n4) + "), \"" + string + "\"));");
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    printWriter.println("    getFieldDescription(\"" + string + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string21 = ((String)record.getField("WHDFT")).trim();
                if (string21.charAt(0) == '+') {
                    string21 = string21.substring(1);
                }
                if (string21.indexOf("*NULL") != -1) {
                    printWriter.println("    ((PackedDecimalFieldDescription)getFieldDescription(\"" + string + "\")).setDFTNull();");
                    break;
                }
                printWriter.println("    ((PackedDecimalFieldDescription)getFieldDescription(\"" + string + "\")).setDFT(new BigDecimal(\"" + string21 + "\"));");
                break;
            }
            case 'S': {
                int n = ((BigDecimal)record.getField("WHFLDO")).intValue();
                int n5 = ((BigDecimal)record.getField("WHFLDP")).intValue();
                printWriter.println("    addFieldDescription(new ZonedDecimalFieldDescription(new AS400ZonedDecimal(" + String.valueOf(n) + ", " + String.valueOf(n5) + "), \"" + string + "\"));");
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    printWriter.println("    getFieldDescription(\"" + string + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string22 = ((String)record.getField("WHDFT")).trim();
                if (string22.charAt(0) == '+') {
                    string22 = string22.substring(1);
                }
                if (string22.indexOf("*NULL") != -1) {
                    printWriter.println("    ((ZonedDecimalFieldDescription)getFieldDescription(\"" + string + "\")).setDFTNull();");
                    break;
                }
                printWriter.println("    ((ZonedDecimalFieldDescription)getFieldDescription(\"" + string + "\")).setDFT(new BigDecimal(\"" + string22 + "\"));");
                break;
            }
            case 'T': {
                int n = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (n == 65535) {
                    n = this.system_.getCcsid();
                }
                printWriter.println("    addFieldDescription(new TimeFieldDescription(new AS400Text(" + String.valueOf(((BigDecimal)record.getField("WHFLDB")).intValue()) + ", " + n + "), \"" + string + "\"));");
                printWriter.println("    ((TimeFieldDescription)getFieldDescription(\"" + string + "\")).setTIMFMT(\"" + (String)record.getField("WHFMT") + "\");");
                if (!((String)record.getField("WHSEP")).equals(" ")) {
                    printWriter.println("    ((TimeFieldDescription)getFieldDescription(\"" + string + "\")).setTIMSEP(\"" + (String)record.getField("WHSEP") + "\");");
                }
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    printWriter.println("    getFieldDescription(\"" + string + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string23 = (String)record.getField("WHDFT");
                if (string23.indexOf("*NULL") != -1) {
                    printWriter.println("    ((TimeFieldDescription)getFieldDescription(\"" + string + "\")).setDFTNull();");
                    break;
                }
                if (string23.indexOf("CURRENT_TIME") != -1) {
                    printWriter.println("    ((TimeFieldDescription)getFieldDescription(\"" + string + "\")).setDFTCurrent();");
                    break;
                }
                if (string23.indexOf("'") == -1) break;
                String string24 = string23.substring(string23.indexOf("'") + 1, string23.lastIndexOf("'"));
                printWriter.println("    ((TimeFieldDescription)getFieldDescription(\"" + string + "\")).setDFT(\"" + string24 + "\");");
                break;
            }
            case 'Z': {
                int n = ((BigDecimal)record.getField("WHCCSID")).intValue();
                if (n == 65535) {
                    n = this.system_.getCcsid();
                }
                printWriter.println("    addFieldDescription(new TimestampFieldDescription(new AS400Text(" + String.valueOf(((BigDecimal)record.getField("WHFLDB")).intValue()) + ", " + n + "), \"" + string + "\"));");
                if (((String)record.getField("WHNULL")).equals("Y")) {
                    printWriter.println("    getFieldDescription(\"" + string + "\").setALWNULL(true);");
                }
                if (((BigDecimal)record.getField("WHDFTL")).intValue() <= 0) break;
                String string25 = (String)record.getField("WHDFT");
                if (string25.indexOf("*NULL") != -1) {
                    printWriter.println("    ((TimestampFieldDescription)getFieldDescription(\"" + string + "\")).setDFTNull();");
                    break;
                }
                if (string25.indexOf("CURRENT_TIMESTAMP") != -1) {
                    printWriter.println("    ((TimestampFieldDescription)getFieldDescription(\"" + string + "\")).setDFTCurrent();");
                    break;
                }
                if (string25.indexOf("'") == -1) break;
                String string26 = string25.substring(string25.indexOf("'") + 1, string25.lastIndexOf("'"));
                printWriter.println("    ((TimestampFieldDescription)getFieldDescription(\"" + string + "\")).setDFT(\"" + string26 + "\");");
            }
        }
    }
}

